/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.util;

import com.hervian.lambda.Lambda;
import com.hervian.lambda.LambdaFactory;
import de.effectivecompany.base.datatypes.EFCMap;
import de.effectivecompany.base.util.StringUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectUtil {
    private static Logger logger = LoggerFactory.getLogger(ObjectUtil.class);
    public static EFCMap<String, Lambda> getterMethodCache = new EFCMap();
    public static EFCMap<String, Lambda> setterMethodCache = new EFCMap();

    public static Object getObjectAttributeByName(Object src, String attrName) {
        if (src == null) {
            throw new NullPointerException("source object is null");
        }
        if (attrName == null) {
            throw new NullPointerException("attribute name is null");
        }
        String defaultGetterName = StringUtil.getterName(attrName);
        String boolGetterName = StringUtil.getterName(attrName, Boolean.class);
        String className = src.getClass().getName() + ".";
        Lambda getterMethod = null;
        String getterKey = null;
        getterKey = className + defaultGetterName;
        getterMethod = (Lambda)getterMethodCache.get(getterKey);
        if (getterMethod == null) {
            getterKey = className + boolGetterName;
            getterMethod = (Lambda)getterMethodCache.get(className + boolGetterName);
        }
        if (getterMethod == null) {
            Method[] methods;
            for (Method method : methods = src.getClass().getMethods()) {
                if (method.getName().equalsIgnoreCase(defaultGetterName) && method.getParameterTypes().length == 0) {
                    try {
                        getterMethod = LambdaFactory.create((Method)method);
                    }
                    catch (Throwable e) {
                        throw new RuntimeException("method call failed", e);
                    }
                    getterKey = className + defaultGetterName;
                    getterMethodCache.put(getterKey, getterMethod);
                    break;
                }
                if (!method.getName().equalsIgnoreCase(boolGetterName) || method.getParameterTypes().length != 0) continue;
                try {
                    getterMethod = LambdaFactory.create((Method)method);
                }
                catch (Throwable e) {
                    throw new RuntimeException("method call failed", e);
                }
                getterKey = className + boolGetterName;
                getterMethodCache.put(getterKey, getterMethod);
                break;
            }
        }
        if (getterMethod == null) {
            throw new NullPointerException("could not find getter for attribute '" + attrName + "' on class " + src.getClass().getName());
        }
        try {
            Object returnValue = getterMethod.invoke_for_Object(src);
            return returnValue;
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        catch (Throwable ex) {
            throw new RuntimeException("method call failed", ex);
        }
        return null;
    }

    public static void setObjectAttrBySetter(Object src, String attrName, Object value) {
        if (src == null) {
            throw new NullPointerException("source object is null");
        }
        if (attrName == null) {
            throw new NullPointerException("attribute name is null");
        }
        Method[] methods = src.getClass().getMethods();
        String setterName = StringUtil.setterName(attrName);
        String className = src.getClass().getName() + ".";
        Lambda setterMethod = null;
        setterMethod = (Lambda)setterMethodCache.get(className + setterName);
        if (setterMethod == null) {
            for (Method method : methods) {
                Class<?>[] params = method.getParameterTypes();
                if (!method.getName().equalsIgnoreCase(setterName) || params.length != 1 || value != null && !params[0].isAssignableFrom(value.getClass())) continue;
                try {
                    setterMethod = LambdaFactory.create((Method)method);
                }
                catch (Throwable e) {
                    throw new RuntimeException("method call failed", e);
                }
                setterMethodCache.put(className + setterName, setterMethod);
                break;
            }
        }
        if (setterMethod == null) {
            throw new NullPointerException("could not find setter for attribute '" + attrName + "' on class " + src.getClass().getName());
        }
        try {
            setterMethod.invoke_for_void(src, value);
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        catch (Throwable ex) {
            throw new RuntimeException("method call failed", ex);
        }
    }

    public static Object getAttributeByDomainName(String domain, Object object) {
        Object value = null;
        if (object != null) {
            int dotindex = domain.indexOf(".");
            if (dotindex == -1) {
                return ObjectUtil.getObjectAttributeByName(object, domain);
            }
            String newDomain = domain.substring(dotindex + 1);
            String objectName = domain.substring(0, dotindex);
            String className = object.getClass().getName() + ".";
            try {
                Object newObject;
                Lambda getter = (Lambda)getterMethodCache.get(className + objectName);
                if (getter == null) {
                    getter = LambdaFactory.create((Method)object.getClass().getMethod(StringUtil.getterName(objectName), null));
                    getterMethodCache.put(className + objectName, getter);
                }
                if ((newObject = getter.invoke_for_Object(object)) instanceof List || newObject instanceof Map) {
                    return null;
                }
                return ObjectUtil.getAttributeByDomainName(newDomain, newObject);
            }
            catch (Throwable e) {
                try {
                    Lambda getter = (Lambda)getterMethodCache.get(className + objectName);
                    if (getter == null) {
                        getter = LambdaFactory.create((Method)object.getClass().getMethod(StringUtil.getterName(objectName, Boolean.class), null));
                        getterMethodCache.put(className + objectName, getter);
                    }
                    Object newObject = getter.invoke_for_Object(object);
                    return ObjectUtil.getAttributeByDomainName(newDomain, newObject);
                }
                catch (NoSuchMethodException e1) {
                    e.printStackTrace();
                }
                catch (Throwable e2) {
                    e.printStackTrace();
                }
            }
        }
        return value;
    }

    public static Object getListByDomainName(String domain, Object object) {
        Object value = null;
        if (object != null) {
            int dotindex = domain.indexOf(".");
            if (dotindex == -1) {
                return ObjectUtil.getObjectAttributeByName(object, domain);
            }
            String newDomain = domain.substring(dotindex + 1);
            String objectName = domain.substring(0, dotindex);
            String className = object.getClass().getName() + ".";
            try {
                Lambda getter = (Lambda)getterMethodCache.get(className + objectName);
                if (getter == null) {
                    getter = LambdaFactory.create((Method)object.getClass().getMethod(StringUtil.getterName(objectName), null));
                    getterMethodCache.put(className + objectName, getter);
                }
                Object newObject = getter.invoke_for_Object(object);
                return ObjectUtil.getListByDomainName(newDomain, newObject);
            }
            catch (Throwable e) {
                try {
                    Lambda getter = (Lambda)getterMethodCache.get(className + objectName);
                    if (getter == null) {
                        getter = LambdaFactory.create((Method)object.getClass().getMethod(StringUtil.getterName(objectName, Boolean.class), null));
                        getterMethodCache.put(className + objectName, getter);
                    }
                    Object newObject = getter.invoke_for_Object(object);
                    return ObjectUtil.getListByDomainName(newDomain, newObject);
                }
                catch (NoSuchMethodException e1) {
                    e.printStackTrace();
                }
                catch (Throwable th) {
                    e.printStackTrace();
                }
            }
        }
        return value;
    }

    public static boolean setAttrByDomainViaSetter(String domain, Object object, Object newValue) {
        logger.debug("ObjectTree.setAttrByDomainViaSetter()");
        if (object != null) {
            int dotindex = domain.indexOf(".");
            if (dotindex == -1) {
                ObjectUtil.setObjectAttrBySetter(object, domain, newValue);
            } else {
                String newDomain = domain.substring(dotindex + 1);
                String objectName = domain.substring(0, dotindex);
                try {
                    try {
                        logger.debug("calling getter");
                        Method getter = object.getClass().getMethod(StringUtil.getterName(objectName), null);
                        Object newObject = getter.invoke(object, (Object[])null);
                        if (newObject instanceof List || newObject instanceof Map) {
                            throw new IllegalArgumentException("tree contains a list or map");
                        }
                        return ObjectUtil.setAttrByDomainViaSetter(newDomain, newObject, newValue);
                    }
                    catch (NoSuchMethodException e) {
                        try {
                            Method getter = object.getClass().getMethod(StringUtil.getterName(objectName, Boolean.class), null);
                            Object newObject = getter.invoke(object, (Object[])null);
                            return ObjectUtil.setAttrByDomainViaSetter(newDomain, newObject, newValue);
                        }
                        catch (NoSuchMethodException e1) {
                            return false;
                        }
                    }
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }
}

