/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.client;

import java.io.File;
import java.text.DecimalFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.client.ISVNNotifyAdapter;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNProgressListener;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNProgressEvent;

public class OperationProgressNotifyListener
extends ISVNNotifyAdapter
implements ISVNProgressListener {
    private IProgressMonitor monitor = null;
    private ISVNClientAdapter svnClient;
    private File path;
    private SVNProgressEvent progressEvent;
    private long lastProgress;
    private long lastTotal;
    private long delta;
    private long grandTotal;

    public OperationProgressNotifyListener(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public OperationProgressNotifyListener(IProgressMonitor monitor, ISVNClientAdapter svnClient) {
        this(monitor);
        this.svnClient = svnClient;
    }

    @Override
    public void onNotify(File path, SVNNodeKind kind) {
        this.path = path;
        if (this.monitor != null) {
            this.monitor.worked(1);
            this.subTask();
        }
    }

    @Override
    public void logCompleted(String message) {
        this.clear();
        if (this.monitor != null) {
            this.monitor.subTask(" ");
        }
    }

    public void clear() {
        this.path = null;
        this.progressEvent = null;
        this.lastProgress = 0L;
        this.lastTotal = 0L;
        this.delta = 0L;
        this.grandTotal = 0L;
    }

    public IProgressMonitor getMonitor() {
        return this.monitor;
    }

    public void onProgress(SVNProgressEvent progressEvent) {
        if (this.monitor != null && this.monitor.isCanceled()) {
            if (this.svnClient != null) {
                try {
                    this.svnClient.cancelOperation();
                }
                catch (SVNClientException e) {
                    SVNProviderPlugin.log(SVNException.wrapException((Exception)((Object)e)));
                }
            }
            return;
        }
        this.progressEvent = progressEvent;
        this.delta = progressEvent.getProgress();
        if (progressEvent.getProgress() >= this.lastProgress && progressEvent.getTotal() == this.lastTotal) {
            this.delta = progressEvent.getProgress() - this.lastProgress;
        }
        this.lastProgress = progressEvent.getProgress();
        this.lastTotal = progressEvent.getTotal();
        this.grandTotal += this.delta;
        if (this.monitor != null) {
            this.subTask();
        }
    }

    private void subTask() {
        String subTask = null;
        if (this.progressEvent == null) {
            subTask = this.path.getPath();
        } else {
            String roundedTotal;
            String unit;
            Number t = null;
            if (this.grandTotal < 1000L) {
                t = new Long(this.grandTotal);
                unit = " bytes";
            } else if (this.grandTotal < 1000000L) {
                t = new Double((double)this.grandTotal / 1000.0);
                unit = " kB";
            } else {
                t = new Double((double)this.grandTotal / 1000000.0);
                unit = " MB";
            }
            if (t instanceof Double) {
                DecimalFormat df = new DecimalFormat("###.#");
                roundedTotal = df.format((Double)t);
            } else {
                roundedTotal = ((Object)t).toString();
            }
            subTask = this.path == null ? String.valueOf(roundedTotal) + unit : String.valueOf(roundedTotal) + unit + "\n" + this.path.getPath();
        }
        this.monitor.subTask(subTask);
    }
}

