/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.client;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tigris.subversion.subclipse.core.CancelableSVNStatusCallback;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.ISVNStatusCallback;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class StatusCommand {
    private final File file;
    private final boolean descend;
    private final boolean getAll;
    private final boolean contactServer;
    private ISVNStatusCallback callback;
    private ISVNStatus[] statuses;
    protected List<RevisionsCache> revisions = new ArrayList<RevisionsCache>();

    public StatusCommand(File file, boolean descend, boolean getAll, boolean contactServer) {
        this.file = file;
        this.descend = descend;
        this.getAll = getAll;
        this.contactServer = contactServer;
    }

    protected void execute(ISVNClientAdapter client, IProgressMonitor monitor) throws SVNClientException {
        ISVNNotifyListener revisionListener = new ISVNNotifyListener(){

            public void setCommand(int command) {
            }

            public void logCommandLine(String commandLine) {
            }

            public void logMessage(String message) {
            }

            public void logError(String message) {
            }

            public void logRevision(long aRevision, String path) {
                StatusCommand.this.revisions.add(new RevisionsCache(aRevision, path));
                if (StatusCommand.this.revisions.size() > 1) {
                    Collections.sort(StatusCommand.this.revisions);
                }
            }

            public void logCompleted(String message) {
            }

            public void onNotify(File path, SVNNodeKind kind) {
            }
        };
        try {
            client.addNotifyListener(revisionListener);
            if (this.callback != null && this.callback instanceof CancelableSVNStatusCallback) {
                ((CancelableSVNStatusCallback)this.callback).setSvnClient(client);
            }
            this.statuses = client.getStatus(this.file, this.descend, this.getAll, this.contactServer, false, this.callback);
        }
        finally {
            client.removeNotifyListener(revisionListener);
        }
    }

    public void setCallback(ISVNStatusCallback callback) {
        this.callback = callback;
    }

    public ISVNStatus[] getStatuses() {
        return this.statuses;
    }

    protected SVNRevision.Number getRevisionFor(ISVNStatus status) {
        if (this.revisions.size() == 1) {
            return this.revisions.get(0).getRevision();
        }
        for (RevisionsCache element : this.revisions) {
            if (!element.appliesFor(status.getPath())) continue;
            return element.getRevision();
        }
        return SVNRevision.INVALID_REVISION;
    }

    private static class RevisionsCache
    implements Comparable<RevisionsCache> {
        private final long revision;
        private final String path;

        protected RevisionsCache(long revision, String path) {
            this.revision = revision;
            this.path = path;
        }

        protected String getPath() {
            return this.path;
        }

        protected SVNRevision.Number getRevision() {
            return new SVNRevision.Number(this.revision);
        }

        protected boolean appliesFor(String statusPath) {
            return statusPath.startsWith(this.path);
        }

        @Override
        public int compareTo(RevisionsCache o2) {
            return o2.getPath().compareTo(this.getPath());
        }
    }
}

