/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.tigris.subversion.subclipse.core.ISVNRunnable;
import org.tigris.subversion.subclipse.core.Policy;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.client.OperationManager;
import org.tigris.subversion.subclipse.core.client.OperationProgressNotifyListener;
import org.tigris.subversion.subclipse.core.client.OperationResourceCollector;
import org.tigris.subversion.subclipse.core.commands.ISVNCommand;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNConflictResolver;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class UpdateResourcesCommand
implements ISVNCommand {
    private SVNWorkspaceRoot root;
    private IResource[] resources;
    private SVNRevision revision;
    private int depth = 0;
    private boolean setDepth = false;
    private boolean ignoreExternals = false;
    private boolean force = true;
    private Set<IResource> updatedResources = new LinkedHashSet<IResource>();
    private ISVNConflictResolver conflictResolver;
    private OperationResourceCollector operationResourceCollector = new OperationResourceCollector();

    public UpdateResourcesCommand(SVNWorkspaceRoot root, IResource[] resources, SVNRevision revision) {
        this.root = root;
        this.resources = resources;
        this.revision = revision;
    }

    @Override
    public void run(final IProgressMonitor monitor) throws SVNException {
        final ISVNClientAdapter svnClient = this.root.getRepository().getSVNClient();
        OperationManager.getInstance().beginOperation(svnClient, new OperationProgressNotifyListener(monitor, svnClient));
        try {
            ArrayList<IProject> projectList = new ArrayList<IProject>();
            IResource[] iResourceArray = this.resources;
            int n = this.resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource currentResource = iResourceArray[n2];
                IProject project = currentResource.getProject();
                if (!projectList.contains(project)) {
                    projectList.add(project);
                }
                ++n2;
            }
            if (this.conflictResolver != null) {
                svnClient.addConflictResolutionCallback(this.conflictResolver);
            }
            IProject[] projects = new IProject[projectList.size()];
            projectList.toArray(projects);
            ISchedulingRule rule = MultiRule.combine((ISchedulingRule[])projects);
            SVNProviderPlugin.run(new ISVNRunnable(){

                @Override
                public void run(IProgressMonitor pm) throws SVNException {
                    try {
                        try {
                            monitor.beginTask(null, 100 * UpdateResourcesCommand.this.resources.length);
                            svnClient.addNotifyListener((ISVNNotifyListener)UpdateResourcesCommand.this.operationResourceCollector);
                            if (UpdateResourcesCommand.this.resources.length == 1) {
                                monitor.subTask(UpdateResourcesCommand.this.resources[0].getName());
                                svnClient.update(UpdateResourcesCommand.this.resources[0].getLocation().toFile(), UpdateResourcesCommand.this.revision, UpdateResourcesCommand.this.depth, UpdateResourcesCommand.this.setDepth, UpdateResourcesCommand.this.ignoreExternals, UpdateResourcesCommand.this.force);
                                UpdateResourcesCommand.this.updatedResources.add(UpdateResourcesCommand.this.resources[0]);
                                monitor.worked(100);
                            } else {
                                File[] files = new File[UpdateResourcesCommand.this.resources.length];
                                int i = 0;
                                while (i < UpdateResourcesCommand.this.resources.length) {
                                    files[i] = UpdateResourcesCommand.this.resources[i].getLocation().toFile();
                                    UpdateResourcesCommand.this.updatedResources.add(UpdateResourcesCommand.this.resources[i]);
                                    ++i;
                                }
                                svnClient.update(files, UpdateResourcesCommand.this.revision, UpdateResourcesCommand.this.depth, UpdateResourcesCommand.this.setDepth, UpdateResourcesCommand.this.ignoreExternals, UpdateResourcesCommand.this.force);
                                monitor.worked(100);
                            }
                        }
                        catch (SVNClientException e) {
                            throw SVNException.wrapException((Exception)((Object)e));
                        }
                    }
                    finally {
                        monitor.done();
                        if (svnClient != null) {
                            if (UpdateResourcesCommand.this.conflictResolver != null) {
                                svnClient.addConflictResolutionCallback(null);
                            }
                            svnClient.removeNotifyListener((ISVNNotifyListener)UpdateResourcesCommand.this.operationResourceCollector);
                            UpdateResourcesCommand.this.root.getRepository().returnSVNClient(svnClient);
                        }
                    }
                }
            }, rule, Policy.monitorFor(monitor));
        }
        finally {
            OperationManager.getInstance().endOperation(true, this.operationResourceCollector.getOperationResources());
        }
    }

    public void setConflictResolver(ISVNConflictResolver conflictResolver) {
        this.conflictResolver = conflictResolver;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setSetDepth(boolean setDepth) {
        this.setDepth = setDepth;
    }

    public void setIgnoreExternals(boolean ignoreExternals) {
        this.ignoreExternals = ignoreExternals;
    }

    public void setForce(boolean force) {
        this.force = force;
    }
}

