/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.repo;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.team.core.TeamException;
import org.osgi.service.prefs.BackingStoreException;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.Policy;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.SVNStatus;
import org.tigris.subversion.subclipse.core.repo.SVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.util.Util;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNRepositories {
    private Map<String, ISVNRepositoryLocation> repositories = new HashMap<String, ISVNRepositoryLocation>();
    private static final String REPOSITORIES_STATE_FILE = ".svnProviderState";
    private static final int REPOSITORIES_STATE_FILE_VERSION_1 = 1;
    private static final int REPOSITORIES_STATE_FILE_VERSION_2 = 2;
    private static final int REPOSITORIES_STATE_FILE_VERSION_3 = 3;

    private void addToRepositoriesCache(ISVNRepositoryLocation repository) {
        this.repositories.put(repository.getLocation(), repository);
        SVNProviderPlugin.getPlugin().getRepositoryResourcesManager().repositoryAdded(repository);
    }

    private void removeFromRepositoriesCache(ISVNRepositoryLocation repository) {
        if (this.repositories.remove(repository.getLocation()) != null) {
            SVNProviderPlugin.getPlugin().getRepositoryResourcesManager().repositoryRemoved(repository);
        }
    }

    public void addOrUpdateRepository(ISVNRepositoryLocation repository) throws SVNException {
        SVNRepositoryLocation existingLocation = (SVNRepositoryLocation)this.repositories.get(repository.getLocation());
        if (existingLocation != null) {
            SVNProviderPlugin.getPlugin().getRepositoryResourcesManager().repositoryModified(repository);
            ((SVNRepositoryLocation)repository).updateCache();
        } else {
            this.addToRepositoriesCache(repository);
            ((SVNRepositoryLocation)repository).updateCache();
        }
        this.saveState();
    }

    public void disposeRepository(ISVNRepositoryLocation repository) throws SVNException {
        ((SVNRepositoryLocation)repository).dispose();
        this.removeFromRepositoriesCache(repository);
    }

    public ISVNRepositoryLocation[] getKnownRepositories(IProgressMonitor monitor) {
        IProgressMonitor progress = Policy.monitorFor(monitor);
        IEclipsePreferences prefs = (IEclipsePreferences)SVNRepositoryLocation.getParentPreferences();
        try {
            String[] keys = prefs.childrenNames();
            progress.beginTask(Policy.bind("SVNRepositories.refresh"), keys.length);
            String[] stringArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                block7: {
                    String key = stringArray[n2];
                    progress.worked(1);
                    try {
                        IEclipsePreferences node = (IEclipsePreferences)prefs.node(key);
                        String location = node.get("location", null);
                        if (location == null || this.exactMatchExists(location)) break block7;
                        SVNRepositoryLocation repos = SVNRepositoryLocation.fromString(location);
                        try {
                            repos.validateConnection((IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (SVNException sVNException) {}
                        this.addToRepositoriesCache(repos);
                    }
                    catch (SVNException e) {
                        SVNProviderPlugin.log(e);
                    }
                }
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            SVNProviderPlugin.log(SVNException.wrapException((Exception)((Object)e)));
        }
        progress.done();
        return this.repositories.values().toArray(new ISVNRepositoryLocation[this.repositories.size()]);
    }

    public void refreshRepositoriesFolders(IProgressMonitor monitor) {
        ISVNRepositoryLocation[] repositories;
        ISVNRepositoryLocation[] iSVNRepositoryLocationArray = repositories = this.getKnownRepositories(monitor);
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            ISVNRepositoryLocation repository = iSVNRepositoryLocationArray[n2];
            repository.refreshRootFolder();
            ++n2;
        }
    }

    public ISVNRepositoryLocation createRepository(Properties configuration) throws SVNException {
        SVNRepositoryLocation location = SVNRepositoryLocation.fromProperties(configuration);
        SVNRepositoryLocation existingLocation = (SVNRepositoryLocation)this.repositories.get(location.getLocation());
        if (existingLocation != null) {
            throw new SVNException((IStatus)new SVNStatus(4, Policy.bind("SVNProvider.alreadyExists")));
        }
        return location;
    }

    public ISVNRepositoryLocation getRepository(String location) throws SVNException {
        return this.getRepository(location, true);
    }

    public ISVNRepositoryLocation getRepository(String location, boolean useRootUrl) throws SVNException {
        Set<String> keys = this.repositories.keySet();
        for (String url : keys) {
            if (!url.equals(location) && location.indexOf(String.valueOf(url) + "/") == -1) continue;
            return this.repositories.get(url);
        }
        String normalizedLocation = this.getNormalizedLocation(location);
        if (!normalizedLocation.equals(location)) {
            for (String url : keys) {
                if (!url.equals(normalizedLocation) && normalizedLocation.indexOf(String.valueOf(url) + "/") == -1) continue;
                return this.repositories.get(url);
            }
        }
        SVNRepositoryLocation repository = SVNRepositoryLocation.fromString(location, false, useRootUrl);
        this.addToRepositoriesCache(repository);
        return repository;
    }

    private String getNormalizedLocation(String location) {
        try {
            URL url = new URL(location);
            if (url.getPort() == -1 || url.getDefaultPort() == -1 || url.getPort() != url.getDefaultPort()) {
                return location;
            }
            url = new URL(url.getProtocol(), url.getHost(), -1, url.getPath());
            return url.toString();
        }
        catch (MalformedURLException malformedURLException) {
            return location;
        }
    }

    private void loadState() {
        block4: {
            try {
                IPath pluginStateLocation = SVNProviderPlugin.getPlugin().getStateLocation().append(REPOSITORIES_STATE_FILE);
                File file = pluginStateLocation.toFile();
                if (!file.exists()) break block4;
                try {
                    DataInputStream dis = new DataInputStream(new FileInputStream(file));
                    this.readState(dis);
                    dis.close();
                }
                catch (IOException e) {
                    throw new TeamException((IStatus)new Status(4, "org.tigris.subversion.subclipse.core", -6, Policy.bind("SVNProvider.ioException"), (Throwable)e));
                }
            }
            catch (TeamException e) {
                Util.logError(Policy.bind("SVNProvider.errorLoading"), e);
            }
        }
    }

    private void saveState() {
        try {
            IPath pluginStateLocation = SVNProviderPlugin.getPlugin().getStateLocation();
            File tempFile = pluginStateLocation.append(".svnProviderState.tmp").toFile();
            File stateFile = pluginStateLocation.append(REPOSITORIES_STATE_FILE).toFile();
            try {
                boolean renamed;
                DataOutputStream dos = new DataOutputStream(new FileOutputStream(tempFile));
                this.writeState(dos);
                dos.close();
                if (stateFile.exists()) {
                    stateFile.delete();
                }
                if (!(renamed = tempFile.renameTo(stateFile))) {
                    throw new TeamException((IStatus)new Status(4, "org.tigris.subversion.subclipse.core", -6, Policy.bind("SVNProvider.rename", tempFile.getAbsolutePath()), null));
                }
            }
            catch (IOException e) {
                throw new TeamException((IStatus)new Status(4, "org.tigris.subversion.subclipse.core", -6, Policy.bind("SVNProvider.save", stateFile.getAbsolutePath()), (Throwable)e));
            }
        }
        catch (TeamException e) {
            Util.logError(Policy.bind("SVNProvider.errorSaving"), e);
        }
    }

    private void readState(DataInputStream dis) throws IOException, SVNException {
        int version = dis.readInt();
        if (version < 1 || version > 3) {
            Util.logError(Policy.bind("SVNProviderPlugin.unknownStateFileVersion", new Integer(version).toString()), null);
            return;
        }
        int count = dis.readInt();
        int i = 0;
        while (i < count) {
            String repositoryRoot;
            String label;
            SVNRepositoryLocation root = SVNRepositoryLocation.fromString(dis.readUTF());
            this.addToRepositoriesCache(root);
            if (version >= 2 && !(label = dis.readUTF()).equals("")) {
                root.setLabel(label);
            }
            if (version >= 3 && !(repositoryRoot = dis.readUTF()).equals("")) {
                root.setRepositoryRoot(new SVNUrl(repositoryRoot));
            }
            ++i;
        }
    }

    private void writeState(DataOutputStream dos) throws IOException {
        dos.writeInt(3);
        Collection<ISVNRepositoryLocation> repos = this.repositories.values();
        dos.writeInt(repos.size());
        for (ISVNRepositoryLocation reposLocation : repos) {
            SVNRepositoryLocation root = (SVNRepositoryLocation)reposLocation;
            dos.writeUTF(root.getLocation());
            if (root.getLabel() == null) {
                dos.writeUTF("");
            } else {
                dos.writeUTF(root.getLabel());
            }
            if (root.getRepositoryRoot() == null) {
                dos.writeUTF("");
                continue;
            }
            dos.writeUTF(root.getRepositoryRoot().toString());
        }
        dos.flush();
        dos.close();
    }

    public void startup() {
        this.loadState();
    }

    public void shutdown() {
        this.saveState();
    }

    public boolean isKnownRepository(String location, boolean requireExactMatch) {
        Set<String> keys = this.repositories.keySet();
        for (String checkLocation : keys) {
            if (!requireExactMatch && location.indexOf(checkLocation) != -1) {
                return true;
            }
            if (!location.equals(checkLocation)) continue;
            return true;
        }
        return false;
    }

    public boolean exactMatchExists(String location) {
        Set<String> keys = this.repositories.keySet();
        for (String url : keys) {
            if (!url.equals(location)) continue;
            return true;
        }
        return false;
    }
}

