/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.jrexpressions.validation;

import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.editor.expression.ExpressionContextUtils;
import com.jaspersoft.studio.editor.expression.ExpressionEditorSupportUtil;
import com.jaspersoft.studio.editor.expression.FunctionsLibraryUtil;
import com.jaspersoft.studio.editor.jrexpressions.functions.AdditionalStaticFunctions;
import com.jaspersoft.studio.editor.jrexpressions.javaJRExpression.FullMethodName;
import com.jaspersoft.studio.editor.jrexpressions.javaJRExpression.JRFieldObj;
import com.jaspersoft.studio.editor.jrexpressions.javaJRExpression.JRParameterObj;
import com.jaspersoft.studio.editor.jrexpressions.javaJRExpression.JRResourceBundleKeyObj;
import com.jaspersoft.studio.editor.jrexpressions.javaJRExpression.JRVariableObj;
import com.jaspersoft.studio.editor.jrexpressions.javaJRExpression.JavaJRExpressionPackage;
import com.jaspersoft.studio.editor.jrexpressions.javaJRExpression.MethodInvocation;
import com.jaspersoft.studio.editor.jrexpressions.javaJRExpression.MethodsExpression;
import com.jaspersoft.studio.editor.jrexpressions.messages.Messages;
import com.jaspersoft.studio.editor.jrexpressions.validation.AbstractJavaJRExpressionJavaValidator;
import java.util.List;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRVariable;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;

public class JavaJRExpressionJavaValidator
extends AbstractJavaJRExpressionJavaValidator {
    @Check
    public void checkLibraryFunctionName(FullMethodName name) {
        MethodsExpression expression;
        MethodInvocation method;
        if (name.eContainer() instanceof MethodInvocation && (method = (MethodInvocation)name.eContainer()).eContainer() instanceof MethodsExpression && !(expression = (MethodsExpression)method.eContainer()).isIncludeObjectInstatiation() && (name.getPrefixQMN() == null || name.getPrefixQMN().size() == 0) && expression.getObjectExpression() == null && method.equals(expression.getMethodInvocations().get(0)) && !FunctionsLibraryUtil.existsFunction((String)name.getMethodName()) && !AdditionalStaticFunctions.getAllNames().contains(name.getMethodName())) {
            this.error(Messages.JavaJRExpressionJavaValidator_FunctionNotFoundError, name, (EStructuralFeature)JavaJRExpressionPackage.Literals.FULL_METHOD_NAME__METHOD_NAME, 2);
        }
    }

    @Check
    public void checkFieldName(JRFieldObj field) {
        ExpressionContext currExpContext = ExpressionEditorSupportUtil.safeGetCurrentExpressionContext();
        List allFields = ExpressionContextUtils.getAllDatasetsFields((ExpressionContext)currExpContext);
        for (JRField f : allFields) {
            if (!("{" + f.getName() + "}").equals(field.getBracedIdentifier())) continue;
            return;
        }
        this.error(Messages.JavaJRExpressionJavaValidator_FieldNotFoundInContextError, field, (EStructuralFeature)JavaJRExpressionPackage.Literals.JR_FIELD_OBJ__BRACED_IDENTIFIER, 0);
    }

    @Check
    public void checkVariableName(JRVariableObj variable) {
        ExpressionContext currExpContext = ExpressionEditorSupportUtil.safeGetCurrentExpressionContext();
        List allVariables = ExpressionContextUtils.getAllDatasetsVariables((ExpressionContext)currExpContext);
        for (JRVariable v : allVariables) {
            if (!("{" + v.getName() + "}").equals(variable.getBracedIdentifier())) continue;
            return;
        }
        List allCrosstabsVariables = ExpressionContextUtils.getAllCrosstabsVariables((ExpressionContext)currExpContext);
        for (JRVariable v : allCrosstabsVariables) {
            if (!("{" + v.getName() + "}").equals(variable.getBracedIdentifier())) continue;
            return;
        }
        this.error(Messages.JavaJRExpressionJavaValidator_VariableNotFoundInContextError, variable, (EStructuralFeature)JavaJRExpressionPackage.Literals.JR_VARIABLE_OBJ__BRACED_IDENTIFIER, 0);
    }

    @Check
    public void checkParameterName(JRParameterObj parameter) {
        ExpressionContext currExpContext = ExpressionEditorSupportUtil.safeGetCurrentExpressionContext();
        List allParameters = ExpressionContextUtils.getAllDatasetsParameters((ExpressionContext)currExpContext);
        for (JRParameter p : allParameters) {
            if (!("{" + p.getName() + "}").equals(parameter.getBracedIdentifier())) continue;
            return;
        }
        List allCrosstabsParameters = ExpressionContextUtils.getAllCrosstabsParameters((ExpressionContext)currExpContext);
        for (JRParameter p : allCrosstabsParameters) {
            if (!("{" + p.getName() + "}").equals(parameter.getBracedIdentifier())) continue;
            return;
        }
        this.error(Messages.JavaJRExpressionJavaValidator_ParameterNotFoundInContextError, parameter, (EStructuralFeature)JavaJRExpressionPackage.Literals.JR_PARAMETER_OBJ__BRACED_IDENTIFIER, 0);
    }

    @Check
    public void checkResourceBunleKey(JRResourceBundleKeyObj rbk) {
        ExpressionContext currExpContext = ExpressionEditorSupportUtil.safeGetCurrentExpressionContext();
        List rbKeys = ExpressionContextUtils.getResourceBundleKeys((ExpressionContext)currExpContext);
        for (String k : rbKeys) {
            if (!("{" + k + "}").equals(rbk.getBracedIdentifier())) continue;
            return;
        }
        this.error(Messages.JavaJRExpressionJavaValidator_RBKNotFoundInContextError, rbk, (EStructuralFeature)JavaJRExpressionPackage.Literals.JR_RESOURCE_BUNDLE_KEY_OBJ__BRACED_IDENTIFIER, 0);
    }
}

