/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.JRParagraph;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.TabStop;
import net.sf.jasperreports.engine.type.HorizontalTextAlignEnum;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextUtil;
import net.sf.jasperreports.engine.util.JRTextAttribute;
import net.sf.jasperreports.engine.util.ParagraphUtil;
import net.sf.jasperreports.engine.util.StyledTextListWriter;
import net.sf.jasperreports.engine.util.StyledTextWriteContext;

public abstract class AbstractTextRenderer {
    public static final FontRenderContext LINE_BREAK_FONT_RENDER_CONTEXT = new FontRenderContext(null, true, true);
    protected final JasperReportsContext jasperReportsContext;
    protected final JRPropertiesUtil propUtil;
    protected JRPrintText text;
    protected JRStyledText styledText;
    protected String allText;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected int topPadding;
    protected int leftPadding;
    protected int bottomPadding;
    protected int rightPadding;
    protected float verticalAlignOffset;
    protected float drawPosY;
    protected float drawPosX;
    protected float lineHeight;
    protected boolean isMaxHeightReached;
    protected boolean isFirstParagraph;
    protected boolean isLastParagraph;
    protected List<TabSegment> segments;
    protected int segmentIndex;
    protected boolean indentFirstLine;
    protected boolean justifyLastLine;
    protected int htmlListIndent;
    protected String bulletText;
    protected AttributedString bulletChunk;
    private final boolean isMinimizePrinterJobSize;
    protected final boolean ignoreMissingFont;
    private final boolean defaultIndentFirstLine;
    private final boolean defaultJustifyLastLine;

    public AbstractTextRenderer(JasperReportsContext jasperReportsContext, boolean isMinimizePrinterJobSize, boolean ignoreMissingFont) {
        this(jasperReportsContext, isMinimizePrinterJobSize, ignoreMissingFont, true, false);
    }

    public AbstractTextRenderer(JasperReportsContext jasperReportsContext, boolean isMinimizePrinterJobSize, boolean ignoreMissingFont, boolean defaultIndentFirstLine, boolean defaultJustifyLastLine) {
        this.jasperReportsContext = jasperReportsContext;
        this.propUtil = JRPropertiesUtil.getInstance(jasperReportsContext);
        this.isMinimizePrinterJobSize = isMinimizePrinterJobSize;
        this.ignoreMissingFont = ignoreMissingFont;
        this.defaultIndentFirstLine = defaultIndentFirstLine;
        this.defaultJustifyLastLine = defaultJustifyLastLine;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getTopPadding() {
        return this.topPadding;
    }

    public int getLeftPadding() {
        return this.leftPadding;
    }

    public int getBottomPadding() {
        return this.bottomPadding;
    }

    public int getRightPadding() {
        return this.rightPadding;
    }

    public JRStyledText getStyledText() {
        return this.styledText;
    }

    public String getPlainText() {
        return this.allText;
    }

    public void initialize(JRPrintText text, JRStyledText styledText, int offsetX, int offsetY) {
        this.styledText = styledText;
        this.allText = styledText.getText();
        this.x = text.getX() + offsetX;
        this.y = text.getY() + offsetY;
        this.width = text.getWidth();
        this.height = text.getHeight();
        this.topPadding = text.getLineBox().getTopPadding();
        this.leftPadding = text.getLineBox().getLeftPadding();
        this.bottomPadding = text.getLineBox().getBottomPadding();
        this.rightPadding = text.getLineBox().getRightPadding();
        switch (text.getRotationValue()) {
            case LEFT: {
                this.y = text.getY() + offsetY + text.getHeight();
                this.width = text.getHeight();
                this.height = text.getWidth();
                int tmpPadding = this.topPadding;
                this.topPadding = this.leftPadding;
                this.leftPadding = this.bottomPadding;
                this.bottomPadding = this.rightPadding;
                this.rightPadding = tmpPadding;
                break;
            }
            case RIGHT: {
                this.x = text.getX() + offsetX + text.getWidth();
                this.width = text.getHeight();
                this.height = text.getWidth();
                int tmpPadding = this.topPadding;
                this.topPadding = this.rightPadding;
                this.rightPadding = this.bottomPadding;
                this.bottomPadding = this.leftPadding;
                this.leftPadding = tmpPadding;
                break;
            }
            case UPSIDE_DOWN: {
                int tmpPadding = this.topPadding;
                this.x = text.getX() + offsetX + text.getWidth();
                this.y = text.getY() + offsetY + text.getHeight();
                this.topPadding = this.bottomPadding;
                this.bottomPadding = tmpPadding;
                tmpPadding = this.leftPadding;
                this.leftPadding = this.rightPadding;
                this.rightPadding = tmpPadding;
                break;
            }
        }
        this.text = text;
        this.verticalAlignOffset = 0.0f;
        switch (text.getVerticalTextAlign()) {
            case BOTTOM: {
                this.verticalAlignOffset = (float)(this.height - this.topPadding - this.bottomPadding) - text.getTextHeight();
                break;
            }
            case MIDDLE: {
                this.verticalAlignOffset = ((float)(this.height - this.topPadding - this.bottomPadding) - text.getTextHeight()) / 2.0f;
                break;
            }
            default: {
                this.verticalAlignOffset = 0.0f;
            }
        }
        this.indentFirstLine = this.defaultIndentFirstLine;
        if (text.getPropertiesMap().containsProperty("net.sf.jasperreports.awt.indent.first.line")) {
            this.indentFirstLine = this.propUtil.getBooleanProperty(text, "net.sf.jasperreports.awt.indent.first.line", this.defaultIndentFirstLine);
        }
        this.justifyLastLine = this.defaultJustifyLastLine;
        if (text.getPropertiesMap().containsProperty("net.sf.jasperreports.awt.justify.last.line")) {
            this.justifyLastLine = this.propUtil.getBooleanProperty(text, "net.sf.jasperreports.awt.justify.last.line", this.defaultJustifyLastLine);
        }
        this.drawPosY = 0.0f;
        this.drawPosX = 0.0f;
        this.isMaxHeightReached = false;
        this.isLastParagraph = false;
    }

    public void render() {
        StyledTextWriteContext context = new StyledTextWriteContext();
        StyledTextListWriter listWriter = this.getListWriter();
        AttributedCharacterIterator allParagraphs = this.getAttributedString().getIterator();
        this.isFirstParagraph = true;
        int runLimit = 0;
        while (runLimit < allParagraphs.getEndIndex() && (runLimit = allParagraphs.getRunLimit(JRTextAttribute.HTML_LIST_ATTRIBUTES)) <= allParagraphs.getEndIndex()) {
            Map<AttributedCharacterIterator.Attribute, Object> attributes = allParagraphs.getAttributes();
            context.next(attributes);
            context.writeLists(listWriter);
            this.prepareBullet(context, attributes);
            String runText = this.allText.substring(allParagraphs.getIndex(), runLimit);
            AttributedCharacterIterator runParagraphs = new AttributedString(allParagraphs, allParagraphs.getIndex(), allParagraphs.getIndex() + runText.length()).getIterator();
            int tokenPosition = 0;
            int prevParagraphStart = 0;
            String prevParagraphText = null;
            StringTokenizer tkzer = new StringTokenizer(runText, "\n", true);
            while (tkzer.hasMoreTokens() && !this.isMaxHeightReached) {
                String token = tkzer.nextToken();
                if ("\n".equals(token)) {
                    if (tokenPosition > 0 || context.isListItemStart() || !context.isListItemEnd() && !context.isListStart() && !context.isListEnd()) {
                        this.renderParagraph(runParagraphs, prevParagraphStart, prevParagraphText);
                    }
                    this.isFirstParagraph = false;
                    this.isLastParagraph = !tkzer.hasMoreTokens();
                    prevParagraphStart = tokenPosition + (tkzer.hasMoreTokens() || tokenPosition == 0 ? 1 : 0);
                    prevParagraphText = null;
                } else {
                    prevParagraphStart = tokenPosition;
                    prevParagraphText = token;
                }
                tokenPosition += token.length();
            }
            if (!this.isMaxHeightReached && prevParagraphStart < runText.length()) {
                this.isLastParagraph = true;
                if (prevParagraphText != null || runLimit == allParagraphs.getEndIndex()) {
                    this.renderParagraph(runParagraphs, prevParagraphStart, prevParagraphText);
                }
            }
            allParagraphs.setIndex(runLimit);
        }
        context.next(null);
        context.writeLists(listWriter);
    }

    protected StyledTextListWriter getListWriter() {
        return null;
    }

    protected void renderParagraph(AttributedCharacterIterator allParagraphs, int paragraphStart, String paragraphText) {
        AttributedCharacterIterator paragraph = null;
        if (paragraphText == null) {
            paragraphText = " ";
            paragraph = new AttributedString(paragraphText, new AttributedString(allParagraphs, paragraphStart, paragraphStart + paragraphText.length()).getIterator().getAttributes()).getIterator();
        } else {
            paragraph = new AttributedString(allParagraphs, paragraphStart, paragraphStart + paragraphText.length()).getIterator();
        }
        List<Integer> tabIndexes = JRStringUtil.getTabIndexes(paragraphText);
        int currentTab = 0;
        int lines = 0;
        float endX = 0.0f;
        TabStop nextTabStop = null;
        boolean requireNextWord = false;
        LineBreakMeasurer lineMeasurer = new LineBreakMeasurer(paragraph, this.getFontRenderContext());
        while (lineMeasurer.getPosition() < paragraph.getEndIndex() && !this.isMaxHeightReached) {
            boolean lineComplete = false;
            float maxAscent = 0.0f;
            float maxDescent = 0.0f;
            float maxLeading = 0.0f;
            this.segments = new ArrayList<TabSegment>(1);
            TabSegment oldSegment = null;
            TabSegment crtSegment = null;
            while (!lineComplete) {
                AttributedString tmpText;
                int firstLineIndent;
                int tabIndexOrEndIndex = tabIndexes == null || currentTab >= tabIndexes.size() ? paragraph.getEndIndex() : tabIndexes.get(currentTab) + 1;
                int n = firstLineIndent = lineMeasurer.getPosition() == 0 ? this.text.getParagraph().getFirstLineIndent() : 0;
                if (firstLineIndent != 0 && this.isFirstParagraph && !this.indentFirstLine) {
                    firstLineIndent = 0;
                }
                float startX = this.htmlListIndent + firstLineIndent + this.leftPadding;
                endX = this.width - this.text.getParagraph().getRightIndent() - this.rightPadding;
                endX = endX < startX ? startX : endX;
                int startIndex = lineMeasurer.getPosition();
                float rightX = 0.0f;
                if (this.segments.size() == 0) {
                    rightX = startX;
                } else {
                    rightX = oldSegment.rightX;
                    nextTabStop = ParagraphUtil.getNextTabStop(this.text.getParagraph(), endX, rightX);
                }
                float availableWidth = endX - (float)this.text.getParagraph().getLeftIndent().intValue() - ParagraphUtil.getSegmentOffset(nextTabStop, rightX);
                TextLayout layout = lineMeasurer.nextLayout(availableWidth, tabIndexOrEndIndex, requireNextWord);
                if (layout != null) {
                    tmpText = new AttributedString(paragraph, startIndex, startIndex + layout.getCharacterCount());
                    if (this.isMinimizePrinterJobSize) {
                        layout = new TextLayout(tmpText.getIterator(), this.getFontRenderContext());
                    }
                    if (this.text.getHorizontalTextAlign() == HorizontalTextAlignEnum.JUSTIFIED && (lineMeasurer.getPosition() < paragraph.getEndIndex() || this.isLastParagraph && this.justifyLastLine)) {
                        layout = layout.getJustifiedLayout(availableWidth);
                    }
                    maxAscent = Math.max(maxAscent, layout.getAscent());
                    maxDescent = Math.max(maxDescent, layout.getDescent());
                    maxLeading = Math.max(maxLeading, layout.getLeading());
                    crtSegment = new TabSegment();
                    crtSegment.layout = layout;
                    crtSegment.as = tmpText;
                    crtSegment.text = paragraphText.substring(startIndex, startIndex + layout.getCharacterCount());
                    crtSegment.isLastLine = lineMeasurer.getPosition() == paragraph.getEndIndex();
                    float advance = layout.getVisibleAdvance();
                    float leftX = ParagraphUtil.getLeftX(nextTabStop, advance);
                    if (rightX > leftX) {
                        crtSegment.leftX = rightX;
                        crtSegment.rightX = rightX + advance;
                    } else {
                        crtSegment.leftX = leftX;
                        crtSegment.rightX = ParagraphUtil.getRightX(nextTabStop, advance);
                    }
                    this.segments.add(crtSegment);
                }
                requireNextWord = true;
                if (lineMeasurer.getPosition() == tabIndexOrEndIndex) {
                    ++currentTab;
                }
                if (lineMeasurer.getPosition() == paragraph.getEndIndex()) {
                    lineComplete = true;
                    nextTabStop = null;
                } else if (lineMeasurer.getPosition() == tabIndexOrEndIndex) {
                    if (crtSegment.rightX >= (float)ParagraphUtil.getLastTabStop(this.text.getParagraph(), endX).getPosition()) {
                        lineComplete = true;
                        nextTabStop = ParagraphUtil.getFirstTabStop(this.text.getParagraph(), endX);
                    }
                } else {
                    lineComplete = true;
                    if (layout == null) {
                        if (nextTabStop.getPosition() == ParagraphUtil.getFirstTabStop(this.text.getParagraph(), endX).getPosition()) {
                            nextTabStop = null;
                            requireNextWord = false;
                            tmpText = new AttributedString(paragraph, startIndex, startIndex + 1);
                            LineBreakMeasurer lbm = new LineBreakMeasurer(tmpText.getIterator(), this.getFontRenderContext());
                            TextLayout tlyt = lbm.nextLayout(100.0f);
                            maxAscent = tlyt.getAscent();
                            maxDescent = tlyt.getDescent();
                            maxLeading = tlyt.getLeading();
                        } else {
                            nextTabStop = ParagraphUtil.getFirstTabStop(this.text.getParagraph(), endX);
                        }
                    } else {
                        nextTabStop = null;
                        requireNextWord = false;
                    }
                }
                oldSegment = crtSegment;
            }
            this.lineHeight = AbstractTextRenderer.getLineHeight(paragraphStart == 0 && lines == 0, this.text.getParagraph(), maxLeading, maxAscent);
            if (paragraphStart == 0 && lines == 0) {
                this.lineHeight += (float)this.text.getParagraph().getSpacingBefore().intValue();
            }
            if (this.drawPosY + this.lineHeight <= this.text.getTextHeight()) {
                ++lines;
                this.drawPosY += this.lineHeight;
                float lastRightX = this.segments == null || this.segments.size() == 0 ? 0.0f : this.segments.get((int)(this.segments.size() - 1)).rightX;
                this.segmentIndex = 0;
                while (this.segmentIndex < this.segments.size()) {
                    TabSegment segment = this.segments.get(this.segmentIndex);
                    TextLayout layout = segment.layout;
                    switch (this.text.getHorizontalTextAlign()) {
                        case JUSTIFIED: {
                            if (layout.isLeftToRight()) {
                                this.drawPosX = (float)this.text.getParagraph().getLeftIndent().intValue() + segment.leftX;
                                break;
                            }
                            this.drawPosX = endX - lastRightX + segment.leftX;
                            break;
                        }
                        case RIGHT: {
                            this.drawPosX = endX - lastRightX + segment.leftX;
                            break;
                        }
                        case CENTER: {
                            this.drawPosX = (endX - lastRightX) / 2.0f + segment.leftX;
                            break;
                        }
                        default: {
                            this.drawPosX = (float)this.text.getParagraph().getLeftIndent().intValue() + segment.leftX;
                        }
                    }
                    this.draw();
                    this.bulletText = null;
                    this.bulletChunk = null;
                    ++this.segmentIndex;
                }
                this.drawPosY += maxDescent;
                continue;
            }
            this.isMaxHeightReached = true;
        }
    }

    private void prepareBullet(StyledTextWriteContext context, Map<AttributedCharacterIterator.Attribute, Object> attributes) {
        this.htmlListIndent = context.getDepth() * 50;
        this.bulletText = JRStyledTextUtil.getBulletText(context);
        this.bulletChunk = this.bulletText == null ? null : new AttributedString(this.bulletText, attributes);
    }

    protected AttributedString getAttributedString() {
        return this.styledText.getAwtAttributedString(this.jasperReportsContext, this.ignoreMissingFont);
    }

    public abstract void draw();

    public static float getLineHeight(boolean isFirstLine, JRParagraph paragraph, float maxLeading, float maxAscent) {
        float lineHeight = 0.0f;
        switch (paragraph.getLineSpacing()) {
            default: {
                lineHeight = maxLeading + 1.0f * maxAscent;
                break;
            }
            case ONE_AND_HALF: {
                if (isFirstLine) {
                    lineHeight = maxLeading + 1.0f * maxAscent;
                    break;
                }
                lineHeight = maxLeading + 1.5f * maxAscent;
                break;
            }
            case DOUBLE: {
                if (isFirstLine) {
                    lineHeight = maxLeading + 1.0f * maxAscent;
                    break;
                }
                lineHeight = maxLeading + 2.0f * maxAscent;
                break;
            }
            case PROPORTIONAL: {
                if (isFirstLine) {
                    lineHeight = maxLeading + 1.0f * maxAscent;
                    break;
                }
                lineHeight = maxLeading + paragraph.getLineSpacingSize().floatValue() * maxAscent;
                break;
            }
            case AT_LEAST: {
                if (isFirstLine) {
                    lineHeight = maxLeading + 1.0f * maxAscent;
                    break;
                }
                lineHeight = Math.max(maxLeading + 1.0f * maxAscent, paragraph.getLineSpacingSize().floatValue());
                break;
            }
            case FIXED: {
                lineHeight = isFirstLine ? maxLeading + 1.0f * maxAscent : paragraph.getLineSpacingSize().floatValue();
            }
        }
        return lineHeight;
    }

    public FontRenderContext getFontRenderContext() {
        return LINE_BREAK_FONT_RENDER_CONTEXT;
    }

    public static class TabSegment {
        public TextLayout layout;
        public AttributedString as;
        public String text;
        public float leftX;
        public float rightX;
        public boolean isLastLine;
    }
}

