/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.javahl;

import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.subversion.javahl.types.ChangePath;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNLogMessageChangePath;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.javahl.JhlConverter;

public class JhlLogMessage
implements ISVNLogMessage {
    private static final String EMPTY = "";
    private List<ISVNLogMessage> children;
    private boolean hasChildren;
    private ISVNLogMessageChangePath[] changedPaths;
    private SVNRevision.Number revision;
    private Map<String, byte[]> revprops;
    private static final DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS z");
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private long timeMicros;
    private Calendar cachedDate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JhlLogMessage(Set<ChangePath> changedPaths, long revision, Map<String, byte[]> revprops, boolean hasChildren) {
        block6: {
            this.changedPaths = JhlConverter.convertChangePaths(changedPaths);
            this.revision = new SVNRevision.Number(revision);
            this.revprops = revprops;
            if (this.revprops == null) {
                this.revprops = new HashMap<String, byte[]>(2);
                this.revprops.put("svn:author", EMPTY.getBytes());
                this.revprops.put("svn:log", EMPTY.getBytes());
                this.revprops.put("svn:date", EMPTY.getBytes());
            }
            this.hasChildren = hasChildren;
            try {
                Date date;
                String datestr = new String(this.revprops.get("svn:date"));
                if (datestr == null || datestr.length() != 27 || datestr.charAt(26) != 'Z') break block6;
                DateFormat dateFormat = formatter;
                synchronized (dateFormat) {
                    date = formatter.parse(datestr.substring(0, 23) + " UTC");
                }
                this.cachedDate = Calendar.getInstance(UTC);
                this.cachedDate.setTime(date);
                this.timeMicros = this.cachedDate.getTimeInMillis() * 1000L + (long)Integer.parseInt(datestr.substring(23, 26));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void addChild(ISVNLogMessage msg) {
        if (this.children == null) {
            this.children = new ArrayList<ISVNLogMessage>();
        }
        this.children.add(msg);
    }

    public SVNRevision.Number getRevision() {
        return this.revision;
    }

    public String getAuthor() {
        byte[] author = this.revprops.get("svn:author");
        if (author == null) {
            return EMPTY;
        }
        try {
            return new String(author, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            return new String(author);
        }
    }

    public Date getDate() {
        if (this.cachedDate == null) {
            return new Date(0L);
        }
        return this.cachedDate.getTime();
    }

    public String getMessage() {
        byte[] message = this.revprops.get("svn:log");
        if (message == null) {
            return EMPTY;
        }
        try {
            return new String(message, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            return new String(message);
        }
    }

    public ISVNLogMessageChangePath[] getChangedPaths() {
        return this.changedPaths;
    }

    public String toString() {
        return this.getMessage();
    }

    public ISVNLogMessage[] getChildMessages() {
        if (this.hasChildren && this.children != null) {
            ISVNLogMessage[] childArray = new JhlLogMessage[this.children.size()];
            this.children.toArray(childArray);
            return childArray;
        }
        return null;
    }

    public long getNumberOfChildren() {
        if (this.hasChildren && this.children != null) {
            return this.children.size();
        }
        return 0L;
    }

    public long getTimeMillis() {
        if (this.cachedDate == null) {
            return 0L;
        }
        return this.cachedDate.getTimeInMillis();
    }

    public long getTimeMicros() {
        return this.timeMicros;
    }

    public boolean hasChildren() {
        return this.hasChildren;
    }
}

