/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.community;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.community.messages.Messages;
import com.jaspersoft.studio.community.utils.CommunityUser;
import net.sf.jasperreports.eclipse.AbstractJRUIPlugin;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.SecureStorageUtils;
import org.eclipse.equinox.security.storage.StorageException;
import org.osgi.framework.BundleContext;

public class JSSCommunityActivator
extends AbstractJRUIPlugin {
    public static final String PLUGIN_ID = "com.jaspersoft.studio.community";
    private static JSSCommunityActivator plugin;
    private static final String NOT_AVAILABLE_VALUE = "n/a";
    private static final String USERNAME_KEY = "username";
    private static final String PASSWORD_KEY = "password";

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static JSSCommunityActivator getDefault() {
        return plugin;
    }

    public String getPluginID() {
        return PLUGIN_ID;
    }

    public void storeCommunityUserInformation(CommunityUser user) {
        if (JaspersoftStudioPlugin.shouldUseSecureStorage()) {
            try {
                SecureStorageUtils.saveToDefaultSecurePreferences((String)"jaspersoft_community_site", (String)USERNAME_KEY, (String)user.getUsername());
                SecureStorageUtils.saveToDefaultSecurePreferences((String)"jaspersoft_community_site", (String)PASSWORD_KEY, (String)user.getPassword());
            }
            catch (StorageException ex) {
                this.logError(Messages.JSSCommunityActivator_CredentialsStoreError, ex);
                UIUtils.showError((Throwable)ex);
            }
        } else {
            JSSCommunityActivator.getDefault().getPreferenceStore().putValue(USERNAME_KEY, user.getUsername());
            JSSCommunityActivator.getDefault().getPreferenceStore().putValue(PASSWORD_KEY, user.getPassword());
        }
    }

    public CommunityUser getCommunityUserInformation() {
        if (JaspersoftStudioPlugin.shouldUseSecureStorage()) {
            try {
                String username = SecureStorageUtils.readFromDefaultSecurePreferences((String)"jaspersoft_community_site", (String)USERNAME_KEY, (String)NOT_AVAILABLE_VALUE);
                String password = SecureStorageUtils.readFromDefaultSecurePreferences((String)"jaspersoft_community_site", (String)PASSWORD_KEY, (String)NOT_AVAILABLE_VALUE);
                if (username != null && !NOT_AVAILABLE_VALUE.equals(username) && password != null && !NOT_AVAILABLE_VALUE.equals(password)) {
                    return new CommunityUser(username, password);
                }
            }
            catch (StorageException ex) {
                this.logError(Messages.JSSCommunityActivator_CredentialsRecoveringError, ex);
                UIUtils.showError((Throwable)ex);
            }
            return null;
        }
        String username = null;
        if (JSSCommunityActivator.getDefault().getPreferenceStore().contains(USERNAME_KEY)) {
            username = JSSCommunityActivator.getDefault().getPreferenceStore().getString(USERNAME_KEY);
        }
        String password = null;
        if (JSSCommunityActivator.getDefault().getPreferenceStore().contains(PASSWORD_KEY)) {
            password = JSSCommunityActivator.getDefault().getPreferenceStore().getString(PASSWORD_KEY);
        }
        if (username != null && password != null) {
            return new CommunityUser(username, password);
        }
        return null;
    }
}

