/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.community;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jaspersoft.studio.community.JSSCommunityActivator;
import com.jaspersoft.studio.community.issues.IssueField;
import com.jaspersoft.studio.community.messages.Messages;
import com.jaspersoft.studio.community.requests.FileUploadRequest;
import com.jaspersoft.studio.community.requests.IssueRequest;
import com.jaspersoft.studio.community.utils.CommunityAPIException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.CookieStore;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public final class RESTCommunityHelper {
    private RESTCommunityHelper() {
    }

    public static Cookie getAuthenticationCookie(CloseableHttpClient httpclient, CookieStore cookieStore, String username, String password) throws CommunityAPIException {
        try {
            HttpPost loginPOST = new HttpPost("https://community.jaspersoft.com/community-api/user/login");
            EntityBuilder loginEntity = EntityBuilder.create();
            loginEntity.setText("{ \"username\": \"" + username + "\", \"password\":\"" + password + "\" }");
            loginEntity.setContentType(ContentType.create((String)"application/json"));
            loginEntity.setContentEncoding("UTF-8");
            loginPOST.setEntity(loginEntity.build());
            CloseableHttpResponse resp = httpclient.execute((HttpUriRequest)loginPOST);
            int httpRetCode = resp.getStatusLine().getStatusCode();
            String responseBodyAsString = EntityUtils.toString((HttpEntity)resp.getEntity());
            if (200 == httpRetCode) {
                List cookies = cookieStore.getCookies();
                Cookie authCookie = null;
                for (Cookie cookie : cookies) {
                    if (!cookie.getName().startsWith("SESS")) continue;
                    authCookie = cookie;
                    break;
                }
                return authCookie;
            }
            if (401 == httpRetCode) {
                CommunityAPIException unauthorizedEx = new CommunityAPIException(Messages.RESTCommunityHelper_WrongUsernamePasswordError);
                unauthorizedEx.setHttpStatusCode(httpRetCode);
                unauthorizedEx.setResponseBodyAsString(responseBodyAsString);
                throw unauthorizedEx;
            }
            CommunityAPIException generalEx = new CommunityAPIException(Messages.RESTCommunityHelper_AuthInfoProblemsError);
            generalEx.setHttpStatusCode(httpRetCode);
            generalEx.setResponseBodyAsString(responseBodyAsString);
            throw generalEx;
        }
        catch (UnsupportedEncodingException e) {
            JSSCommunityActivator.getDefault().logError(Messages.RESTCommunityHelper_EncodingNotValidError, e);
            throw new CommunityAPIException(Messages.RESTCommunityHelper_AuthenticationError, e);
        }
        catch (IOException e) {
            JSSCommunityActivator.getDefault().logError(Messages.RESTCommunityHelper_PostMethodIOError, e);
            throw new CommunityAPIException(Messages.RESTCommunityHelper_AuthenticationError, e);
        }
    }

    public static String uploadFile(CloseableHttpClient httpclient, File attachment, Cookie authCookie) throws CommunityAPIException {
        String responseBodyAsString;
        int httpRetCode;
        FileInputStream fin;
        block7: {
            String fid;
            fin = null;
            fin = new FileInputStream(attachment);
            byte[] fileContent = new byte[(int)attachment.length()];
            fin.read(fileContent);
            byte[] encodedFileContent = Base64.encodeBase64((byte[])fileContent);
            FileUploadRequest uploadReq = new FileUploadRequest(attachment.getName(), encodedFileContent);
            HttpPost fileuploadPOST = new HttpPost("https://community.jaspersoft.com/community-api/file.json");
            EntityBuilder fileUploadEntity = EntityBuilder.create();
            fileUploadEntity.setText(uploadReq.getAsJSON());
            fileUploadEntity.setContentType(ContentType.create((String)"application/json"));
            fileUploadEntity.setContentEncoding("UTF-8");
            fileuploadPOST.setEntity(fileUploadEntity.build());
            CloseableHttpResponse resp = httpclient.execute((HttpUriRequest)fileuploadPOST);
            httpRetCode = resp.getStatusLine().getStatusCode();
            responseBodyAsString = EntityUtils.toString((HttpEntity)resp.getEntity());
            if (200 != httpRetCode) break block7;
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
            mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
            JsonNode jsonRoot = mapper.readTree(responseBodyAsString);
            String string = fid = jsonRoot.get("fid").asText();
            IOUtils.closeQuietly((InputStream)fin);
            return string;
        }
        try {
            try {
                CommunityAPIException ex = new CommunityAPIException(Messages.RESTCommunityHelper_FileUploadError);
                ex.setHttpStatusCode(httpRetCode);
                ex.setResponseBodyAsString(responseBodyAsString);
                throw ex;
            }
            catch (FileNotFoundException e) {
                JSSCommunityActivator.getDefault().logError(Messages.RESTCommunityHelper_FileNotFoundError, e);
                throw new CommunityAPIException(Messages.RESTCommunityHelper_FileUploadError, e);
            }
            catch (UnsupportedEncodingException e) {
                JSSCommunityActivator.getDefault().logError(Messages.RESTCommunityHelper_EncodingNotValidError, e);
                throw new CommunityAPIException(Messages.RESTCommunityHelper_FileUploadError, e);
            }
            catch (IOException e) {
                JSSCommunityActivator.getDefault().logError(Messages.RESTCommunityHelper_PostMethodIOError, e);
                throw new CommunityAPIException(Messages.RESTCommunityHelper_FileUploadError, e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fin);
            throw throwable;
        }
    }

    public static String createNewIssue(CloseableHttpClient httpclient, IssueRequest newIssue, List<String> attachmentsIds, Cookie authCookie) throws CommunityAPIException {
        try {
            if (!attachmentsIds.isEmpty()) {
                IssueField attachmentsField = new IssueField(){

                    @Override
                    protected String getValueAttributeName() {
                        return "fid";
                    }

                    @Override
                    public boolean isArray() {
                        return true;
                    }
                };
                attachmentsField.setName("field_bug_attachments");
                attachmentsField.setValues(attachmentsIds);
                newIssue.setAttachments(attachmentsField);
            }
            HttpPost issueCreationPOST = new HttpPost("https://community.jaspersoft.com/community-api/node.json");
            EntityBuilder newIssueEntity = EntityBuilder.create();
            newIssueEntity.setText(newIssue.getAsJSON());
            newIssueEntity.setContentType(ContentType.create((String)"application/json"));
            newIssueEntity.setContentEncoding("UTF-8");
            issueCreationPOST.setEntity(newIssueEntity.build());
            CloseableHttpResponse httpResponse = httpclient.execute((HttpUriRequest)issueCreationPOST);
            int httpRetCode = httpResponse.getStatusLine().getStatusCode();
            String responseBodyAsString = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
            if (200 != httpRetCode) {
                CommunityAPIException ex = new CommunityAPIException(Messages.RESTCommunityHelper_IssueCreationError);
                ex.setHttpStatusCode(httpRetCode);
                ex.setResponseBodyAsString(responseBodyAsString);
                throw ex;
            }
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
            mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
            JsonNode jsonRoot = mapper.readTree(responseBodyAsString);
            String nodeID = jsonRoot.get("nid").asText();
            JsonNode jsonNodeContent = RESTCommunityHelper.retrieveNodeContentAsJSON(httpclient, nodeID, authCookie);
            return jsonNodeContent.get("path").asText();
        }
        catch (UnsupportedEncodingException e) {
            JSSCommunityActivator.getDefault().logError(Messages.RESTCommunityHelper_EncodingNotValidError, e);
            throw new CommunityAPIException(Messages.RESTCommunityHelper_IssueCreationError, e);
        }
        catch (IOException e) {
            JSSCommunityActivator.getDefault().logError(Messages.RESTCommunityHelper_PostMethodIOError, e);
            throw new CommunityAPIException(Messages.RESTCommunityHelper_IssueCreationError, e);
        }
    }

    public static JsonNode retrieveNodeContentAsJSON(CloseableHttpClient httpclient, String nodeID, Cookie authCookie) throws CommunityAPIException {
        try {
            HttpGet retrieveNodeContentGET = new HttpGet("https://community.jaspersoft.com/community-api/node/" + nodeID + ".json");
            CloseableHttpResponse resp = httpclient.execute((HttpUriRequest)retrieveNodeContentGET);
            int httpRetCode = resp.getStatusLine().getStatusCode();
            String responseBodyAsString = EntityUtils.toString((HttpEntity)resp.getEntity());
            if (200 == httpRetCode) {
                ObjectMapper mapper = new ObjectMapper();
                mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
                mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
                mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
                JsonNode jsonRoot = mapper.readTree(responseBodyAsString);
                return jsonRoot;
            }
            CommunityAPIException ex = new CommunityAPIException(Messages.RESTCommunityHelper_NodeContentRetrieveError);
            ex.setHttpStatusCode(httpRetCode);
            ex.setResponseBodyAsString(responseBodyAsString);
            throw ex;
        }
        catch (IOException e) {
            JSSCommunityActivator.getDefault().logError(Messages.RESTCommunityHelper_GetMethodIOError, e);
            throw new CommunityAPIException(Messages.RESTCommunityHelper_NodeContentRetrieveError, e);
        }
    }
}

