/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.community.issues;

import java.util.Arrays;
import java.util.List;

public class IssueField {
    private String name;
    private List<String> values;
    private boolean isArray;

    public IssueField() {
    }

    public IssueField(String name, String value) {
        this.setName(name);
        this.setValue(value);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    public void setValue(String value) {
        this.values = Arrays.asList(value);
    }

    public String asJsonString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\"").append(this.name).append("\":{");
        sb.append("\"und\":");
        if (this.isArray()) {
            sb.append("[");
        }
        this.appendAllValues(sb);
        if (this.isArray()) {
            sb.append("]");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean isArray() {
        return this.isArray;
    }

    public void setIsArray(boolean isArray) {
        this.isArray = isArray;
    }

    private void appendAllValues(StringBuffer sb) {
        int valuesNum = this.values.size();
        int i = 0;
        while (i < valuesNum) {
            sb.append("{\"").append(this.getValueAttributeName()).append("\": \"").append(this.values.get(i)).append("\"}");
            if (i != valuesNum - 1) {
                sb.append(",");
            }
            ++i;
        }
    }

    protected String getValueAttributeName() {
        return "value";
    }
}

