/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.community.requests;

import com.jaspersoft.studio.community.issues.IssueBody;
import com.jaspersoft.studio.community.issues.IssueField;
import com.jaspersoft.studio.community.utils.CommunityAPIUtils;

public class IssueRequest {
    private static final String FIELD_SEPARATOR = ",";
    private String nodeTitle;
    private String nodeStatus;
    private String nodeComment;
    private String nodePromote;
    private String nodeSticky;
    private String nodeType;
    private String nodeLanguage;
    private IssueBody nodeBody;
    private IssueField category;
    private IssueField priority;
    private IssueField severity;
    private IssueField reproducibility;
    private IssueField resolution;
    private IssueField status;
    private IssueField project;
    private IssueField assignedUser;
    private IssueField attachments;

    public IssueRequest(String title, String text) {
        this.nodeTitle = title;
        this.nodeBody = new IssueBody(text);
        this.nodeStatus = "1";
        this.nodeComment = "2";
        this.nodePromote = "0";
        this.nodeSticky = "0";
        this.nodeType = "bug";
        this.nodeLanguage = "und";
    }

    public IssueField getCategory() {
        return this.category;
    }

    public void setCategory(IssueField category) {
        this.category = category;
    }

    public IssueField getPriority() {
        return this.priority;
    }

    public void setPriority(IssueField priority) {
        this.priority = priority;
    }

    public IssueField getSeverity() {
        return this.severity;
    }

    public void setSeverity(IssueField severity) {
        this.severity = severity;
    }

    public IssueField getReproducibility() {
        return this.reproducibility;
    }

    public void setReproducibility(IssueField reproducibility) {
        this.reproducibility = reproducibility;
    }

    public IssueField getResolution() {
        return this.resolution;
    }

    public void setResolution(IssueField resolution) {
        this.resolution = resolution;
    }

    public IssueField getStatus() {
        return this.status;
    }

    public void setStatus(IssueField status) {
        this.status = status;
    }

    public IssueField getProject() {
        return this.project;
    }

    public void setProject(IssueField project) {
        this.project = project;
    }

    public IssueField getAssignedUser() {
        return this.assignedUser;
    }

    public void setAssignedUser(IssueField assignedUser) {
        this.assignedUser = assignedUser;
    }

    public IssueField getAttachments() {
        return this.attachments;
    }

    public void setAttachments(IssueField attachments) {
        this.attachments = attachments;
    }

    public String getAsJSON() {
        StringBuffer jsonBuf = new StringBuffer();
        jsonBuf.append("{");
        jsonBuf.append("\"node\":{");
        jsonBuf.append("\"title\": \"").append(CommunityAPIUtils.jsonStringSanitize(this.nodeTitle)).append("\",");
        jsonBuf.append("\"status\": \"").append(this.nodeStatus).append("\",");
        jsonBuf.append("\"comment\": \"").append(this.nodeComment).append("\",");
        jsonBuf.append("\"promote\": \"").append(this.nodePromote).append("\",");
        jsonBuf.append("\"sticky\": \"").append(this.nodeSticky).append("\",");
        jsonBuf.append("\"type\": \"").append(this.nodeType).append("\",");
        jsonBuf.append("\"language\": \"").append(this.nodeLanguage).append("\",");
        jsonBuf.append(this.nodeBody.asJsonString()).append(FIELD_SEPARATOR);
        jsonBuf.append(this.category.asJsonString()).append(FIELD_SEPARATOR);
        jsonBuf.append(this.priority.asJsonString()).append(FIELD_SEPARATOR);
        jsonBuf.append(this.severity.asJsonString()).append(FIELD_SEPARATOR);
        jsonBuf.append(this.reproducibility.asJsonString()).append(FIELD_SEPARATOR);
        jsonBuf.append(this.resolution.asJsonString()).append(FIELD_SEPARATOR);
        jsonBuf.append(this.status.asJsonString()).append(FIELD_SEPARATOR);
        jsonBuf.append(this.project.asJsonString());
        if (this.assignedUser != null && !this.assignedUser.asJsonString().isEmpty()) {
            jsonBuf.append(FIELD_SEPARATOR).append(this.assignedUser.asJsonString());
        }
        if (this.attachments != null && !this.attachments.asJsonString().isEmpty()) {
            jsonBuf.append(FIELD_SEPARATOR).append(this.attachments.asJsonString());
        }
        jsonBuf.append("}");
        jsonBuf.append("}");
        return jsonBuf.toString();
    }
}

