/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.community.utils;

import com.fasterxml.jackson.core.io.JsonStringEncoder;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.community.JSSCommunityActivator;
import com.jaspersoft.studio.community.messages.Messages;
import com.jaspersoft.studio.community.utils.CommunityAPIException;
import com.jaspersoft.studio.community.zip.ZipEntry;
import com.jaspersoft.studio.utils.BrandingInfo;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import java.util.zip.ZipOutputStream;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.BundleCommonUtils;
import net.sf.jasperreports.soutils.EnvironmentUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.internal.core.utils.IOUtils2;
import org.eclipse.wb.internal.core.utils.platform.PlatformInfo;
import org.eclipse.wb.internal.core.utils.platform.PluginUtilities;

public class CommunityAPIUtils {
    private static final String CR = "\n";
    private static final String JSS_PREFS_RELATIVE_LOCATION = ".metadata/.plugins/org.eclipse.core.runtime/.settings/com.jaspersoft.studio.prefs";
    private static final String JSS_LOG_RELATIVE_LOCATION = ".metadata/.log";

    public static File createZipFile(List<ZipEntry> zipEntries) throws CommunityAPIException {
        String tmpDirectory;
        String zipFileLocation = tmpDirectory = System.getProperty("java.io.tmpdir");
        if (!tmpDirectory.endsWith("/") && !tmpDirectory.endsWith("\\")) {
            zipFileLocation = String.valueOf(zipFileLocation) + System.getProperty("file.separator");
        }
        zipFileLocation = String.valueOf(zipFileLocation) + "issueDetails.zip";
        try {
            byte[] buffer = new byte[1024];
            FileOutputStream fout = new FileOutputStream(zipFileLocation);
            ZipOutputStream zout = new ZipOutputStream(fout);
            for (ZipEntry ze : zipEntries) {
                int length;
                FileInputStream fin = new FileInputStream(ze.getLocation());
                zout.putNextEntry(new java.util.zip.ZipEntry(ze.getLocation()));
                while ((length = fin.read(buffer)) > 0) {
                    zout.write(buffer, 0, length);
                }
                zout.closeEntry();
                fin.close();
            }
            zout.close();
        }
        catch (IOException e) {
            throw new CommunityAPIException(Messages.CommunityAPIUtils_ZipCreationError, e);
        }
        return new File(zipFileLocation);
    }

    public static String getJaspersoftStudioPrefsLocation() {
        return String.valueOf(BundleCommonUtils.getWorkspaceLocation()) + "/" + JSS_PREFS_RELATIVE_LOCATION;
    }

    public static String getJaspersoftStudioLogFileLocation() {
        return String.valueOf(BundleCommonUtils.getWorkspaceLocation()) + "/" + JSS_LOG_RELATIVE_LOCATION;
    }

    public static String getHardwareSoftwareInfo() {
        String m_mozillaResult;
        BrandingInfo currBranding = JaspersoftStudioPlugin.getInstance().getBrandingInformation();
        String c = "";
        c = String.valueOf(c) + "Product Name: " + currBranding.getProductName() + CR;
        c = String.valueOf(c) + "Product Version: " + currBranding.getProductVersion() + CR;
        c = String.valueOf(c) + "Installation Path: " + CommunityAPIUtils.getInstallationPath(currBranding.getProductMainBundleID()) + CR;
        c = String.valueOf(c) + "Eclipse Version: " + PlatformInfo.getEclipseVersion().toString() + CR;
        c = String.valueOf(c) + "Eclipse Build Name: " + PlatformInfo.getEclipseBuildName() + CR;
        c = String.valueOf(c) + "Eclipse Build ID: " + PlatformInfo.getEclipseBuildId() + CR;
        c = String.valueOf(c) + "IDE Name: " + PlatformInfo.getIDEName() + CR;
        c = String.valueOf(c) + "IDE Version: " + PlatformInfo.getIDEVersionString() + CR;
        c = String.valueOf(c) + "IDE NL: " + PlatformInfo.getIDENL() + CR;
        c = String.valueOf(c) + "Eclipse Commands: " + StringUtils.replaceChars((String)CommunityAPIUtils.getSystemProperty("eclipse.commands"), (String)"\n\r", (String)" ") + CR;
        c = String.valueOf(c) + "Eclipse VM: " + CommunityAPIUtils.getSystemProperty("eclipse.vm") + CR;
        c = String.valueOf(c) + "Eclipse VM Args: " + CommunityAPIUtils.getSystemProperty("eclipse.vmargs") + CR;
        c = String.valueOf(c) + "OS Name: " + CommunityAPIUtils.getSystemProperty("os.name") + CR;
        c = String.valueOf(c) + "OS Arch: " + CommunityAPIUtils.getSystemProperty("os.arch") + CR;
        c = String.valueOf(c) + "OS Version: " + CommunityAPIUtils.getSystemProperty("os.version") + CR;
        String linuxDescription = CommunityAPIUtils.getLinuxDescription();
        if (!StringUtils.isEmpty((String)linuxDescription)) {
            c = String.valueOf(c) + "Linux Description: " + linuxDescription + CR;
        }
        if (!StringUtils.isEmpty((String)(m_mozillaResult = CommunityAPIUtils.tryCreateMozilla()))) {
            c = String.valueOf(c) + "Browser Creation Result: " + m_mozillaResult + CR;
        }
        Runtime runtime = Runtime.getRuntime();
        c = String.valueOf(c) + "Available Processors: " + runtime.availableProcessors() + CR;
        c = String.valueOf(c) + "Memory Max: " + runtime.maxMemory() + CR;
        c = String.valueOf(c) + "Memory Total: " + runtime.totalMemory() + CR;
        c = String.valueOf(c) + "Memory Free: " + runtime.freeMemory() + CR;
        c = String.valueOf(c) + "Java Vendor: " + CommunityAPIUtils.getSystemProperty("java.vendor") + CR;
        c = String.valueOf(c) + "Java Version: " + CommunityAPIUtils.getSystemProperty("java.version") + CR;
        c = String.valueOf(c) + "Java Library Path: " + CommunityAPIUtils.getSystemProperty("java.library.path") + CR;
        return c;
    }

    private static String getInstallationPath(String pluginID) {
        URL installUrl = PluginUtilities.getInstallUrl(pluginID);
        String installationPath = "Unknown";
        try {
            if (installUrl != null && (installationPath = FileLocator.toFileURL((URL)installUrl).getPath()).length() > 3 && installationPath.charAt(0) == '/' && installationPath.charAt(2) == ':') {
                installationPath = installationPath.substring(1);
            }
        }
        catch (IOException e) {
            JSSCommunityActivator.getDefault().logError(Messages.CommunityAPIUtils_ErrorMsgProductPath, e);
        }
        return installationPath;
    }

    private static String getSystemProperty(String prop) {
        String propValue = System.getProperty(prop);
        return propValue == null ? "" : propValue;
    }

    private static String getLinuxDescription() {
        StringBuilder result = new StringBuilder();
        if (EnvironmentUtils.IS_LINUX) {
            String[] files = new String[]{"/etc/lsb-release", "/etc/lsb_release", "/etc/system-release", "/etc/fedora-release", "/etc/SuSE-release", "/etc/redhat-release", "/etc/release", "/proc/version_signature", "/proc/version", "/etc/issue"};
            int i = 0;
            while (i < files.length) {
                File file = new File(files[i]);
                if (file.exists() && file.canRead()) {
                    try {
                        String version = IOUtils2.readString(file).trim();
                        if (version != null && result.indexOf(version) == -1) {
                            result.append(version);
                            result.append(CR);
                        }
                    }
                    catch (IOException e) {
                        JSSCommunityActivator.getDefault().logError(MessageFormat.format(Messages.CommunityAPIUtils_ErrorMsgReadingFile, file.getAbsolutePath()), e);
                    }
                }
                ++i;
            }
        }
        return result.toString();
    }

    private static String tryCreateMozilla() {
        if (EnvironmentUtils.IS_LINUX) {
            String string;
            PrintStream newOut;
            PrintStream oldOut;
            boolean oldDebug;
            block8: {
                oldDebug = Device.DEBUG;
                Device.DEBUG = true;
                oldOut = System.out;
                Shell shell = null;
                newOut = null;
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    newOut = new PrintStream(baos);
                    System.setOut(newOut);
                    shell = new Shell();
                    try {
                        new Browser((Composite)shell, 0);
                    }
                    catch (Throwable e) {
                        UIUtils.showError((Throwable)e);
                    }
                    string = baos.toString();
                    if (shell == null) break block8;
                }
                catch (Throwable throwable) {
                    block9: {
                        try {
                            if (shell == null) break block9;
                        }
                        catch (Throwable throwable2) {
                            if (shell != null) {
                                shell.dispose();
                            }
                            System.setOut(oldOut);
                            IOUtils.closeQuietly(newOut);
                            Device.DEBUG = oldDebug;
                            throw throwable2;
                        }
                        shell.dispose();
                    }
                    System.setOut(oldOut);
                    IOUtils.closeQuietly((OutputStream)newOut);
                    Device.DEBUG = oldDebug;
                }
                shell.dispose();
            }
            System.setOut(oldOut);
            IOUtils.closeQuietly((OutputStream)newOut);
            Device.DEBUG = oldDebug;
            return string;
        }
        return "";
    }

    public static String jsonStringSanitize(String inputString) {
        char[] stringChars = JsonStringEncoder.getInstance().quoteAsString(inputString);
        return new String(stringChars);
    }
}

