/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.community.wizards;

import com.jaspersoft.studio.community.JSSCommunityActivator;
import com.jaspersoft.studio.community.dialogs.HwSwDetailsDialog;
import com.jaspersoft.studio.community.messages.Messages;
import com.jaspersoft.studio.community.utils.CommunityAPIUtils;
import com.jaspersoft.studio.community.wizards.ContextHelpIDs;
import com.jaspersoft.studio.community.zip.ZipEntry;
import com.jaspersoft.studio.community.zip.ZipEntryType;
import com.jaspersoft.studio.wizards.JSSHelpWizardPage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.ResourceManager;

public class IssueAttachmentDetailsPage
extends JSSHelpWizardPage {
    private List<ZipEntry> zipEntries = new ArrayList<ZipEntry>();
    private File hwSwInfoFile = null;
    private Button btnLogFile;
    private Button btnSoftwareAndHardware;
    private org.eclipse.swt.widgets.List zipFileContent;
    private Button btnAttachments;
    private Button btnJaspersoftStudioPreferences;
    private Link addAttachments;
    private Font standardListFont;

    public IssueAttachmentDetailsPage() {
        super("issueAttachmentDetailsWizardPage");
        this.setImageDescriptor(JSSCommunityActivator.getDefault().getImageDescriptor("resources/images/softwareBug.png"));
        this.setTitle(Messages.IssueAttachmentDetailsPage_Title);
        this.setDescription(Messages.IssueAttachmentDetailsPage_Description);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        GridLayout glContainer = new GridLayout(4, false);
        glContainer.horizontalSpacing = 10;
        glContainer.verticalSpacing = 10;
        container.setLayout((Layout)glContainer);
        this.btnLogFile = new Button(container, 32);
        this.btnLogFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IssueAttachmentDetailsPage.this.logFileSelectionPerformed();
            }
        });
        this.btnLogFile.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.btnLogFile.setText(Messages.IssueAttachmentDetailsPage_LogFileCheckbox);
        this.btnSoftwareAndHardware = new Button(container, 32);
        this.btnSoftwareAndHardware.setText(Messages.IssueAttachmentDetailsPage_SwAndHwSummaryCheckbox);
        this.btnSoftwareAndHardware.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IssueAttachmentDetailsPage.this.hwSwInfoSelectionPerformed();
            }
        });
        Link viewHwSwSummary = new Link(container, 0);
        viewHwSwSummary.setText(Messages.IssueAttachmentDetailsPage_ViewLink);
        final HwSwDetailsDialog hwSwDialog = new HwSwDetailsDialog(this.getShell(), 67680);
        viewHwSwSummary.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                hwSwDialog.setLocation(UIUtils.getDisplay().getCursorLocation().x, UIUtils.getDisplay().getCursorLocation().y);
                hwSwDialog.open();
            }
        });
        this.btnAttachments = new Button(container, 32);
        this.btnAttachments.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!IssueAttachmentDetailsPage.this.btnAttachments.getSelection()) {
                    IssueAttachmentDetailsPage.this.removeZipEntries(ZipEntryType.ATTACHMENT);
                    IssueAttachmentDetailsPage.this.addAttachments.setEnabled(false);
                } else {
                    IssueAttachmentDetailsPage.this.addAttachments.setEnabled(true);
                }
                IssueAttachmentDetailsPage.this.refreshZipEntriesList();
            }
        });
        this.btnAttachments.setText(Messages.IssueAttachmentDetailsPage_AttachmentsCheckbox);
        this.addAttachments = new Link(container, 0);
        this.addAttachments.setText(Messages.IssueAttachmentDetailsPage_AddLink);
        this.addAttachments.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(UIUtils.getShell());
                fd.setFilterExtensions(new String[]{"*.png", "*.jpeg; *.jpg", "*.gif", "*.jrxml", "*.*"});
                String selection = fd.open();
                if (selection != null) {
                    IssueAttachmentDetailsPage.this.zipEntries.add(new ZipEntry(null, selection, ZipEntryType.ATTACHMENT));
                }
                IssueAttachmentDetailsPage.this.refreshZipEntriesList();
            }
        });
        this.addAttachments.setEnabled(false);
        this.btnJaspersoftStudioPreferences = new Button(container, 32);
        this.btnJaspersoftStudioPreferences.setText(Messages.IssueAttachmentDetailsPage_JSSPreferencesCheckbox);
        this.btnJaspersoftStudioPreferences.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.btnJaspersoftStudioPreferences.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IssueAttachmentDetailsPage.this.jssPrefsSelectionPerformed();
            }
        });
        Group groupZipContent = new Group(container, 0);
        groupZipContent.setText(Messages.IssueAttachmentDetailsPage_ZipContentsGroup);
        groupZipContent.setLayout((Layout)new FillLayout(256));
        GridData gdGroupZipContent = new GridData(4, 4, true, true, 4, 1);
        gdGroupZipContent.widthHint = 579;
        groupZipContent.setLayoutData((Object)gdGroupZipContent);
        this.zipFileContent = new org.eclipse.swt.widgets.List((Composite)groupZipContent, 2050);
        this.standardListFont = this.zipFileContent.getFont();
        this.zipFileContent.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u007f') {
                    IssueAttachmentDetailsPage.this.removeZipEntries(Arrays.asList(IssueAttachmentDetailsPage.this.zipFileContent.getSelection()));
                    IssueAttachmentDetailsPage.this.refreshZipEntriesList();
                }
            }
        });
        this.btnSoftwareAndHardware.setSelection(true);
        this.hwSwInfoSelectionPerformed();
    }

    private void jssPrefsSelectionPerformed() {
        if (this.btnJaspersoftStudioPreferences.getSelection()) {
            this.zipEntries.add(new ZipEntry("jss_preferences_file.prefs", CommunityAPIUtils.getJaspersoftStudioPrefsLocation(), ZipEntryType.PREFS));
        } else {
            this.removeZipEntries(ZipEntryType.PREFS);
        }
        this.refreshZipEntriesList();
    }

    private void hwSwInfoSelectionPerformed() {
        if (this.hwSwInfoFile == null) {
            try {
                this.hwSwInfoFile = File.createTempFile("hwSwInfo", ".txt");
                FileUtils.writeFile((File)this.hwSwInfoFile, (String)CommunityAPIUtils.getHardwareSoftwareInfo());
            }
            catch (IOException e) {
                UIUtils.showError((Throwable)e);
                return;
            }
        }
        if (this.btnSoftwareAndHardware.getSelection()) {
            this.zipEntries.add(new ZipEntry(this.hwSwInfoFile.getName(), this.hwSwInfoFile.getAbsolutePath(), ZipEntryType.HW_SW_INFO));
        } else {
            this.removeZipEntries(ZipEntryType.HW_SW_INFO);
        }
        this.refreshZipEntriesList();
    }

    private void logFileSelectionPerformed() {
        if (this.btnLogFile.getSelection()) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.IssueAttachmentDetailsPage_WarningLogFileAttachmentTitle, (String)Messages.IssueAttachmentDetailsPage_WarningLogFileAttachmentMsg);
            this.zipEntries.add(new ZipEntry("jss_logfile.txt", CommunityAPIUtils.getJaspersoftStudioLogFileLocation(), ZipEntryType.LOG));
        } else {
            this.removeZipEntries(ZipEntryType.LOG);
        }
        this.refreshZipEntriesList();
    }

    private void refreshZipEntriesList() {
        this.zipFileContent.removeAll();
        if (!this.zipEntries.isEmpty()) {
            ArrayList<String> fileLocations = new ArrayList<String>();
            for (ZipEntry ze : this.zipEntries) {
                fileLocations.add(ze.getLocation());
            }
            Collections.sort(fileLocations);
            for (String loc : fileLocations) {
                this.zipFileContent.add(loc);
            }
            this.zipFileContent.setFont(this.standardListFont);
        } else {
            this.zipFileContent.add(Messages.IssueAttachmentDetailsPage_NoAttachments);
            this.zipFileContent.setFont(ResourceManager.getItalicFont((Font)this.standardListFont));
        }
    }

    private void removeZipEntries(List<String> entries) {
        if (!this.zipEntries.isEmpty()) {
            Iterator<ZipEntry> it = this.zipEntries.iterator();
            while (it.hasNext()) {
                ZipEntry ze = it.next();
                if (!entries.contains(ze.getLocation())) continue;
                switch (ze.getType()) {
                    case HW_SW_INFO: {
                        this.btnSoftwareAndHardware.setSelection(false);
                        break;
                    }
                    case LOG: {
                        this.btnLogFile.setSelection(false);
                        break;
                    }
                    case PREFS: {
                        this.btnJaspersoftStudioPreferences.setSelection(false);
                        break;
                    }
                }
                it.remove();
            }
        }
    }

    private void removeZipEntries(ZipEntryType type) {
        Iterator<ZipEntry> it = this.zipEntries.iterator();
        while (it.hasNext()) {
            ZipEntry ze = it.next();
            if (!type.equals((Object)ze.getType())) continue;
            it.remove();
        }
    }

    public List<ZipEntry> getZipEntries() {
        return this.zipEntries;
    }

    protected String getContextName() {
        return ContextHelpIDs.WIZARD_ISSUE_ATTACHMENTS;
    }
}

