/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.community.wizards;

import com.jaspersoft.studio.community.JSSCommunityActivator;
import com.jaspersoft.studio.community.RESTCommunityHelper;
import com.jaspersoft.studio.community.messages.Messages;
import com.jaspersoft.studio.community.requests.IssueRequest;
import com.jaspersoft.studio.community.utils.CommunityAPIException;
import com.jaspersoft.studio.community.utils.CommunityAPIUtils;
import com.jaspersoft.studio.community.utils.CommunityUser;
import com.jaspersoft.studio.community.wizards.IssueAttachmentDetailsPage;
import com.jaspersoft.studio.community.wizards.NewIssueAuthenticationPage;
import com.jaspersoft.studio.community.wizards.NewIssueDetailsPage;
import com.jaspersoft.studio.community.zip.ZipEntry;
import com.jaspersoft.studio.utils.jobs.CheckedRunnableWithProgress;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.HttpUtils;
import net.sf.jasperreports.eclipse.viewer.BrowserUtils;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public final class IssueCreationWizard
extends Wizard {
    private static IssueCreationWizard instance = null;
    private NewIssueDetailsPage page1;
    private IssueAttachmentDetailsPage page2;
    private NewIssueAuthenticationPage page3;
    private boolean isPublished;
    private String issuePath;
    private CloseableHttpClient httpclient = null;

    private IssueCreationWizard() {
        this.setWindowTitle(Messages.IssueCreationWizard_Title);
    }

    public void addPages() {
        this.page1 = new NewIssueDetailsPage();
        this.addPage((IWizardPage)this.page1);
        this.page2 = new IssueAttachmentDetailsPage();
        this.addPage((IWizardPage)this.page2);
        this.page3 = new NewIssueAuthenticationPage();
        this.addPage((IWizardPage)this.page3);
    }

    public boolean performFinish() {
        final List<ZipEntry> zipEntries = this.page2.getZipEntries();
        final IssueRequest issueRequest = this.page1.getIssueRequest();
        final CommunityUser authInfo = this.page3.getCommunityUserInformation();
        if (this.page3.shouldSaveCredentials()) {
            JSSCommunityActivator.getDefault().storeCommunityUserInformation(authInfo);
        }
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)new CheckedRunnableWithProgress(){

                protected void runOperations(IProgressMonitor monitor) {
                    monitor.beginTask(Messages.IssueCreationWizard_TaskName, -1);
                    IssueCreationWizard.this.isPublished = IssueCreationWizard.this.publishNewIssue(issueRequest, zipEntries, authInfo, monitor);
                    monitor.done();
                }

                protected void abortOperationInvoked() {
                    HttpClientUtils.closeQuietly((HttpClient)IssueCreationWizard.this.httpclient);
                    IssueCreationWizard.this.httpclient = null;
                }
            });
        }
        catch (Exception e) {
            UIUtils.showError((String)Messages.IssueCreationWizard_PublishingAbortedMessage, (Throwable)e);
        }
        if (this.isPublished) {
            new IssueCreatedDialog(this.getShell(), Messages.IssueCreationWizard_InfoDialogTitle, null, Messages.IssueCreationWizard_InfoDialogMessage, 2, new String[]{IDialogConstants.OK_LABEL}, 0).open();
        }
        return this.isPublished;
    }

    private boolean publishNewIssue(IssueRequest issueRequest, List<ZipEntry> zipEntries, CommunityUser authInfo, IProgressMonitor monitor) {
        try {
            try {
                BasicCookieStore cookieStore = new BasicCookieStore();
                this.httpclient = HttpUtils.setupProxy((HttpClientBuilder)HttpClientBuilder.create()).setDefaultCookieStore((CookieStore)cookieStore).build();
                Cookie authCookie = RESTCommunityHelper.getAuthenticationCookie(this.httpclient, (CookieStore)cookieStore, authInfo.getUsername(), authInfo.getPassword());
                ArrayList<String> attachmentsIDs = new ArrayList<String>();
                if (!zipEntries.isEmpty()) {
                    File zipAttachment = CommunityAPIUtils.createZipFile(zipEntries);
                    String fileID = RESTCommunityHelper.uploadFile(this.httpclient, zipAttachment, authCookie);
                    attachmentsIDs.add(fileID);
                }
                this.issuePath = RESTCommunityHelper.createNewIssue(this.httpclient, issueRequest, attachmentsIDs, authCookie);
            }
            catch (CommunityAPIException e) {
                UIUtils.showError((Throwable)e);
                HttpClientUtils.closeQuietly((HttpClient)this.httpclient);
                this.httpclient = null;
                return false;
            }
        }
        finally {
            HttpClientUtils.closeQuietly((HttpClient)this.httpclient);
            this.httpclient = null;
        }
        return true;
    }

    public static synchronized IssueCreationWizard createWizard() {
        if (instance == null) {
            instance = new IssueCreationWizard();
            return instance;
        }
        return null;
    }

    public void dispose() {
        super.dispose();
        instance = null;
    }

    private class IssueCreatedDialog
    extends MessageDialog {
        public IssueCreatedDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
            super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        }

        protected Control createCustomArea(Composite parent) {
            final StyledText issueLink = new StyledText(parent, 8);
            issueLink.setText(IssueCreationWizard.this.issuePath);
            issueLink.setBackground(parent.getBackground());
            issueLink.setLayoutData((Object)new GridData(131072, 128, true, false, 2, 1));
            StyleRange style = new StyleRange();
            style.underline = true;
            style.underlineStyle = 4;
            int[] nArray = new int[2];
            nArray[1] = IssueCreationWizard.this.issuePath.length();
            int[] ranges = nArray;
            StyleRange[] styles = new StyleRange[]{style};
            issueLink.setStyleRanges(ranges, styles);
            issueLink.addListener(3, new Listener(){

                public void handleEvent(Event event) {
                    try {
                        int offset = issueLink.getOffsetAtLocation(new Point(event.x, event.y));
                        StyleRange style = issueLink.getStyleRangeAtOffset(offset);
                        if (style != null && style.underline && style.underlineStyle == 4) {
                            BrowserUtils.openExternalBrowser((String)IssueCreationWizard.this.issuePath);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            });
            return issueLink;
        }
    }
}

