/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.community.wizards;

import com.jaspersoft.studio.community.JSSCommunityActivator;
import com.jaspersoft.studio.community.messages.Messages;
import com.jaspersoft.studio.community.utils.CommunityUser;
import com.jaspersoft.studio.community.wizards.ContextHelpIDs;
import com.jaspersoft.studio.wizards.JSSHelpWizardPage;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.viewer.BrowserUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewIssueAuthenticationPage
extends JSSHelpWizardPage {
    private CommunityUser communityUserInformation;
    private boolean shouldSaveCredentials;
    private Text username;
    private Text password;
    private Button btnReuseStoredCredentials;
    private Button btnStoreCommunityUserCredentials;

    public NewIssueAuthenticationPage() {
        super("authenticationInfoWizardPage");
        this.setImageDescriptor(JSSCommunityActivator.getDefault().getImageDescriptor("resources/images/softwareBug.png"));
        this.setTitle(Messages.NewIssueAuthenticationPage_Title);
        this.setDescription(Messages.NewIssueAuthenticationPage_Description);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        GridLayout glContainer = new GridLayout(2, false);
        glContainer.verticalSpacing = 10;
        glContainer.horizontalSpacing = 10;
        container.setLayout((Layout)glContainer);
        Link communityLink = new Link(container, 0);
        communityLink.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        communityLink.setText(Messages.NewIssueAuthenticationPage_CredentialsLink);
        communityLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowserUtils.openExternalBrowser((String)"https://community.jaspersoft.com/modal_forms/nojs/login");
            }
        });
        Label lblUsername = new Label(container, 0);
        lblUsername.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblUsername.setText(Messages.NewIssueAuthenticationPage_Username);
        this.username = new Text(container, 2048);
        this.username.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.username.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewIssueAuthenticationPage.this.checkForPageComplete();
            }
        });
        Label lblPassword = new Label(container, 0);
        lblPassword.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblPassword.setText(Messages.NewIssueAuthenticationPage_Password);
        this.password = new Text(container, 0x400800);
        this.password.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.password.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewIssueAuthenticationPage.this.checkForPageComplete();
            }
        });
        this.btnReuseStoredCredentials = new Button(container, 32);
        this.btnReuseStoredCredentials.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.btnReuseStoredCredentials.setText(Messages.NewIssueAuthenticationPage_ReuseCredentialsCheckbox);
        this.btnReuseStoredCredentials.setToolTipText(Messages.NewIssueAuthenticationPage_ReuseCredentialsCheckboxTooltip);
        this.btnReuseStoredCredentials.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewIssueAuthenticationPage.this.reuseCredentialsSelected();
            }
        });
        this.btnStoreCommunityUserCredentials = new Button(container, 32);
        this.btnStoreCommunityUserCredentials.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.btnStoreCommunityUserCredentials.setText(Messages.NewIssueAuthenticationPage_StoreUserCredentialsCheckbox);
        this.btnStoreCommunityUserCredentials.setToolTipText(Messages.NewIssueAuthenticationPage_StoreUserCredentialsCheckboxTooltip);
        this.btnStoreCommunityUserCredentials.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewIssueAuthenticationPage.this.shouldSaveCredentials = NewIssueAuthenticationPage.this.btnStoreCommunityUserCredentials.isEnabled() && NewIssueAuthenticationPage.this.btnStoreCommunityUserCredentials.getSelection();
                NewIssueAuthenticationPage.this.checkForPageComplete();
            }
        });
        this.setPageComplete(false);
        if (JSSCommunityActivator.getDefault().getCommunityUserInformation() == null) {
            this.btnReuseStoredCredentials.setEnabled(false);
        } else {
            this.btnReuseStoredCredentials.setSelection(true);
            this.reuseCredentialsSelected();
        }
    }

    private void reuseCredentialsSelected() {
        if (this.btnReuseStoredCredentials.getSelection()) {
            this.btnStoreCommunityUserCredentials.setEnabled(false);
            this.btnStoreCommunityUserCredentials.setSelection(false);
            this.communityUserInformation = JSSCommunityActivator.getDefault().getCommunityUserInformation();
            if (this.communityUserInformation == null) {
                MessageDialog.openWarning((Shell)UIUtils.getShell(), (String)Messages.NewIssueAuthenticationPage_WarningDialogTitle, (String)Messages.NewIssueAuthenticationPage_WarningDialogMsg);
                this.btnReuseStoredCredentials.setSelection(false);
                this.btnStoreCommunityUserCredentials.setEnabled(true);
            } else {
                this.username.setEnabled(false);
                this.username.setText(this.communityUserInformation.getUsername());
                this.password.setEnabled(false);
                this.password.setText(this.communityUserInformation.getPassword());
            }
        } else {
            this.btnStoreCommunityUserCredentials.setSelection(false);
            this.btnStoreCommunityUserCredentials.setEnabled(true);
            this.username.setEnabled(true);
            this.password.setEnabled(true);
            this.communityUserInformation = null;
        }
        this.checkForPageComplete();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.username.setFocus();
    }

    private void checkForPageComplete() {
        boolean isComplete = !this.username.getText().isEmpty() && !this.password.getText().isEmpty();
        this.setPageComplete(isComplete);
    }

    public CommunityUser getCommunityUserInformation() {
        if (this.communityUserInformation == null) {
            return new CommunityUser(this.username.getText(), this.password.getText());
        }
        return this.communityUserInformation;
    }

    public boolean shouldSaveCredentials() {
        return this.shouldSaveCredentials;
    }

    protected String getContextName() {
        return ContextHelpIDs.WIZARD_ISSUE_LOGIN;
    }
}

