/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.community.wizards;

import com.jaspersoft.studio.community.JSSCommunityActivator;
import com.jaspersoft.studio.community.issues.IssueField;
import com.jaspersoft.studio.community.issues.enums.Category;
import com.jaspersoft.studio.community.issues.enums.Priority;
import com.jaspersoft.studio.community.issues.enums.Reproducibility;
import com.jaspersoft.studio.community.issues.enums.Resolution;
import com.jaspersoft.studio.community.issues.enums.Severity;
import com.jaspersoft.studio.community.issues.enums.Status;
import com.jaspersoft.studio.community.messages.Messages;
import com.jaspersoft.studio.community.requests.IssueRequest;
import com.jaspersoft.studio.community.wizards.ContextHelpIDs;
import com.jaspersoft.studio.wizards.JSSHelpWizardPage;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewIssueDetailsPage
extends JSSHelpWizardPage {
    private static final int SHELL_INITIAL_HEIGHT = 550;
    private static final int SHELL_INITIAL_WIDTH = 650;
    private Text title;
    private Text description;
    private Combo category;
    private Combo priority;
    private Combo severity;
    private Combo reproducibility;

    public NewIssueDetailsPage() {
        super("issueDetailsWizardPage");
        this.setImageDescriptor(JSSCommunityActivator.getDefault().getImageDescriptor("resources/images/softwareBug.png"));
        this.setTitle(Messages.NewIssueDetailsPage_Title);
        this.setDescription(Messages.NewIssueDetailsPage_Description);
    }

    protected String getContextName() {
        return ContextHelpIDs.WIZARD_ISSUE_DETAIL;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        GridLayout glContainer = new GridLayout(4, false);
        glContainer.verticalSpacing = 10;
        glContainer.horizontalSpacing = 10;
        container.setLayout((Layout)glContainer);
        Label lblTitle = new Label(container, 0);
        lblTitle.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblTitle.setText(Messages.NewIssueDetailsPage_IssueTitle);
        this.title = new Text(container, 2048);
        this.title.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.title.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewIssueDetailsPage.this.checkPageComplete();
            }
        });
        Label lblDescription = new Label(container, 0);
        lblDescription.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
        lblDescription.setText(Messages.NewIssueDetailsPage_IssueDescription);
        this.description = new Text(container, 2114);
        GridData gdDescription = new GridData(4, 4, true, false, 3, 1);
        gdDescription.heightHint = 150;
        this.description.setLayoutData((Object)gdDescription);
        this.description.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewIssueDetailsPage.this.checkPageComplete();
            }
        });
        Label lblCategory = new Label(container, 0);
        lblCategory.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblCategory.setText(Messages.NewIssueDetailsPage_IssueCategory);
        this.category = new Combo(container, 8);
        this.category.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.category.addSelectionListener((SelectionListener)new PageCompletionChecker());
        Category[] categoryArray = Category.values();
        int n = categoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            Category c = categoryArray[n2];
            this.category.add(c.getText());
            this.category.setData(c.getText(), (Object)c.getValue());
            ++n2;
        }
        this.category.select(0);
        Label lblReproducibility = new Label(container, 0);
        lblReproducibility.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblReproducibility.setText(Messages.NewIssueDetailsPage_IssueReproducibility);
        this.reproducibility = new Combo(container, 8);
        this.reproducibility.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.reproducibility.addSelectionListener((SelectionListener)new PageCompletionChecker());
        Reproducibility[] reproducibilityArray = Reproducibility.values();
        int n3 = reproducibilityArray.length;
        n = 0;
        while (n < n3) {
            Reproducibility r = reproducibilityArray[n];
            this.reproducibility.add(r.getText());
            this.reproducibility.setData(r.getText(), (Object)r.getStringValue());
            ++n;
        }
        this.reproducibility.select(3);
        Label lblSeverity = new Label(container, 0);
        lblSeverity.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblSeverity.setText(Messages.NewIssueDetailsPage_IssueSeverity);
        this.severity = new Combo(container, 8);
        this.severity.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.severity.addSelectionListener((SelectionListener)new PageCompletionChecker());
        Severity[] severityArray = Severity.values();
        int n4 = severityArray.length;
        n3 = 0;
        while (n3 < n4) {
            Severity s = severityArray[n3];
            this.severity.add(s.getText());
            this.severity.setData(s.getText(), (Object)s.getStringValue());
            ++n3;
        }
        this.severity.select(4);
        Label lblPriority = new Label(container, 0);
        lblPriority.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblPriority.setText(Messages.NewIssueDetailsPage_IssuePriority);
        this.priority = new Combo(container, 8);
        this.priority.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.priority.addSelectionListener((SelectionListener)new PageCompletionChecker());
        Priority[] priorityArray = Priority.values();
        int n5 = priorityArray.length;
        n4 = 0;
        while (n4 < n5) {
            Priority p = priorityArray[n4];
            this.priority.add(p.getText());
            this.priority.setData(p.getText(), (Object)p.getStringValue());
            ++n4;
        }
        this.priority.select(1);
        UIUtils.resizeAndCenterShell((Shell)this.getShell(), (int)650, (int)550);
        this.setPageComplete(false);
    }

    public IssueRequest getIssueRequest() {
        IssueRequest issue = new IssueRequest(this.title.getText(), this.description.getText());
        issue.setCategory(new IssueField("field_bug_category", (String)this.category.getData(this.category.getText())));
        issue.setPriority(new IssueField("field_bug_priority", (String)this.priority.getData(this.priority.getText())));
        issue.setSeverity(new IssueField("field_bug_severity", (String)this.severity.getData(this.severity.getText())));
        issue.setReproducibility(new IssueField("field_bug_reproducibility", (String)this.reproducibility.getData(this.reproducibility.getText())));
        issue.setResolution(new IssueField("field_bug_resolution", Resolution.Open.getStringValue()));
        issue.setStatus(new IssueField("field_bug_status", Status.New.getStringValue()));
        issue.setProject(new IssueField("field_bug_project", String.valueOf(496)){

            @Override
            protected String getValueAttributeName() {
                return "target_id";
            }
        });
        return issue;
    }

    private void checkPageComplete() {
        boolean pageComplete = !this.title.getText().isEmpty() && !this.description.getText().isEmpty() && !this.category.getText().isEmpty() && !this.priority.getText().isEmpty() && !this.severity.getText().isEmpty() && !this.reproducibility.getText().isEmpty();
        this.setPageComplete(pageComplete);
    }

    private class PageCompletionChecker
    extends SelectionAdapter {
        private PageCompletionChecker() {
        }

        public void widgetSelected(SelectionEvent e) {
            NewIssueDetailsPage.this.checkPageComplete();
        }
    }
}

