/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.community.wizards;

import com.jaspersoft.studio.community.JSSCommunityActivator;
import com.jaspersoft.studio.community.issues.IssueField;
import com.jaspersoft.studio.community.issues.enums.Category;
import com.jaspersoft.studio.community.issues.enums.Priority;
import com.jaspersoft.studio.community.issues.enums.Reproducibility;
import com.jaspersoft.studio.community.issues.enums.Resolution;
import com.jaspersoft.studio.community.issues.enums.Severity;
import com.jaspersoft.studio.community.issues.enums.Status;
import com.jaspersoft.studio.community.messages.Messages;
import com.jaspersoft.studio.community.requests.IssueRequest;
import com.jaspersoft.studio.community.wizards.ContextHelpIDs;
import com.jaspersoft.studio.wizards.JSSHelpWizardPage;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewTranslationDetailsPage
extends JSSHelpWizardPage {
    private static final int SHELL_INITIAL_HEIGHT = 470;
    private static final int SHELL_INITIAL_WIDTH = 610;
    private Text title;
    private Text description;

    public NewTranslationDetailsPage() {
        super("issueDetailsWizardPage");
        this.setImageDescriptor(JSSCommunityActivator.getDefault().getImageDescriptor("resources/images/softwareBug.png"));
        this.setTitle(Messages.NewIssueDetailsPage_Title);
        this.setDescription(Messages.NewIssueDetailsPage_Description);
    }

    protected String getContextName() {
        return ContextHelpIDs.WIZARD_ISSUE_DETAIL;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        GridLayout glContainer = new GridLayout(4, false);
        glContainer.verticalSpacing = 10;
        glContainer.horizontalSpacing = 10;
        container.setLayout((Layout)glContainer);
        Label lblTitle = new Label(container, 0);
        lblTitle.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblTitle.setText(Messages.NewIssueDetailsPage_IssueTitle);
        this.title = new Text(container, 2048);
        this.title.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.title.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewTranslationDetailsPage.this.checkPageComplete();
            }
        });
        Label lblDescription = new Label(container, 0);
        lblDescription.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
        lblDescription.setText(Messages.NewIssueDetailsPage_IssueDescription);
        this.description = new Text(container, 2114);
        GridData gdDescription = new GridData(4, 4, true, false, 3, 1);
        gdDescription.heightHint = 150;
        this.description.setLayoutData((Object)gdDescription);
        this.description.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewTranslationDetailsPage.this.checkPageComplete();
            }
        });
        UIUtils.resizeAndCenterShell((Shell)this.getShell(), (int)610, (int)470);
        this.setPageComplete(false);
    }

    public IssueRequest getIssueRequest() {
        IssueRequest issue = new IssueRequest(this.title.getText(), this.description.getText());
        issue.setCategory(new IssueField("field_bug_category", Category.Enhancement.getValue()));
        issue.setPriority(new IssueField("field_bug_priority", Priority.Normal.getStringValue()));
        issue.setSeverity(new IssueField("field_bug_severity", Severity.Tweak.getStringValue()));
        issue.setReproducibility(new IssueField("field_bug_reproducibility", Reproducibility.Always.getStringValue()));
        issue.setResolution(new IssueField("field_bug_resolution", Resolution.Open.getStringValue()));
        issue.setStatus(new IssueField("field_bug_status", Status.New.getStringValue()));
        issue.setProject(new IssueField("field_bug_project", String.valueOf(496)){

            @Override
            protected String getValueAttributeName() {
                return "target_id";
            }
        });
        return issue;
    }

    private void checkPageComplete() {
        boolean pageComplete = !this.title.getText().isEmpty() && !this.description.getText().isEmpty();
        this.setPageComplete(pageComplete);
    }
}

