/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.community.wizards;

import com.jaspersoft.studio.community.JSSCommunityActivator;
import com.jaspersoft.studio.community.RESTCommunityHelper;
import com.jaspersoft.studio.community.messages.Messages;
import com.jaspersoft.studio.community.requests.IssueRequest;
import com.jaspersoft.studio.community.utils.CommunityAPIException;
import com.jaspersoft.studio.community.utils.CommunityUser;
import com.jaspersoft.studio.community.wizards.NewIssueAuthenticationPage;
import com.jaspersoft.studio.community.wizards.NewTranslationDetailsPage;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.HttpUtils;
import net.sf.jasperreports.eclipse.viewer.BrowserUtils;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public final class TranslationSendWizard
extends Wizard {
    private NewTranslationDetailsPage page1;
    private NewIssueAuthenticationPage page2;
    private boolean isPublished;
    private String issuePath;
    private File zipAttachment;

    public TranslationSendWizard(File zipAttachment) {
        this.setWindowTitle(Messages.IssueCreationWizard_Title);
        this.zipAttachment = zipAttachment;
    }

    public void addPages() {
        this.page1 = new NewTranslationDetailsPage();
        this.addPage((IWizardPage)this.page1);
        this.page2 = new NewIssueAuthenticationPage();
        this.addPage((IWizardPage)this.page2);
    }

    public boolean performFinish() {
        final IssueRequest issueRequest = this.page1.getIssueRequest();
        final CommunityUser authInfo = this.page2.getCommunityUserInformation();
        if (this.page2.shouldSaveCredentials()) {
            JSSCommunityActivator.getDefault().storeCommunityUserInformation(authInfo);
        }
        try {
            this.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.IssueCreationWizard_TaskName, -1);
                    TranslationSendWizard.this.isPublished = TranslationSendWizard.this.publishNewIssue(issueRequest, authInfo);
                    monitor.done();
                }
            });
        }
        catch (Exception e) {
            UIUtils.showError((Throwable)e);
        }
        if (this.isPublished) {
            new IssueCreatedDialog(this.getShell(), Messages.IssueCreationWizard_InfoDialogTitle, null, Messages.IssueCreationWizard_InfoDialogMessage, 2, new String[]{IDialogConstants.OK_LABEL}, 0).open();
        }
        return this.isPublished;
    }

    private boolean publishNewIssue(IssueRequest issueRequest, CommunityUser authInfo) {
        CloseableHttpClient httpclient = null;
        try {
            try {
                BasicCookieStore cookieStore = new BasicCookieStore();
                httpclient = HttpUtils.setupProxy((HttpClientBuilder)HttpClientBuilder.create()).setDefaultCookieStore((CookieStore)cookieStore).build();
                Cookie authCookie = RESTCommunityHelper.getAuthenticationCookie(httpclient, (CookieStore)cookieStore, authInfo.getUsername(), authInfo.getPassword());
                ArrayList<String> attachmentsIDs = new ArrayList<String>();
                String fileID = RESTCommunityHelper.uploadFile(httpclient, this.zipAttachment, authCookie);
                attachmentsIDs.add(fileID);
                this.issuePath = RESTCommunityHelper.createNewIssue(httpclient, issueRequest, attachmentsIDs, authCookie);
            }
            catch (CommunityAPIException e) {
                UIUtils.showError((Throwable)e);
                HttpClientUtils.closeQuietly(httpclient);
                return false;
            }
        }
        catch (Throwable throwable) {
            HttpClientUtils.closeQuietly(httpclient);
            throw throwable;
        }
        HttpClientUtils.closeQuietly((HttpClient)httpclient);
        return true;
    }

    private class IssueCreatedDialog
    extends MessageDialog {
        public IssueCreatedDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
            super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        }

        protected Control createCustomArea(Composite parent) {
            final StyledText issueLink = new StyledText(parent, 8);
            issueLink.setText(TranslationSendWizard.this.issuePath);
            issueLink.setBackground(parent.getBackground());
            issueLink.setLayoutData((Object)new GridData(131072, 128, true, false, 2, 1));
            StyleRange style = new StyleRange();
            style.underline = true;
            style.underlineStyle = 4;
            int[] nArray = new int[2];
            nArray[1] = TranslationSendWizard.this.issuePath.length();
            int[] ranges = nArray;
            StyleRange[] styles = new StyleRange[]{style};
            issueLink.setStyleRanges(ranges, styles);
            issueLink.addListener(3, new Listener(){

                public void handleEvent(Event event) {
                    try {
                        int offset = issueLink.getOffsetAtLocation(new Point(event.x, event.y));
                        StyleRange style = issueLink.getStyleRangeAtOffset(offset);
                        if (style != null && style.underline && style.underlineStyle == 4) {
                            BrowserUtils.openExternalBrowser((String)TranslationSendWizard.this.issuePath);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            });
            return issueLink;
        }
    }
}

