/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.translation.action;

import com.jaspersoft.translation.resources.TranslationFile;
import com.jaspersoft.translation.resources.TranslationInformation;
import com.jaspersoft.translation.resources.TranslationPackage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ProvideSelectedTranslation {
    private void createPackageInformation(File pluginDir, TranslationInformation pluginContainer) {
        File[] fileArray = pluginDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File pluginFile = fileArray[n2];
            if (pluginFile.isDirectory()) {
                TranslationPackage packageResource = new TranslationPackage(pluginFile.getAbsolutePath(), pluginFile.getName());
                File[] fileArray2 = pluginFile.listFiles();
                int n3 = fileArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    File packageFile = fileArray2[n4];
                    if (!packageFile.isDirectory()) {
                        packageResource.addFile(new TranslationFile(packageFile.getAbsolutePath(), packageFile.getName()));
                    }
                    ++n4;
                }
                pluginContainer.addResource(packageResource);
            } else {
                pluginContainer.addResource(new TranslationFile(pluginFile.getAbsolutePath(), pluginFile.getName()));
            }
            ++n2;
        }
    }

    private List<TranslationInformation> getResources(String rootPath) {
        ArrayList<TranslationInformation> projectInfo = new ArrayList<TranslationInformation>();
        File folder = new File(rootPath);
        File[] fileArray = folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File plugin = fileArray[n2];
            if (plugin.isDirectory()) {
                TranslationInformation pluginResource = new TranslationInformation(plugin.getName());
                this.createPackageInformation(plugin, pluginResource);
                projectInfo.add(pluginResource);
            }
            ++n2;
        }
        return projectInfo;
    }

    public List<TranslationInformation> execute() {
        ISelection selection;
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null && activeWorkbenchWindow.getActivePage() != null && (selection = activeWorkbenchWindow.getActivePage().getSelection()) instanceof IStructuredSelection) {
            for (Object element : (IStructuredSelection)selection) {
                IProject project = null;
                if (element instanceof IProject) {
                    project = (IProject)element;
                } else if (element instanceof IAdaptable) {
                    project = (IProject)((IAdaptable)element).getAdapter(IProject.class);
                }
                try {
                    if (project.hasNature("com.jaspersoft.studio.babel.editor.translationNature")) {
                        return this.getResources(project.getLocation().toString());
                    }
                    return null;
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }
}

