/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.translation.action;

import com.jaspersoft.translation.action.ZipUtils;
import com.jaspersoft.translation.resources.ISendTranslation;
import java.io.File;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class SendTranslationCommand
implements IHandler {
    private File zipResources(String rootPath) {
        ZipUtils zipUtils;
        boolean result;
        String tmpDirectory;
        String zipFilePath = tmpDirectory = System.getProperty("java.io.tmpdir");
        if (!tmpDirectory.endsWith("/") && !tmpDirectory.endsWith("\\")) {
            zipFilePath = String.valueOf(zipFilePath) + System.getProperty("file.separator");
        }
        if (result = (zipUtils = new ZipUtils()).zipFiles(rootPath, zipFilePath = String.valueOf(zipFilePath) + "translationFiles.zip")) {
            return new File(zipFilePath);
        }
        return null;
    }

    private void sendTranslation(IProject project) {
        IConfigurationElement[] elements;
        File content = this.zipResources(project.getLocation().toString());
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.jaspersoft.studio.babel.editor.resourceSender");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                Object input = element.createExecutableExtension("class");
                if (input instanceof ISendTranslation) {
                    ISendTranslation sender = (ISendTranslation)input;
                    sender.sendTranslation(content);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        if (selection instanceof IStructuredSelection) {
            for (Object element : (IStructuredSelection)selection) {
                IProject project = null;
                if (element instanceof IProject) {
                    project = (IProject)element;
                } else if (element instanceof IAdaptable) {
                    project = (IProject)((IAdaptable)element).getAdapter(IProject.class);
                }
                this.sendTranslation(project);
            }
        }
        return null;
    }

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }
}

