/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.core.message.checks.internal;

import java.util.ArrayList;
import org.eclipse.babel.core.message.IMessage;
import org.eclipse.babel.core.message.IMessagesBundle;
import org.eclipse.babel.core.message.IMessagesBundleGroup;
import org.eclipse.babel.core.message.checks.IMessageCheck;
import org.eclipse.babel.core.util.BabelUtils;

public class DuplicateValueCheck
implements IMessageCheck {
    private String[] duplicateKeys;

    public void reset() {
        this.duplicateKeys = null;
    }

    @Override
    public boolean checkKey(IMessagesBundleGroup messagesBundleGroup, IMessage message) {
        ArrayList<String> keys = new ArrayList<String>();
        if (message != null) {
            IMessagesBundle messagesBundle = messagesBundleGroup.getMessagesBundle(message.getLocale());
            for (IMessage duplicateEntry : messagesBundle.getMessages()) {
                if (message.getKey().equals(duplicateEntry.getKey()) || !BabelUtils.equals(message.getValue(), duplicateEntry.getValue())) continue;
                keys.add(duplicateEntry.getKey());
            }
            if (!keys.isEmpty()) {
                keys.add(message.getKey());
            }
        }
        this.duplicateKeys = keys.toArray(new String[0]);
        return !keys.isEmpty();
    }

    public String[] getDuplicateKeys() {
        return this.duplicateKeys;
    }
}

