/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.core.message.internal;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.babel.core.message.IMessage;
import org.eclipse.babel.core.message.IMessagesBundle;
import org.eclipse.babel.core.message.IMessagesBundleGroup;
import org.eclipse.babel.core.message.internal.AbstractMessageModel;
import org.eclipse.babel.core.message.internal.IMessagesBundleGroupListener;
import org.eclipse.babel.core.message.internal.IMessagesBundleListener;
import org.eclipse.babel.core.message.internal.Message;
import org.eclipse.babel.core.message.internal.MessageException;
import org.eclipse.babel.core.message.internal.MessagesBundle;
import org.eclipse.babel.core.message.manager.RBManager;
import org.eclipse.babel.core.message.strategy.IMessagesBundleGroupStrategy;
import org.eclipse.babel.core.message.strategy.PropertiesFileGroupStrategy;
import org.eclipse.babel.core.util.BabelUtils;

public class MessagesBundleGroup
extends AbstractMessageModel
implements IMessagesBundleGroup {
    private String projectName;
    private static final IMessagesBundleGroupListener[] EMPTY_GROUP_LISTENERS = new IMessagesBundleGroupListener[0];
    private static final Message[] EMPTY_MESSAGES = new Message[0];
    public static final String PROPERTY_MESSAGES_BUNDLE_COUNT = "messagesBundleCount";
    public static final String PROPERTY_KEY_COUNT = "keyCount";
    private static final long serialVersionUID = -1977849534191384324L;
    private final Map<Locale, IMessagesBundle> localeBundles = new HashMap<Locale, IMessagesBundle>();
    private final Set<String> keys = new TreeSet<String>();
    private final IMessagesBundleListener messagesBundleListener = new MessagesBundleListener();
    private final IMessagesBundleGroupStrategy groupStrategy;
    private static final Locale[] EMPTY_LOCALES = new Locale[0];
    private final String name;
    private final String resourceBundleId;

    public MessagesBundleGroup(IMessagesBundleGroupStrategy groupStrategy) {
        this.groupStrategy = groupStrategy;
        this.name = groupStrategy.createMessagesBundleGroupName();
        this.resourceBundleId = groupStrategy.createMessagesBundleId();
        this.projectName = groupStrategy.getProjectName();
        MessagesBundle[] bundles = groupStrategy.loadMessagesBundles();
        if (bundles != null) {
            int i = 0;
            while (i < bundles.length) {
                this.addMessagesBundle(bundles[i]);
                ++i;
            }
        }
        if (this.projectName != null) {
            RBManager.getInstance(this.projectName).notifyMessagesBundleGroupCreated(this);
        }
    }

    @Override
    public void dispose() {
        for (IMessagesBundle mb : this.getMessagesBundles()) {
            try {
                mb.dispose();
            }
            catch (Throwable throwable) {
                System.err.println("Error disposing message-bundle " + ((MessagesBundle)mb).getResource().getResourceLocationLabel());
            }
        }
        RBManager.getInstance(this.projectName).notifyMessagesBundleGroupDeleted(this);
    }

    @Override
    public IMessagesBundle getMessagesBundle(Locale locale) {
        return this.localeBundles.get(locale);
    }

    public MessagesBundle getMessagesBundle(Object source) {
        for (IMessagesBundle messagesBundle : this.getMessagesBundles()) {
            if (!this.equals(source, ((MessagesBundle)messagesBundle).getResource().getSource())) continue;
            return (MessagesBundle)messagesBundle;
        }
        return null;
    }

    public void addMessagesBundle(Locale locale) {
        this.addMessagesBundle(this.groupStrategy.createMessagesBundle(locale));
    }

    public IMessagesBundle copyMessagesBundle(Locale locale, IMessagesBundle source) {
        MessagesBundle destination = this.groupStrategy.createMessagesBundle(locale);
        if (source != null) {
            String[] stringArray = source.getKeys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                IMessage message = source.getMessage(key);
                destination.addMessage(message != null ? message.clone() : null);
                ++n2;
            }
        }
        this.addMessagesBundle(destination);
        return destination;
    }

    public Locale[] getLocales() {
        return this.localeBundles.keySet().toArray(EMPTY_LOCALES);
    }

    @Override
    public IMessage[] getMessages(String key) {
        ArrayList<IMessage> messages = new ArrayList<IMessage>();
        for (IMessagesBundle messagesBundle : this.getMessagesBundles()) {
            IMessage message = messagesBundle.getMessage(key);
            if (message == null) continue;
            messages.add(message);
        }
        return messages.toArray(EMPTY_MESSAGES);
    }

    @Override
    public IMessage getMessage(String key, Locale locale) {
        IMessagesBundle messagesBundle = this.getMessagesBundle(locale);
        if (messagesBundle != null) {
            return messagesBundle.getMessage(key);
        }
        return null;
    }

    public void addMessagesBundle(IMessagesBundle messagesBundle) {
        this.addMessagesBundle(messagesBundle.getLocale(), messagesBundle);
    }

    @Override
    public void addMessagesBundle(Locale locale, IMessagesBundle messagesBundle) {
        MessagesBundle mb = (MessagesBundle)messagesBundle;
        if (this.localeBundles.get(mb.getLocale()) != null) {
            throw new MessageException("A bundle with the same locale already exists.");
        }
        int oldBundleCount = this.localeBundles.size();
        this.localeBundles.put(mb.getLocale(), mb);
        this.firePropertyChange(PROPERTY_MESSAGES_BUNDLE_COUNT, oldBundleCount, this.localeBundles.size());
        this.fireMessagesBundleAdded(mb);
        String[] bundleKeys = mb.getKeys();
        int i = 0;
        while (i < bundleKeys.length) {
            String key = bundleKeys[i];
            if (!this.keys.contains(key)) {
                int oldKeyCount = this.keys.size();
                this.keys.add(key);
                this.firePropertyChange(PROPERTY_KEY_COUNT, oldKeyCount, this.keys.size());
                this.fireKeyAdded(key);
            }
            ++i;
        }
        mb.addMessagesBundleListener(this.messagesBundleListener);
    }

    @Override
    public void removeMessagesBundle(IMessagesBundle messagesBundle) {
        Locale locale = messagesBundle.getLocale();
        if (this.localeBundles.containsKey(locale)) {
            this.localeBundles.remove(locale);
        }
        TreeSet<String> keysNotToRemove = new TreeSet<String>();
        String[] stringArray = messagesBundle.getKeys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            for (IMessagesBundle bundle : this.localeBundles.values()) {
                if (bundle.getMessage(key) == null) continue;
                keysNotToRemove.add(key);
            }
            ++n2;
        }
        stringArray = messagesBundle.getKeys();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            String keyToRemove = stringArray[n2];
            if (!keysNotToRemove.contains(keyToRemove)) {
                this.keys.remove(keyToRemove);
            }
            ++n2;
        }
    }

    public void removeMessagesBundle(Locale locale) {
        this.removeMessagesBundle(this.getMessagesBundle(locale));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void addMessages(String key) {
        for (IMessagesBundle msgBundle : this.localeBundles.values()) {
            ((MessagesBundle)msgBundle).addMessage(key);
        }
    }

    @Override
    public void renameMessageKeys(String sourceKey, String targetKey) {
        for (IMessagesBundle msgBundle : this.localeBundles.values()) {
            msgBundle.renameMessageKey(sourceKey, targetKey);
        }
    }

    @Override
    public void removeMessages(String key) {
        for (IMessagesBundle msgBundle : this.localeBundles.values()) {
            msgBundle.removeMessage(key);
        }
    }

    @Override
    public void removeMessagesAddParentKey(String key) {
        for (IMessagesBundle msgBundle : this.localeBundles.values()) {
            msgBundle.removeMessageAddParentKey(key);
        }
    }

    public void setMessagesActive(String key, boolean active) {
        for (IMessagesBundle msgBundle : this.localeBundles.values()) {
            IMessage entry = msgBundle.getMessage(key);
            if (entry == null) continue;
            entry.setActive(active);
        }
    }

    public void duplicateMessages(String sourceKey, String targetKey) {
        if (sourceKey.equals(targetKey)) {
            return;
        }
        for (IMessagesBundle msgBundle : this.localeBundles.values()) {
            msgBundle.duplicateMessage(sourceKey, targetKey);
        }
    }

    @Override
    public Collection<IMessagesBundle> getMessagesBundles() {
        return this.localeBundles.values();
    }

    @Override
    public String[] getMessageKeys() {
        return this.keys.toArray(BabelUtils.EMPTY_STRINGS);
    }

    @Override
    public boolean isMessageKey(String key) {
        return this.keys.contains(key);
    }

    @Override
    public int getMessagesBundleCount() {
        return this.localeBundles.size();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MessagesBundleGroup)) {
            return false;
        }
        MessagesBundleGroup messagesBundleGroup = (MessagesBundleGroup)obj;
        return this.equals(this.localeBundles, messagesBundleGroup.localeBundles);
    }

    public final synchronized void addMessagesBundleGroupListener(IMessagesBundleGroupListener listener) {
        this.addPropertyChangeListener(listener);
    }

    public final synchronized void removeMessagesBundleGroupListener(IMessagesBundleGroupListener listener) {
        this.removePropertyChangeListener(listener);
    }

    public final synchronized IMessagesBundleGroupListener[] getMessagesBundleGroupListeners() {
        return Arrays.asList(this.getPropertyChangeListeners()).toArray(EMPTY_GROUP_LISTENERS);
    }

    private void fireKeyAdded(String key) {
        IMessagesBundleGroupListener[] listeners = this.getMessagesBundleGroupListeners();
        int i = 0;
        while (i < listeners.length) {
            IMessagesBundleGroupListener listener = listeners[i];
            listener.keyAdded(key);
            ++i;
        }
    }

    private void fireKeyRemoved(String key) {
        IMessagesBundleGroupListener[] listeners = this.getMessagesBundleGroupListeners();
        int i = 0;
        while (i < listeners.length) {
            IMessagesBundleGroupListener listener = listeners[i];
            listener.keyRemoved(key);
            ++i;
        }
    }

    private void fireMessagesBundleAdded(MessagesBundle messagesBundle) {
        IMessagesBundleGroupListener[] listeners = this.getMessagesBundleGroupListeners();
        int i = 0;
        while (i < listeners.length) {
            IMessagesBundleGroupListener listener = listeners[i];
            listener.messagesBundleAdded(messagesBundle);
            ++i;
        }
    }

    private void fireMessagesBundleRemoved(MessagesBundle messagesBundle) {
        IMessagesBundleGroupListener[] listeners = this.getMessagesBundleGroupListeners();
        int i = 0;
        while (i < listeners.length) {
            IMessagesBundleGroupListener listener = listeners[i];
            listener.messagesBundleRemoved(messagesBundle);
            ++i;
        }
    }

    @Override
    public boolean containsKey(String key) {
        for (Locale locale : this.localeBundles.keySet()) {
            IMessagesBundle messagesBundle = this.localeBundles.get(locale);
            String[] stringArray = messagesBundle.getKeys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String k = stringArray[n2];
                if (k.equals(key)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @Override
    public boolean isKey(String key) {
        return this.keys.contains(key);
    }

    @Override
    public String getResourceBundleId() {
        return this.resourceBundleId;
    }

    @Override
    public String getProjectName() {
        return this.projectName;
    }

    @Override
    public boolean hasPropertiesFileGroupStrategy() {
        return this.groupStrategy instanceof PropertiesFileGroupStrategy;
    }

    private class MessagesBundleListener
    implements IMessagesBundleListener {
        private MessagesBundleListener() {
        }

        @Override
        public void messageAdded(MessagesBundle messagesBundle, Message message) {
            int oldCount = MessagesBundleGroup.this.keys.size();
            IMessagesBundleGroupListener[] listeners = MessagesBundleGroup.this.getMessagesBundleGroupListeners();
            int i = 0;
            while (i < listeners.length) {
                IMessagesBundleGroupListener listener = listeners[i];
                listener.messageAdded(messagesBundle, message);
                if (MessagesBundleGroup.this.getMessages(message.getKey()).length == 1) {
                    MessagesBundleGroup.this.keys.add(message.getKey());
                    MessagesBundleGroup.this.firePropertyChange(MessagesBundleGroup.PROPERTY_KEY_COUNT, oldCount, MessagesBundleGroup.this.keys.size());
                    MessagesBundleGroup.this.fireKeyAdded(message.getKey());
                }
                ++i;
            }
        }

        @Override
        public void messageRemoved(MessagesBundle messagesBundle, Message message) {
            int oldCount = MessagesBundleGroup.this.keys.size();
            IMessagesBundleGroupListener[] listeners = MessagesBundleGroup.this.getMessagesBundleGroupListeners();
            int i = 0;
            while (i < listeners.length) {
                IMessagesBundleGroupListener listener = listeners[i];
                listener.messageRemoved(messagesBundle, message);
                int keyMessagesCount = MessagesBundleGroup.this.getMessages(message.getKey()).length;
                if (keyMessagesCount == 0 && MessagesBundleGroup.this.keys.contains(message.getKey())) {
                    MessagesBundleGroup.this.keys.remove(message.getKey());
                    MessagesBundleGroup.this.firePropertyChange(MessagesBundleGroup.PROPERTY_KEY_COUNT, oldCount, MessagesBundleGroup.this.keys.size());
                    MessagesBundleGroup.this.fireKeyRemoved(message.getKey());
                }
                ++i;
            }
        }

        @Override
        public void messageChanged(MessagesBundle messagesBundle, PropertyChangeEvent changeEvent) {
            IMessagesBundleGroupListener[] listeners = MessagesBundleGroup.this.getMessagesBundleGroupListeners();
            int i = 0;
            while (i < listeners.length) {
                IMessagesBundleGroupListener listener = listeners[i];
                listener.messageChanged(messagesBundle, changeEvent);
                ++i;
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            MessagesBundle bundle = (MessagesBundle)evt.getSource();
            IMessagesBundleGroupListener[] listeners = MessagesBundleGroup.this.getMessagesBundleGroupListeners();
            int i = 0;
            while (i < listeners.length) {
                IMessagesBundleGroupListener listener = listeners[i];
                listener.messagesBundleChanged(bundle, evt);
                ++i;
            }
        }
    }
}

