/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.core.refactoring;

import java.util.List;
import org.eclipse.babel.core.refactoring.KeyRefactoringDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class KeyRefactoringSummaryDialog
extends KeyRefactoringDialog {
    private List<String> changeSet;
    private Button okButton;
    private Label changesLabel;
    private Text changesText;

    public KeyRefactoringSummaryDialog(Shell parentShell) {
        super(parentShell);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        dialogArea.setLayout((Layout)layout);
        dialogArea.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.initLayout(dialogArea);
        return dialogArea;
    }

    private void initLayout(Composite parent) {
        this.changesLabel = new Label(parent, 0);
        this.changesLabel.setText("Changes:");
        this.changesText = new Text(parent, 2050);
        this.changesText.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.changesText.setEditable(false);
        this.changesText.setText(this.getChangeSetText());
    }

    private String getChangeSetText() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.changeSet) {
            sb.append(String.valueOf(s) + "\r\n");
        }
        return sb.toString();
    }

    public void setChangeSet(List<String> changeSet) {
        this.changeSet = changeSet;
    }

    @Override
    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Rename summary");
    }

    protected void okPressed() {
        this.setReturnCode(0);
        this.close();
    }

    @Override
    public void create() {
        super.create();
        KeyRefactoringDialog.DialogConfiguration config = this.getConfig();
        this.setTitle("Summary of key renaming: " + config.getPreselectedKey() + " -> " + config.getNewKey());
        this.setMessage("The resource bundle " + config.getPreselectedBundle() + " and " + this.changeSet.size() + " files of the project " + config.getProjectName() + " have been successfully modified.");
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, "Ok", true);
        this.okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KeyRefactoringSummaryDialog.this.setReturnCode(0);
                KeyRefactoringSummaryDialog.this.close();
            }
        });
        this.okButton.setEnabled(true);
    }
}

