/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.actions;

import org.eclipse.babel.editor.internal.AbstractMessagesEditor;
import org.eclipse.babel.editor.internal.MessagesEditorChangeAdapter;
import org.eclipse.babel.editor.internal.MessagesEditorContributor;
import org.eclipse.babel.editor.util.UIUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class FilterKeysAction
extends Action {
    private AbstractMessagesEditor editor;
    private final int flagToSet;
    private ChangeListener listener;

    public FilterKeysAction(int flagToSet) {
        super("", 2);
        this.flagToSet = flagToSet;
        this.listener = new ChangeListener();
        this.update();
    }

    public void run() {
        if (this.editor != null) {
            if (this.editor.isShowOnlyUnusedAndMissingKeys() != this.flagToSet) {
                this.editor.setShowOnlyUnusedMissingKeys(this.flagToSet);
            } else {
                this.editor.setShowOnlyUnusedMissingKeys(0);
            }
        }
    }

    public void update() {
        if (this.editor == null) {
            super.setEnabled(false);
        } else {
            super.setEnabled(true);
        }
        if (this.editor != null && this.editor.isShowOnlyUnusedAndMissingKeys() == this.flagToSet) {
            this.setChecked(true);
        } else {
            this.setChecked(false);
        }
        this.setText(this.getTextInternal());
        this.setToolTipText(this.getTooltipInternal());
        this.setImageDescriptor(ImageDescriptor.createFromImage((Image)this.getImage()));
    }

    public Image getImage() {
        switch (this.flagToSet) {
            case 2: {
                return UIUtils.getMissingTranslationImage();
            }
            case 1: {
                return UIUtils.getMissingAndUnusedTranslationsImage();
            }
            case 3: {
                return UIUtils.getUnusedTranslationsImage();
            }
        }
        return UIUtils.getImage("keyDefault.png");
    }

    public String getTextInternal() {
        switch (this.flagToSet) {
            case 2: {
                return "Show only missing translations";
            }
            case 1: {
                return "Show only missing or unused translations";
            }
            case 3: {
                return "Show only unused translations";
            }
        }
        return "Show all";
    }

    private String getTooltipInternal() {
        return this.getTextInternal();
    }

    public void setEditor(AbstractMessagesEditor editor) {
        if (editor == this.editor) {
            return;
        }
        if (this.editor != null) {
            this.editor.removeChangeListener(this.listener);
        }
        this.editor = editor;
        this.update();
        if (editor != null) {
            editor.addChangeListener(this.listener);
        }
    }

    private class ChangeListener
    extends MessagesEditorChangeAdapter {
        private ChangeListener() {
        }

        @Override
        public void showOnlyUnusedAndMissingChanged(int hideEverythingElse) {
            MessagesEditorContributor.FILTERS.updateActionBars();
        }
    }
}

