/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.actions;

import java.util.Locale;
import org.eclipse.babel.core.message.internal.MessagesBundleGroup;
import org.eclipse.babel.editor.internal.AbstractMessagesEditor;
import org.eclipse.babel.editor.util.UIUtils;
import org.eclipse.babel.editor.widgets.LocaleSelector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class NewLocaleAction
extends Action {
    private AbstractMessagesEditor editor;

    public NewLocaleAction() {
        super("New &Locale...");
        this.setToolTipText("Add a new locale to the resource bundle.");
        this.setImageDescriptor(UIUtils.getImageDescriptor("newpropertiesfile.gif"));
    }

    public void setEditor(AbstractMessagesEditor editor) {
        this.editor = editor;
    }

    public void run() {
        Dialog localeDialog = new Dialog(this.editor.getSite().getShell()){
            LocaleSelector selector;

            protected void configureShell(Shell newShell) {
                super.configureShell(newShell);
                newShell.setText("Add new local");
            }

            protected Control createDialogArea(Composite parent) {
                Composite comp = (Composite)super.createDialogArea(parent);
                this.selector = new LocaleSelector(comp);
                return comp;
            }

            protected void okPressed() {
                Locale[] locales;
                MessagesBundleGroup bundleGroup = NewLocaleAction.this.editor.getBundleGroup();
                Locale newLocal = this.selector.getSelectedLocale();
                boolean existsLocal = false;
                Locale[] localeArray = locales = bundleGroup.getLocales();
                int n = locales.length;
                int n2 = 0;
                while (n2 < n) {
                    Locale locale = localeArray[n2];
                    if (locale == null) {
                        if (newLocal == null) {
                            existsLocal = true;
                            break;
                        }
                    } else if (locale.equals(newLocal)) {
                        existsLocal = true;
                        break;
                    }
                    ++n2;
                }
                if (!existsLocal) {
                    bundleGroup.addMessagesBundle(newLocal);
                }
                super.okPressed();
            }
        };
        localeDialog.open();
    }
}

