/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.babel.core.message.IMessagesBundleGroup;
import org.eclipse.babel.core.message.tree.IKeyTreeNode;
import org.eclipse.babel.core.message.tree.internal.KeyTreeNode;
import org.eclipse.babel.editor.api.IValuedKeyTreeNode;

public class ValuedKeyTreeNode
extends KeyTreeNode
implements IValuedKeyTreeNode {
    private Map<Locale, String> values = new HashMap<Locale, String>();
    private Object info;

    public ValuedKeyTreeNode(IKeyTreeNode parent, String name, String messageKey, IMessagesBundleGroup messagesBundleGroup) {
        super(parent, name, messageKey, messagesBundleGroup);
    }

    @Override
    public void initValues(Map<Locale, String> values) {
        this.values = values;
    }

    @Override
    public void addValue(Locale locale, String value) {
        this.values.put(locale, value);
    }

    @Override
    public String getValue(Locale locale) {
        return this.values.get(locale);
    }

    @Override
    public void setValue(Locale locale, String newValue) {
        if (this.values.containsKey(locale)) {
            this.values.remove(locale);
        }
        this.addValue(locale, newValue);
    }

    @Override
    public Collection<String> getValues() {
        return this.values.values();
    }

    @Override
    public void setInfo(Object info) {
        this.info = info;
    }

    @Override
    public Object getInfo() {
        return this.info;
    }

    @Override
    public Collection<Locale> getLocales() {
        ArrayList<Locale> locs = new ArrayList<Locale>();
        for (Locale loc : this.values.keySet()) {
            locs.add(loc);
        }
        return locs;
    }
}

