/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.bundle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.babel.core.message.internal.MessagesBundle;
import org.eclipse.babel.core.util.BabelUtils;
import org.eclipse.babel.editor.bundle.DefaultBundleGroupStrategy;
import org.eclipse.babel.editor.bundle.MessagesBundleGroupFactory;
import org.eclipse.babel.editor.bundle.NLFragmentBundleGroupStrategy;
import org.eclipse.babel.editor.util.UIUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IEditorSite;

public class NLPluginBundleGroupStrategy
extends DefaultBundleGroupStrategy {
    private static Set<String> ISO_LANG_CODES = new HashSet<String>();
    private static Set<String> ISO_COUNTRY_CODES = new HashSet<String>();
    private IProject[] associatedFragmentProjects;
    protected IFolder nlFolder;
    protected String basePathInsideNL;

    static {
        String[] isos = Locale.getISOLanguages();
        int i = 0;
        while (i < isos.length) {
            ISO_LANG_CODES.add(isos[i]);
            ++i;
        }
        String[] isoc = Locale.getISOCountries();
        int i2 = 0;
        while (i2 < isoc.length) {
            ISO_COUNTRY_CODES.add(isoc[i2]);
            ++i2;
        }
    }

    public NLPluginBundleGroupStrategy(IEditorSite site, IFile file, IFolder nlFolder, IProject[] associatedFragmentProjects) {
        super(site, file);
        this.nlFolder = nlFolder;
        this.associatedFragmentProjects = associatedFragmentProjects;
    }

    public NLPluginBundleGroupStrategy(IEditorSite site, IFile file, IFolder nlFolder) {
        super(site, file);
        this.nlFolder = nlFolder;
    }

    @Override
    public MessagesBundle[] loadMessagesBundles() {
        ArrayList<IFolder> nlFolders;
        final ArrayList<MessagesBundle> bundles = new ArrayList<MessagesBundle>();
        ArrayList<IFolder> arrayList = nlFolders = this.nlFolder != null ? new ArrayList<IFolder>() : null;
        if (this.associatedFragmentProjects != null) {
            IPath basePath = null;
            boolean fileIsInsideClasses = false;
            boolean fileHasLocaleSuffix = false;
            if (this.nlFolder == null) {
                basePath = this.removePathToSourceFolder(this.getOpenedFile().getParent().getProjectRelativePath());
                fileIsInsideClasses = !basePath.equals((Object)this.getOpenedFile().getParent().getProjectRelativePath());
                boolean bl = fileHasLocaleSuffix = !this.getOpenedFile().getName().equals(String.valueOf(super.getBaseName()) + ".properties");
                if (!fileHasLocaleSuffix && !fileIsInsideClasses) {
                    this.basePathInsideNL = basePath.toString();
                }
            } else {
                this.extractLocale(this.getOpenedFile(), true);
                basePath = new Path(this.basePathInsideNL);
            }
            int i = 0;
            while (i < this.associatedFragmentProjects.length) {
                IProject frag = this.associatedFragmentProjects[i];
                if (fileIsInsideClasses) {
                    Collection<String> srcPathes = NLFragmentBundleGroupStrategy.getSourceFolderPathes(frag);
                    if (srcPathes != null) {
                        for (String srcPath : srcPathes) {
                            new Path(srcPath).append(basePath);
                            super.collectBundlesInContainer(NLPluginBundleGroupStrategy.getContainer(frag, basePath), bundles);
                        }
                    }
                    super.collectBundlesInContainer(NLPluginBundleGroupStrategy.getContainer(frag, basePath), bundles);
                } else {
                    IFolder nl = frag.getFolder("nl");
                    if (nl != null && nl.exists()) {
                        if (nlFolders == null) {
                            nlFolders = new ArrayList();
                        }
                        nlFolders.add(nl);
                    }
                    if (!fileHasLocaleSuffix) {
                        super.collectBundlesInContainer(NLPluginBundleGroupStrategy.getContainer(frag, basePath), bundles);
                    }
                }
                ++i;
            }
        }
        if (nlFolders == null) {
            this.collectBundlesInContainer(this.getOpenedFile().getParent(), bundles);
            return bundles.toArray(EMPTY_BUNDLES);
        }
        if (this.nlFolder != null) {
            nlFolders.add(this.nlFolder);
        }
        final String name = this.getOpenedFile().getName();
        IResourceVisitor visitor = new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                Locale locale;
                if (resource.getType() == 1 && resource.getName().equals(name) && !NLPluginBundleGroupStrategy.this.getOpenedFile().equals((Object)resource) && (locale = NLPluginBundleGroupStrategy.this.extractLocale((IFile)resource, false)) != null && UIUtils.isDisplayed(locale)) {
                    bundles.add(NLPluginBundleGroupStrategy.this.createBundle(locale, resource));
                }
                return true;
            }
        };
        try {
            Locale locale = this.extractLocale(this.getOpenedFile(), true);
            if (UIUtils.isDisplayed(locale)) {
                bundles.add(this.createBundle(locale, (IResource)this.getOpenedFile()));
            }
            for (IFolder nlFolder : nlFolders) {
                nlFolder.accept(visitor);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        IContainer container = null;
        for (MessagesBundle mb : bundles) {
            if (mb.getLocale() != null && !mb.getLocale().equals(UIUtils.ROOT_LOCALE)) continue;
            Object src = mb.getResource().getSource();
            if (!(src instanceof IFile)) break;
            container = ((IFile)src).getParent();
            break;
        }
        if (container != null) {
            super.collectBundlesInContainer(container, bundles);
        }
        return bundles.toArray(EMPTY_BUNDLES);
    }

    private static final IContainer getContainer(IProject proj, IPath containerPath) {
        if (containerPath.segmentCount() == 0) {
            return proj;
        }
        return proj.getFolder(containerPath);
    }

    protected IPath removePathToSourceFolder(IPath baseContainerPath) {
        Collection<String> srcPathes = NLFragmentBundleGroupStrategy.getSourceFolderPathes(this.getOpenedFile().getProject());
        if (srcPathes == null) {
            return baseContainerPath;
        }
        String projRelativePathStr = baseContainerPath.toString();
        for (String srcPath : srcPathes) {
            if (!projRelativePathStr.startsWith(srcPath)) continue;
            return new Path(projRelativePathStr.substring(srcPath.length()));
        }
        return baseContainerPath;
    }

    private Locale extractLocale(IFile file, boolean docomputeBasePath) {
        IFolder nl = MessagesBundleGroupFactory.getNLFolder(file);
        String path = file.getFullPath().removeFileExtension().toString();
        if (nl == null) {
            int ind = path.indexOf(95);
            int maxInd = path.length() - 1;
            while (ind != -1 && ind < maxInd) {
                String possibleLocale = path.substring(ind + 1);
                Locale res = BabelUtils.parseLocale(possibleLocale);
                if (res != null) {
                    return res;
                }
                ind = path.indexOf(95, ind + 1);
            }
            return null;
        }
        int ind = path.lastIndexOf("/nl/");
        if (ind != -1) {
            int lastFolder = path.lastIndexOf(47);
            if (lastFolder == (ind += "/nl/".length())) {
                return UIUtils.ROOT_LOCALE;
            }
            path = path.substring(ind, lastFolder);
            StringTokenizer tokens = new StringTokenizer(path, "/", false);
            switch (tokens.countTokens()) {
                case 0: {
                    return null;
                }
                case 1: {
                    String lang = tokens.nextToken();
                    if (!ISO_LANG_CODES.contains(lang)) {
                        return null;
                    }
                    if (docomputeBasePath) {
                        this.basePathInsideNL = "";
                        return new Locale(lang);
                    }
                    if ("".equals(this.basePathInsideNL)) {
                        return new Locale(lang);
                    }
                    return null;
                }
                case 2: {
                    String lang = tokens.nextToken();
                    if (!ISO_LANG_CODES.contains(lang)) {
                        return null;
                    }
                    String country = tokens.nextToken();
                    if (!ISO_COUNTRY_CODES.contains(country) && this.isExistingFirstFolderForDefaultLocale(country)) {
                        if (docomputeBasePath) {
                            this.basePathInsideNL = country;
                            return new Locale(lang);
                        }
                        if (this.basePathInsideNL.equals(country)) {
                            return new Locale(lang);
                        }
                        return null;
                    }
                    if (docomputeBasePath) {
                        this.basePathInsideNL = "";
                        return new Locale(lang, country);
                    }
                    if (this.basePathInsideNL.equals(country)) {
                        return new Locale(lang, country);
                    }
                    return null;
                }
            }
            String lang = tokens.nextToken();
            if (!ISO_LANG_CODES.contains(lang)) {
                return null;
            }
            String country = tokens.nextToken();
            if (!ISO_COUNTRY_CODES.contains(country) && this.isExistingFirstFolderForDefaultLocale(country)) {
                StringBuffer b = new StringBuffer(country);
                while (tokens.hasMoreTokens()) {
                    b.append("/" + tokens.nextToken());
                }
                if (docomputeBasePath) {
                    this.basePathInsideNL = b.toString();
                    return new Locale(lang);
                }
                if (this.basePathInsideNL.equals(b.toString())) {
                    return new Locale(lang);
                }
                return null;
            }
            String variant = tokens.nextToken();
            if (this.isExistingFirstFolderForDefaultLocale(variant)) {
                StringBuffer b = new StringBuffer(variant);
                while (tokens.hasMoreTokens()) {
                    b.append("/" + tokens.nextToken());
                }
                if (docomputeBasePath) {
                    this.basePathInsideNL = b.toString();
                    return new Locale(lang, country);
                }
                if (this.basePathInsideNL.equals(b.toString())) {
                    return new Locale(lang);
                }
                return null;
            }
            StringBuffer b = new StringBuffer();
            while (tokens.hasMoreTokens()) {
                b.append("/" + tokens.nextToken());
            }
            if (docomputeBasePath) {
                this.basePathInsideNL = b.toString();
                return new Locale(lang, country, variant);
            }
            if (this.basePathInsideNL.equals(b.toString())) {
                return new Locale(lang);
            }
            return null;
        }
        return UIUtils.ROOT_LOCALE;
    }

    protected boolean isExistingFirstFolderForDefaultLocale(String folderName) {
        return this.getOpenedFile().getProject().getFolder(folderName).exists();
    }
}

