/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.i18n;

import java.util.Locale;
import org.eclipse.babel.core.message.IMessage;
import org.eclipse.babel.core.message.internal.MessagesBundleGroup;
import org.eclipse.babel.core.util.BabelUtils;
import org.eclipse.babel.editor.i18n.AbstractI18NEntry;
import org.eclipse.babel.editor.internal.AbstractMessagesEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;

public class I18NEntry
extends AbstractI18NEntry {
    public I18NEntry(Composite parent, AbstractMessagesEditor editor, Locale locale) {
        super(parent, editor, locale);
    }

    @Override
    void updateKey(String key) {
        MessagesBundleGroup messagesBundleGroup = this.editor.getBundleGroup();
        boolean isKey = key != null && messagesBundleGroup.isMessageKey(key);
        this.textBox.setEnabled(isKey);
        if (isKey) {
            IMessage entry = messagesBundleGroup.getMessage(key, this.locale);
            if (entry == null || entry.getValue() == null) {
                this.textBox.setText(null);
            } else {
                this.textBox.setText(entry.getValue());
            }
        } else {
            this.textBox.setText(null);
        }
    }

    @Override
    KeyListener getKeyListener() {
        return new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                if (!BabelUtils.equals(I18NEntry.this.focusGainedText, I18NEntry.this.textBox.getText()) && !I18NEntry.this.editor.isDirty()) {
                    I18NEntry.this.updateModel();
                }
            }
        };
    }
}

