/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.i18n;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.babel.core.message.IMessagesBundle;
import org.eclipse.babel.core.message.manager.IMessagesEditorListener;
import org.eclipse.babel.core.message.manager.RBManager;
import org.eclipse.babel.editor.IMessagesEditorChangeListener;
import org.eclipse.babel.editor.i18n.AbstractI18NEntry;
import org.eclipse.babel.editor.i18n.I18NEntry;
import org.eclipse.babel.editor.i18n.SideNavComposite;
import org.eclipse.babel.editor.i18n.SideNavTextBoxComposite;
import org.eclipse.babel.editor.internal.AbstractMessagesEditor;
import org.eclipse.babel.editor.util.UIUtils;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;

public class I18NPage
extends ScrolledComposite
implements ISelectionProvider {
    private static final int TEXT_MIN_HEIGHT = 90;
    protected final AbstractMessagesEditor editor;
    protected final SideNavComposite keysComposite;
    private final Composite valuesComposite;
    private final Map<Locale, AbstractI18NEntry> entryComposites = new HashMap<Locale, AbstractI18NEntry>();
    private Composite entriesComposite;
    private boolean keyTreeVisible = true;
    private final SashForm sashForm;

    public I18NPage(Composite parent, int style, final AbstractMessagesEditor editor) {
        super(parent, style);
        this.editor = editor;
        this.sashForm = new SashForm((Composite)this, 65536);
        this.sashForm.setBackground(UIUtils.getSystemColor(32));
        editor.getEditorSite().getPage().addPartListener(new IPartListener(){

            public void partActivated(IWorkbenchPart part) {
                if (part == editor && !I18NPage.this.sashForm.isDisposed()) {
                    I18NPage.this.sashForm.setBackground(UIUtils.getSystemColor(32));
                }
            }

            public void partDeactivated(IWorkbenchPart part) {
                if (part == editor && !I18NPage.this.sashForm.isDisposed()) {
                    I18NPage.this.sashForm.setBackground(UIUtils.getSystemColor(22));
                }
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
            }

            public void partOpened(IWorkbenchPart part) {
            }
        });
        this.setContent((Control)this.sashForm);
        this.keysComposite = new SideNavComposite((Composite)this.sashForm, editor);
        this.valuesComposite = this.createValuesComposite(this.sashForm);
        this.sashForm.setWeights(new int[]{25, 75});
        this.setExpandHorizontal(true);
        this.setExpandVertical(true);
        this.setMinWidth(400);
        RBManager instance = RBManager.getInstance(editor.getBundleGroup().getProjectName());
        instance.addMessagesEditorListener(new IMessagesEditorListener(){

            @Override
            public void onSave() {
            }

            @Override
            public void onModify() {
            }

            @Override
            public void onResourceChanged(IMessagesBundle bundle) {
                AbstractI18NEntry i18nEntry;
                Display display;
                if (!I18NPage.this.keysComposite.isDisposed() && (display = I18NPage.this.keysComposite.getTreeViewer().getTree().getDisplay()).equals(Display.getCurrent()) && (i18nEntry = (AbstractI18NEntry)((Object)I18NPage.this.entryComposites.get(bundle.getLocale()))) != null && !I18NPage.this.getSelection().isEmpty()) {
                    i18nEntry.updateKey(String.valueOf(((IStructuredSelection)I18NPage.this.getSelection()).getFirstElement()));
                }
            }
        });
    }

    public void dispose() {
        this.keysComposite.dispose();
        for (AbstractI18NEntry entry : this.entryComposites.values()) {
            entry.dispose();
        }
        super.dispose();
    }

    public void setKeyTreeVisible(boolean visible) {
        this.keyTreeVisible = visible;
        if (visible) {
            this.sashForm.setMaximizedControl(null);
        } else {
            this.sashForm.setMaximizedControl((Control)this.valuesComposite);
        }
        for (IMessagesEditorChangeListener listener : this.editor.getChangeListeners()) {
            listener.keyTreeVisibleChanged(visible);
        }
    }

    public boolean isKeyTreeVisible() {
        return this.keyTreeVisible;
    }

    private Composite createValuesComposite(SashForm parent) {
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)parent, 768);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setSize(-1, 100);
        this.entriesComposite = new Composite((Composite)scrolledComposite, 2048);
        scrolledComposite.setContent((Control)this.entriesComposite);
        scrolledComposite.setMinSize(this.entriesComposite.computeSize(-1, this.editor.getBundleGroup().getLocales().length * 90));
        this.entriesComposite.setLayout((Layout)new GridLayout(1, false));
        Locale[] locales = this.editor.getBundleGroup().getLocales();
        UIUtils.sortLocales(locales);
        locales = UIUtils.filterLocales(locales);
        int i = 0;
        while (i < locales.length) {
            Locale locale = locales[i];
            this.addI18NEntry(locale);
            ++i;
        }
        return scrolledComposite;
    }

    public void addI18NEntry(Locale locale) {
        I18NEntry i18NEntry = null;
        try {
            i18NEntry = new I18NEntry(this.entriesComposite, this.editor, locale);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.entryComposites.put(locale, i18NEntry);
        this.entriesComposite.layout();
    }

    public void removeI18NEntry(Locale locale) {
        AbstractI18NEntry i18NEntry = this.entryComposites.get(locale);
        if (i18NEntry != null) {
            i18NEntry.dispose();
            this.entryComposites.remove(locale);
            this.entriesComposite.layout();
        }
    }

    public void selectLocale(Locale locale) {
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.keysComposite.getTreeViewer().addSelectionChangedListener(listener);
    }

    public ISelection getSelection() {
        return this.keysComposite.getTreeViewer().getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.keysComposite.getTreeViewer().removeSelectionChangedListener(listener);
    }

    public void setSelection(ISelection selection) {
        this.keysComposite.getTreeViewer().setSelection(selection);
    }

    public TreeViewer getTreeViewer() {
        return this.keysComposite.getTreeViewer();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (AbstractI18NEntry entry : this.entryComposites.values()) {
            entry.setEnabled(enabled);
        }
    }

    public void setEnabled(boolean enabled, Locale locale) {
        for (AbstractI18NEntry entry : this.entryComposites.values()) {
            if (locale != entry.getLocale() && (locale == null || !locale.equals(entry.getLocale()))) continue;
            entry.setEnabled(enabled);
            break;
        }
    }

    public SideNavTextBoxComposite getSidNavTextBoxComposite() {
        return this.keysComposite.getSidNavTextBoxComposite();
    }
}

