/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.i18n;

import org.eclipse.babel.core.message.tree.IKeyTreeNode;
import org.eclipse.babel.core.message.tree.visitor.NodePathRegexVisitor;
import org.eclipse.babel.editor.internal.AbstractMessagesEditor;
import org.eclipse.babel.editor.internal.MessagesEditorChangeAdapter;
import org.eclipse.babel.messages.Messages;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SideNavTextBoxComposite
extends Composite {
    private boolean syncAddTextBox = true;
    private Text addTextBox;
    private Button addButton;
    private AbstractMessagesEditor editor;

    public SideNavTextBoxComposite(Composite parent, final AbstractMessagesEditor editor) {
        super(parent, 0);
        this.editor = editor;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 2;
        gridData.grabExcessHorizontalSpace = true;
        this.setLayoutData(gridData);
        this.addTextBox = new Text((Composite)this, 2048);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.addTextBox.setLayoutData((Object)gridData);
        this.addButton = new Button((Composite)this, 8);
        this.addButton.setText(Messages.key_add);
        this.addButton.setEnabled(false);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SideNavTextBoxComposite.this.addKey(SideNavTextBoxComposite.this.addTextBox.getText());
            }
        });
        this.addTextBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                String key = SideNavTextBoxComposite.this.addTextBox.getText();
                if (event.character == '\r' && SideNavTextBoxComposite.this.isNewKey(key)) {
                    SideNavTextBoxComposite.this.addKey(key);
                } else if (key.length() > 0) {
                    NodePathRegexVisitor visitor = new NodePathRegexVisitor("^" + key + ".*");
                    editor.getKeyTreeModel().accept(visitor, null);
                    IKeyTreeNode node = visitor.getKeyTreeNode();
                    if (node != null) {
                        SideNavTextBoxComposite.this.syncAddTextBox = false;
                        editor.setSelectedKey(node.getMessageKey());
                    }
                }
            }
        });
        this.addTextBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                SideNavTextBoxComposite.this.addButton.setEnabled(SideNavTextBoxComposite.this.isNewKey(SideNavTextBoxComposite.this.addTextBox.getText()));
            }
        });
        editor.addChangeListener(new MessagesEditorChangeAdapter(){

            @Override
            public void selectedKeyChanged(String oldKey, String newKey) {
                if (SideNavTextBoxComposite.this.syncAddTextBox && newKey != null) {
                    SideNavTextBoxComposite.this.addTextBox.setText(newKey);
                }
                SideNavTextBoxComposite.this.syncAddTextBox = true;
            }
        });
    }

    private void addKey(String key) {
        this.editor.getBundleGroup().addMessages(key);
        this.editor.setSelectedKey(key);
    }

    private boolean isNewKey(String key) {
        return !this.editor.getBundleGroup().isMessageKey(key) && key.length() > 0;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.addButton.setEnabled(enabled);
    }
}

