/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.plugin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.babel.core.message.internal.AbstractIFileChangeListener;
import org.eclipse.babel.editor.builder.ToggleNatureAction;
import org.eclipse.babel.editor.preferences.MsgEditorPreferences;
import org.eclipse.babel.swt.ResourceManager;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.pde.nls.internal.ui.model.ResourceBundleModel;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class MessagesEditorPlugin
extends AbstractUIPlugin
implements AbstractIFileChangeListener.IFileChangeListenerRegistry {
    public static final String MARKER_TYPE = "org.eclipse.babel.editor.nlsproblem";
    public static final String PLUGIN_ID = "com.jaspersoft.studio.babel.editor";
    private static MessagesEditorPlugin plugin;
    private IResourceChangeListener resourceChangeListener;
    private Map<String, Set<AbstractIFileChangeListener>> resourceChangeSubscribers = new HashMap<String, Set<AbstractIFileChangeListener>>();
    private ResourceBundleModel model;

    public MessagesEditorPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        if (MsgEditorPreferences.isBuilderSetupAutomatically()) {
            ToggleNatureAction.addOrRemoveNatureOnAllJavaProjects(true);
        }
        this.resourceChangeListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IResource resource = event.getResource();
                if (resource != null) {
                    String fullpath = resource.getFullPath().toString();
                    Set listeners = (Set)MessagesEditorPlugin.this.resourceChangeSubscribers.get(fullpath);
                    if (listeners != null) {
                        AbstractIFileChangeListener[] larray = listeners.toArray(new AbstractIFileChangeListener[0]);
                        int i = 0;
                        while (i < larray.length) {
                            larray[i].listenedFileChanged(event);
                            ++i;
                        }
                    }
                }
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener);
        try {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Display.getDefault().addFilter(2, (Listener)new UndoKeyListener());
                }
            });
        }
        catch (NullPointerException nullPointerException) {}
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        super.stop(context);
        ResourceManager.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(AbstractIFileChangeListener fileChangeListener) {
        IResourceChangeListener iResourceChangeListener = this.resourceChangeListener;
        synchronized (iResourceChangeListener) {
            String channel = fileChangeListener.getListenedFileFullPath();
            Set<AbstractIFileChangeListener> channelListeners = this.resourceChangeSubscribers.get(channel);
            if (channelListeners == null) {
                channelListeners = new HashSet<AbstractIFileChangeListener>();
                this.resourceChangeSubscribers.put(channel, channelListeners);
            }
            channelListeners.add(fileChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribe(AbstractIFileChangeListener fileChangeListener) {
        IResourceChangeListener iResourceChangeListener = this.resourceChangeListener;
        synchronized (iResourceChangeListener) {
            String channel = fileChangeListener.getListenedFileFullPath();
            Set<AbstractIFileChangeListener> channelListeners = this.resourceChangeSubscribers.get(channel);
            if (channelListeners != null && channelListeners.remove(fileChangeListener) && channelListeners.isEmpty()) {
                this.resourceChangeSubscribers.remove(channel);
            }
        }
    }

    public static MessagesEditorPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String filename) {
        String iconPath = "icons/";
        return MessagesEditorPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)(String.valueOf(iconPath) + filename));
    }

    public static ResourceBundleModel getModel(IProgressMonitor monitor) {
        if (MessagesEditorPlugin.plugin.model == null) {
            MessagesEditorPlugin.plugin.model = new ResourceBundleModel(monitor);
        }
        return MessagesEditorPlugin.plugin.model;
    }

    public static void disposeModel() {
        if (plugin != null) {
            MessagesEditorPlugin.plugin.model = null;
        }
    }

    public static IStatus log(Throwable e) {
        return MessagesEditorPlugin.log((IStatus)new Status(4, PLUGIN_ID, 0, "Internal error.", e));
    }

    public static IStatus log(String message, Throwable exception) {
        return MessagesEditorPlugin.log((IStatus)new Status(4, PLUGIN_ID, -1, message, exception));
    }

    public static IStatus log(IStatus status) {
        MessagesEditorPlugin.getDefault().getLog().log(status);
        return status;
    }

    private static class UndoKeyListener
    implements Listener {
        private UndoKeyListener() {
        }

        public void handleEvent(Event event) {
            Control focusControl = event.display.getFocusControl();
            if (event.stateMask == 262144 && focusControl instanceof Text) {
                Text txt = (Text)focusControl;
                String actText = txt.getText();
                Stack undoStack = (Stack)txt.getData("UNDO");
                Stack redoStack = (Stack)txt.getData("REDO");
                if (event.keyCode == 122 && undoStack != null && redoStack != null) {
                    event.doit = false;
                    if (undoStack.size() > 0) {
                        String peek = (String)undoStack.peek();
                        if (actText != null && !txt.getText().equals(peek)) {
                            String pop = (String)undoStack.pop();
                            txt.setText(pop);
                            txt.setSelection(pop.length());
                            redoStack.push(actText);
                        }
                    }
                } else if (event.keyCode == 121 && undoStack != null && redoStack != null) {
                    event.doit = false;
                    if (redoStack.size() > 0) {
                        String peek = (String)redoStack.peek();
                        if (actText != null && !txt.getText().equals(peek)) {
                            String pop = (String)redoStack.pop();
                            txt.setText(pop);
                            txt.setSelection(pop.length());
                            undoStack.push(actText);
                        }
                    }
                }
            }
        }
    }
}

