/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.preferences;

import org.eclipse.babel.editor.preferences.AbstractPrefPage;
import org.eclipse.babel.editor.preferences.MsgEditorPreferences;
import org.eclipse.babel.messages.Messages;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.BackingStoreException;

public class ReportingPrefPage
extends AbstractPrefPage {
    private Combo reportMissingVals;
    private Combo reportDuplVals;
    private Combo reportSimVals;
    private Text reportSimPrecision;
    private Button[] reportSimValsMode = new Button[2];

    protected Control createContents(Composite parent) {
        IPreferenceStore prefs = this.getPreferenceStore();
        Composite field = null;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        new Label(composite, 0).setText(Messages.prefs_perform_intro1);
        new Label(composite, 0).setText(Messages.prefs_perform_intro2);
        new Label(composite, 0).setText(" ");
        field = this.createFieldComposite(composite);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        field.setLayoutData((Object)gridData);
        new Label(field, 0).setText(Messages.prefs_perform_missingVals);
        this.reportMissingVals = new Combo(field, 8);
        this.populateCombo(this.reportMissingVals, prefs.getInt("detectMissingValuesLevel"));
        field = this.createFieldComposite(composite);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        field.setLayoutData((Object)gridData);
        new Label(field, 0).setText(Messages.prefs_perform_duplVals);
        this.reportDuplVals = new Combo(field, 8);
        this.populateCombo(this.reportDuplVals, prefs.getInt("reportDuplicateValuesLevel"));
        field = this.createFieldComposite(composite);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        field.setLayoutData((Object)gridData);
        new Label(field, 0).setText(Messages.prefs_perform_simVals);
        this.reportSimVals = new Combo(field, 8);
        this.populateCombo(this.reportSimVals, prefs.getInt("reportSimilarValuesLevel"));
        this.reportSimVals.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ReportingPrefPage.this.refreshEnabledStatuses();
            }
        });
        Composite simValModeGroup = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 20;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        simValModeGroup.setLayout((Layout)gridLayout);
        this.reportSimValsMode[0] = new Button(simValModeGroup, 16);
        this.reportSimValsMode[0].setSelection(prefs.getBoolean("reportSimilarValuesWordCompare"));
        new Label(simValModeGroup, 0).setText(Messages.prefs_perform_simVals_wordCount);
        this.reportSimValsMode[1] = new Button(simValModeGroup, 16);
        this.reportSimValsMode[1].setSelection(prefs.getBoolean("reportSimilarValuesLevensthein"));
        new Label(simValModeGroup, 0).setText(Messages.prefs_perform_simVals_levensthein);
        field = this.createFieldComposite(composite, 20);
        new Label(field, 0).setText(Messages.prefs_perform_simVals_precision);
        this.reportSimPrecision = new Text(field, 2048);
        this.reportSimPrecision.setText(prefs.getString("reportSimilarValuesPrecision"));
        this.reportSimPrecision.setTextLimit(6);
        this.setWidthInChars((Control)this.reportSimPrecision, 6);
        this.reportSimPrecision.addKeyListener((KeyListener)new AbstractPrefPage.DoubleTextValidatorKeyListener(Messages.prefs_perform_simVals_precision_error, 0.0, 1.0));
        this.refreshEnabledStatuses();
        return composite;
    }

    private void populateCombo(Combo combo, int selectedLevel) {
        combo.add(Messages.prefs_perform_message_ignore);
        combo.add(Messages.prefs_perform_message_info);
        combo.add(Messages.prefs_perform_message_warning);
        combo.add(Messages.prefs_perform_message_error);
        combo.select(selectedLevel);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 131072;
        combo.setLayoutData((Object)gridData);
    }

    public boolean performOk() {
        IEclipsePreferences prefs = MsgEditorPreferences.getEclipsePreferenceStore();
        prefs.putInt("detectMissingValuesLevel", this.reportMissingVals.getSelectionIndex());
        prefs.putInt("reportDuplicateValuesLevel", this.reportDuplVals.getSelectionIndex());
        prefs.putInt("reportSimilarValuesLevel", this.reportSimVals.getSelectionIndex());
        prefs.putBoolean("reportSimilarValuesWordCompare", this.reportSimValsMode[0].getSelection());
        prefs.putBoolean("reportSimilarValuesLevensthein", this.reportSimValsMode[1].getSelection());
        double precision = 0.75;
        try {
            double textPrecision;
            precision = textPrecision = Double.parseDouble(this.reportSimPrecision.getText());
        }
        catch (NumberFormatException numberFormatException) {}
        prefs.putDouble("reportSimilarValuesPrecision", precision);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        this.refreshEnabledStatuses();
        return super.performOk();
    }

    protected void performDefaults() {
        this.reportMissingVals.select(3);
        this.reportDuplVals.select(2);
        this.reportSimVals.select(0);
        this.reportSimValsMode[0].setSelection(true);
        this.reportSimValsMode[1].setSelection(false);
        this.reportSimPrecision.setText(Double.toString(0.75));
        this.refreshEnabledStatuses();
        super.performDefaults();
    }

    void refreshEnabledStatuses() {
        boolean isReportingSimilar = this.reportSimVals.getSelectionIndex() != 0;
        int i = 0;
        while (i < this.reportSimValsMode.length) {
            this.reportSimValsMode[i].setEnabled(isReportingSimilar);
            ++i;
        }
        this.reportSimPrecision.setEnabled(isReportingSimilar);
    }
}

