/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.resource.validator;

import java.util.Locale;
import org.eclipse.babel.core.message.checks.internal.DuplicateValueCheck;
import org.eclipse.babel.core.message.checks.internal.MissingValueCheck;
import org.eclipse.babel.core.message.internal.MessagesBundleGroup;
import org.eclipse.babel.editor.preferences.MsgEditorPreferences;
import org.eclipse.babel.editor.resource.validator.IValidationMarkerStrategy;
import org.eclipse.babel.editor.resource.validator.ValidationFailureEvent;

public class MessagesBundleGroupValidator {
    public static void validate(MessagesBundleGroup messagesBundleGroup, Locale locale, IValidationMarkerStrategy markerStrategy) {
        DuplicateValueCheck duplicateCheck = MsgEditorPreferences.getReportDuplicateValues() ? new DuplicateValueCheck() : null;
        String[] keys = messagesBundleGroup.getMessageKeys();
        int i = 0;
        while (i < keys.length) {
            String key = keys[i];
            if (MsgEditorPreferences.getReportMissingValues() && MissingValueCheck.MISSING_KEY.checkKey(messagesBundleGroup, messagesBundleGroup.getMessage(key, locale))) {
                markerStrategy.markFailed(new ValidationFailureEvent(messagesBundleGroup, locale, key, MissingValueCheck.MISSING_KEY));
            }
            if (!(duplicateCheck == null || MsgEditorPreferences.getReportDuplicateValuesOnlyInRootLocales() && locale != null && locale.toString().length() != 0)) {
                if (duplicateCheck.checkKey(messagesBundleGroup, messagesBundleGroup.getMessage(key, locale))) {
                    markerStrategy.markFailed(new ValidationFailureEvent(messagesBundleGroup, locale, key, duplicateCheck));
                }
                duplicateCheck.reset();
            }
            ++i;
        }
    }
}

