/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.tree.internal;

import java.util.Observable;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.babel.core.message.tree.IKeyTreeNode;
import org.eclipse.babel.core.message.tree.TreeType;
import org.eclipse.babel.core.message.tree.internal.AbstractKeyTreeModel;
import org.eclipse.babel.core.message.tree.internal.IKeyTreeModelListener;
import org.eclipse.babel.core.message.tree.internal.KeyTreeNode;
import org.eclipse.babel.editor.internal.AbstractMessagesEditor;
import org.eclipse.babel.editor.internal.MessagesEditorChangeAdapter;
import org.eclipse.babel.editor.internal.MessagesEditorMarkers;
import org.eclipse.babel.editor.tree.IKeyTreeContributor;
import org.eclipse.babel.editor.tree.actions.AddKeyAction;
import org.eclipse.babel.editor.tree.actions.DeleteKeyAction;
import org.eclipse.babel.editor.tree.actions.RefactorKeyAction;
import org.eclipse.babel.editor.tree.internal.KeyTreeContentProvider;
import org.eclipse.babel.editor.tree.internal.KeyTreeLabelProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;

public class KeyTreeContributor
implements IKeyTreeContributor {
    private static final Logger LOGGER = Logger.getLogger(KeyTreeContributor.class.getName());
    private AbstractMessagesEditor editor;
    private AbstractKeyTreeModel treeModel;
    private TreeType treeType;
    private KeyNameFilter keyFilter;

    public KeyTreeContributor(AbstractMessagesEditor editor) {
        this.editor = editor;
        this.treeModel = new AbstractKeyTreeModel(editor.getBundleGroup());
        this.treeType = TreeType.Tree;
    }

    public void dispose() {
        this.treeModel.dispose();
    }

    public void filterKeyItems(String key) {
        this.keyFilter.setFilterKey(key);
    }

    @Override
    public void contribute(TreeViewer treeViewer) {
        KeyTreeContentProvider contentProvider = new KeyTreeContentProvider(this.treeType);
        treeViewer.setContentProvider((IContentProvider)contentProvider);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)treeViewer);
        treeViewer.setLabelProvider((IBaseLabelProvider)new KeyTreeLabelProvider(this.editor, this.treeModel, contentProvider));
        if (treeViewer.getInput() == null) {
            treeViewer.setUseHashlookup(true);
        }
        OnlyUnsuedAndMissingKey onlyUnusedAndMissingKeysFilter = new OnlyUnsuedAndMissingKey();
        this.keyFilter = new KeyNameFilter();
        ViewerFilter[] filters = new ViewerFilter[]{onlyUnusedAndMissingKeysFilter, this.keyFilter};
        treeViewer.setFilters(filters);
        this.contributeActions(treeViewer);
        this.contributeKeySync(treeViewer);
        this.contributeModelChanges(treeViewer);
        this.contributeDoubleClick(treeViewer);
        this.contributeMarkers(treeViewer);
        treeViewer.setInput((Object)this.treeModel);
        treeViewer.expandAll();
        treeViewer.setColumnProperties(new String[]{"column1"});
        treeViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)treeViewer.getTree())});
    }

    private void contributeMarkers(final TreeViewer treeViewer) {
        this.editor.getMarkers().addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                Display display;
                if (!treeViewer.getTree().isDisposed() && (display = treeViewer.getTree().getDisplay()).equals(Display.getCurrent())) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!treeViewer.getTree().isDisposed()) {
                                treeViewer.refresh();
                            }
                        }
                    });
                }
            }
        });
    }

    private void contributeDoubleClick(final TreeViewer treeViewer) {
        treeViewer.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                IStructuredSelection selection = (IStructuredSelection)treeViewer.getSelection();
                Object element = selection.getFirstElement();
                if (treeViewer.isExpandable(element)) {
                    if (treeViewer.getExpandedState(element)) {
                        treeViewer.collapseToLevel(element, 1);
                    } else {
                        treeViewer.expandToLevel(element, 1);
                    }
                }
            }
        });
    }

    private void contributeModelChanges(final TreeViewer treeViewer) {
        final IKeyTreeModelListener keyTreeListener = new IKeyTreeModelListener(){

            @Override
            public void nodeAdded(KeyTreeNode node) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!KeyTreeContributor.this.editor.getI18NPage().isDisposed() && !treeViewer.getTree().isDisposed()) {
                            treeViewer.refresh(true);
                        }
                    }
                });
            }

            @Override
            public void nodeRemoved(KeyTreeNode node) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!KeyTreeContributor.this.editor.getI18NPage().isDisposed() && !treeViewer.getTree().isDisposed()) {
                            treeViewer.refresh(true);
                        }
                    }
                });
            }
        };
        this.treeModel.addKeyTreeModelListener(keyTreeListener);
        this.editor.addChangeListener(new MessagesEditorChangeAdapter(){

            @Override
            public void keyTreeModelChanged(AbstractKeyTreeModel oldModel, AbstractKeyTreeModel newModel) {
                oldModel.removeKeyTreeModelListener(keyTreeListener);
                newModel.addKeyTreeModelListener(keyTreeListener);
                treeViewer.setInput((Object)newModel);
                treeViewer.refresh();
            }

            @Override
            public void showOnlyUnusedAndMissingChanged(int hideEverythingElse) {
                treeViewer.refresh();
            }
        });
    }

    private void contributeKeySync(final TreeViewer treeViewer) {
        treeViewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)treeViewer.getSelection();
                if (selection != null && selection.getFirstElement() != null) {
                    KeyTreeNode node = (KeyTreeNode)selection.getFirstElement();
                    LOGGER.log(Level.INFO, "viewer key/hash:" + node.getMessageKey() + "/" + node.hashCode());
                    KeyTreeContributor.this.editor.setSelectedKey(node.getMessageKey());
                } else {
                    KeyTreeContributor.this.editor.setSelectedKey(null);
                }
            }
        });
        this.editor.addChangeListener(new MessagesEditorChangeAdapter(){

            @Override
            public void selectedKeyChanged(String oldKey, String newKey) {
                KeyTreeNode node;
                ITreeContentProvider provider = (ITreeContentProvider)treeViewer.getContentProvider();
                if (provider != null && (node = KeyTreeContributor.this.findKeyTreeNode(provider, provider.getElements(null), newKey)) != null) {
                    treeViewer.setSelection((ISelection)new StructuredSelection((Object)node), true);
                    treeViewer.getTree().showSelection();
                }
            }
        });
    }

    private void contributeActions(final TreeViewer treeViewer) {
        Tree tree = treeViewer.getTree();
        MenuManager menuManager = new MenuManager();
        Menu menu = menuManager.createContextMenu((Control)tree);
        AddKeyAction addAction = new AddKeyAction(this.editor, treeViewer);
        menuManager.add((IAction)addAction);
        DeleteKeyAction deleteAction = new DeleteKeyAction(this.editor, treeViewer);
        menuManager.add((IAction)deleteAction);
        RefactorKeyAction refactorAction = new RefactorKeyAction(this.editor, treeViewer);
        menuManager.add((IAction)refactorAction);
        menuManager.update(true);
        menuManager.addMenuListener(new IMenuListener((IAction)refactorAction, (IAction)deleteAction){
            private final /* synthetic */ IAction val$refactorAction;
            private final /* synthetic */ IAction val$deleteAction;
            {
                this.val$refactorAction = iAction;
                this.val$deleteAction = iAction2;
            }

            public void menuAboutToShow(IMenuManager manager) {
                IStructuredSelection selection = (IStructuredSelection)treeViewer.getSelection();
                KeyTreeNode node = (KeyTreeNode)selection.getFirstElement();
                this.val$refactorAction.setEnabled(node != null && node.getChildren().length == 0);
                this.val$deleteAction.setEnabled(node != null);
            }
        });
        tree.setMenu(menu);
        tree.addKeyListener((KeyListener)new KeyAdapter((IAction)deleteAction){
            private final /* synthetic */ IAction val$deleteAction;
            {
                this.val$deleteAction = iAction;
            }

            public void keyReleased(KeyEvent event) {
                if (event.character == '\u007f') {
                    this.val$deleteAction.run();
                }
            }
        });
    }

    private KeyTreeNode findKeyTreeNode(ITreeContentProvider provider, Object[] nodes, String key) {
        int i = 0;
        while (i < nodes.length) {
            KeyTreeNode node = (KeyTreeNode)nodes[i];
            if (node.getMessageKey().equals(key)) {
                return node;
            }
            if ((node = this.findKeyTreeNode(provider, provider.getChildren((Object)node), key)) != null) {
                return node;
            }
            ++i;
        }
        return null;
    }

    @Override
    public IKeyTreeNode getKeyTreeNode(String key) {
        return this.getKeyTreeNode(key, null);
    }

    private IKeyTreeNode getKeyTreeNode(String key, IKeyTreeNode node) {
        if (node == null) {
            IKeyTreeNode[] iKeyTreeNodeArray = this.treeModel.getRootNodes();
            int n = iKeyTreeNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IKeyTreeNode ktn = iKeyTreeNodeArray[n2];
                String id = ktn.getMessageKey();
                if (key.equals(id)) {
                    return ktn;
                }
                this.getKeyTreeNode(key, ktn);
                ++n2;
            }
        } else {
            IKeyTreeNode[] iKeyTreeNodeArray = node.getChildren();
            int n = iKeyTreeNodeArray.length;
            int n3 = 0;
            while (n3 < n) {
                IKeyTreeNode ktn = iKeyTreeNodeArray[n3];
                String id = ktn.getMessageKey();
                if (key.equals(id)) {
                    return ktn;
                }
                this.getKeyTreeNode(key, ktn);
                ++n3;
            }
        }
        return null;
    }

    @Override
    public IKeyTreeNode[] getRootKeyItems() {
        return this.treeModel.getRootNodes();
    }

    private class KeyNameFilter
    extends ViewerFilter {
        private String filterKey = "";

        private KeyNameFilter() {
        }

        public void setFilterKey(String key) {
            this.filterKey = key;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (!(element instanceof KeyTreeNode) || this.filterKey == null || this.filterKey.trim().isEmpty()) {
                return true;
            }
            String key = ((KeyTreeNode)element).getMessageKey();
            return key.toLowerCase().contains(this.filterKey.toLowerCase());
        }
    }

    private class OnlyUnsuedAndMissingKey
    extends ViewerFilter
    implements AbstractKeyTreeModel.IKeyTreeNodeLeafFilter {
        private OnlyUnsuedAndMissingKey() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (KeyTreeContributor.this.editor.isShowOnlyUnusedAndMissingKeys() == 0 || !(element instanceof KeyTreeNode)) {
                return true;
            }
            if (KeyTreeContributor.this.editor.getI18NPage() != null && KeyTreeContributor.this.editor.getI18NPage().isKeyTreeVisible()) {
                return KeyTreeContributor.this.editor.getKeyTreeModel().isBranchFiltered(this, (KeyTreeNode)element);
            }
            return this.isFilteredLeaf((KeyTreeNode)element);
        }

        @Override
        public boolean isFilteredLeaf(IKeyTreeNode node) {
            String key;
            MessagesEditorMarkers markers = KeyTreeContributor.this.editor.getMarkers();
            boolean missingOrUnused = markers.isMissingOrUnusedKey(key = node.getMessageKey());
            if (!missingOrUnused) {
                return false;
            }
            switch (KeyTreeContributor.this.editor.isShowOnlyUnusedAndMissingKeys()) {
                case 1: {
                    return missingOrUnused;
                }
                case 2: {
                    return !markers.isUnusedKey(key, missingOrUnused);
                }
                case 3: {
                    return markers.isUnusedKey(key, missingOrUnused);
                }
            }
            return false;
        }
    }
}

