/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.tree.internal;

import java.util.Collection;
import org.eclipse.babel.core.message.checks.IMessageCheck;
import org.eclipse.babel.core.message.internal.MessagesBundleGroup;
import org.eclipse.babel.core.message.tree.IKeyTreeNode;
import org.eclipse.babel.core.message.tree.internal.AbstractKeyTreeModel;
import org.eclipse.babel.core.message.tree.internal.KeyTreeNode;
import org.eclipse.babel.editor.internal.AbstractMessagesEditor;
import org.eclipse.babel.editor.internal.MessagesEditorMarkers;
import org.eclipse.babel.editor.tree.internal.KeyTreeContentProvider;
import org.eclipse.babel.editor.util.OverlayImageIcon;
import org.eclipse.babel.editor.util.UIUtils;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class KeyTreeLabelProvider
extends ColumnLabelProvider
implements IFontProvider,
IColorProvider {
    private static final int KEY_DEFAULT = 2;
    private static final int KEY_COMMENTED = 4;
    private static final int KEY_VIRTUAL = 8;
    private static final int BADGE_WARNING = 16;
    private static final int BADGE_WARNING_GREY = 32;
    private static ImageRegistry imageRegistry = new ImageRegistry();
    private AbstractMessagesEditor editor;
    private MessagesBundleGroup messagesBundleGroup;
    private KeyTreeContentProvider contentProvider;

    public KeyTreeLabelProvider(AbstractMessagesEditor editor, AbstractKeyTreeModel treeModel, KeyTreeContentProvider contentProvider) {
        this.editor = editor;
        this.messagesBundleGroup = editor.getBundleGroup();
        this.contentProvider = contentProvider;
    }

    public Image getImage(Object element) {
        if (element instanceof KeyTreeNode) {
            KeyTreeNode node = (KeyTreeNode)element;
            Collection<IMessageCheck> c = this.editor.getMarkers().getFailedChecks(node.getMessageKey());
            if (c == null || c.isEmpty()) {
                return UIUtils.getKeyImage();
            }
            if (this.editor.getMarkers().isUnusedKey(node.getMessageKey(), false)) {
                if (this.editor.getMarkers().isMissingKey(node.getMessageKey())) {
                    return UIUtils.getMissingAndUnusedTranslationsImage();
                }
                if (this.editor.getMarkers().isDuplicateValue(node.getMessageKey())) {
                    return UIUtils.getDuplicateEntryAndUnusedTranslationsImage();
                }
                return UIUtils.getUnusedTranslationsImage();
            }
            if (this.editor.getMarkers().isMissingKey(node.getMessageKey())) {
                return UIUtils.getMissingTranslationImage();
            }
            if (this.editor.getMarkers().isDuplicateValue(node.getMessageKey())) {
                return UIUtils.getDuplicateEntryImage();
            }
            Image someWarning = UIUtils.getKeyImage();
            ImageDescriptor warning = ImageDescriptor.createFromImage((Image)UIUtils.getImage("warning.gif"));
            someWarning = new DecorationOverlayIcon(someWarning, warning, 3).createImage();
            return someWarning;
        }
        return UIUtils.getKeyImage();
    }

    public String getText(Object element) {
        KeyTreeNode node = (KeyTreeNode)element;
        switch (this.contentProvider.getTreeType()) {
            case Tree: {
                return node.getName();
            }
            case Flat: {
                return node.getMessageKey();
            }
        }
        return "error";
    }

    public String getToolTipText(Object element) {
        if (element instanceof KeyTreeNode) {
            KeyTreeNode node = (KeyTreeNode)element;
            Collection<IMessageCheck> c = this.editor.getMarkers().getFailedChecks(node.getMessageKey());
            if (c == null || c.isEmpty()) {
                return null;
            }
            boolean isMissingOrUnused = this.editor.getMarkers().isMissingOrUnusedKey(node.getMessageKey());
            if (isMissingOrUnused) {
                if (this.editor.getMarkers().isUnusedKey(node.getMessageKey(), isMissingOrUnused)) {
                    return "This Locale is unused";
                }
                return "This Locale has missing translations";
            }
            if (this.editor.getMarkers().isDuplicateValue(node.getMessageKey())) {
                return "This Locale has a duplicate value";
            }
        }
        return null;
    }

    public void dispose() {
    }

    public Font getFont(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }

    private Image generateImage(int iconFlags) {
        Image image = imageRegistry.get("" + iconFlags);
        if (image == null) {
            image = (iconFlags & 4) != 0 ? this.getRegistryImage("keyCommented.png") : ((iconFlags & 8) != 0 ? this.getRegistryImage("keyVirtual.png") : this.getRegistryImage("keyDefault.png"));
            if ((iconFlags & 0x10) != 0) {
                image = this.overlayImage(image, "warning.gif", 3, iconFlags);
            } else if ((iconFlags & 0x20) != 0) {
                image = this.overlayImage(image, "warningGrey.gif", 3, iconFlags);
            }
        }
        return image;
    }

    private Image overlayImage(Image baseImage, String imageName, int location, int iconFlags) {
        String imageKey = String.valueOf(imageName) + iconFlags;
        Image image = imageRegistry.get(imageKey);
        if (image == null) {
            image = new OverlayImageIcon(baseImage, this.getRegistryImage(imageName), location).createImage();
            imageRegistry.put(imageKey, image);
        }
        return image;
    }

    private Image getRegistryImage(String imageName) {
        Image image = imageRegistry.get(imageName);
        if (image == null) {
            image = UIUtils.getImageDescriptor(imageName).createImage();
            imageRegistry.put(imageName, image);
        }
        return image;
    }

    private boolean isOneChildrenMarked(IKeyTreeNode parentNode) {
        MessagesEditorMarkers markers = this.editor.getMarkers();
        IKeyTreeNode[] childNodes = this.editor.getKeyTreeModel().getChildren(parentNode);
        int i = 0;
        while (i < childNodes.length) {
            IKeyTreeNode node = childNodes[i];
            if (markers.isMarked(node.getMessageKey())) {
                return true;
            }
            if (this.isOneChildrenMarked(node)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

