/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.widgets.suggestion;

import org.eclipse.babel.editor.widgets.NullableText;
import org.eclipse.babel.editor.widgets.suggestion.SuggestionBubble;
import org.eclipse.babel.editor.widgets.suggestion.exception.SuggestionErrors;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PartialTranslationDialog {
    private PopupDialog dialog;
    private Shell shell;
    private SuggestionBubble parent;
    private Composite composite;
    private Text textField;
    private final String FOOT_NOTE_1 = "Click for focus";
    private final String FOOT_NOTE_2 = "Mark the text, which will be used as translation, then click on 'Apply' button";
    private String infoText;
    private String text;
    private int orientation;
    private boolean win;
    private static int SHELL_STYLE;

    public PartialTranslationDialog(Shell shell, SuggestionBubble parent) {
        this.parent = parent;
        this.shell = shell;
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            SHELL_STYLE = 4;
            this.win = true;
        } else {
            SHELL_STYLE = 540676;
            this.win = false;
        }
    }

    private void createDialog(final int shellStyle) {
        boolean takeFocusOnOpen = false;
        boolean persistSize = false;
        boolean persistLocation = false;
        boolean showDialogMenu = false;
        boolean showPersistActions = false;
        String titleText = null;
        this.dialog = new PopupDialog(this.shell, shellStyle, takeFocusOnOpen, persistSize, persistLocation, showDialogMenu, showPersistActions, titleText, this.infoText){

            protected Control createDialogArea(Composite parent) {
                PartialTranslationDialog.this.composite = (Composite)super.createDialogArea(parent);
                PartialTranslationDialog.this.composite.setLayout((Layout)new GridLayout(2, false));
                final Button button = new Button(PartialTranslationDialog.this.composite, 8);
                button.setText("Apply");
                button.setEnabled(false);
                button.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        NullableText nText = (NullableText)PartialTranslationDialog.this.parent.getTextField().getParent();
                        nText.setText(String.valueOf(PartialTranslationDialog.this.parent.getTextField().getText()) + PartialTranslationDialog.this.textField.getSelectionText(), true);
                        PartialTranslationDialog.this.parent.dispose();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                Label label = new Label(PartialTranslationDialog.this.composite, 0);
                label.setText("Selected translation");
                FontData fontData = label.getFont().getFontData()[0];
                Font font = new Font((Device)label.getDisplay(), new FontData(fontData.getName(), fontData.getHeight(), 1));
                label.setFont(font);
                new Label(PartialTranslationDialog.this.composite, 0);
                PartialTranslationDialog.this.textField = new Text(PartialTranslationDialog.this.composite, 0x24A | PartialTranslationDialog.this.orientation);
                PartialTranslationDialog.this.textField.setText(PartialTranslationDialog.this.text);
                PartialTranslationDialog.this.textField.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
                PartialTranslationDialog.this.textField.addListener(4, new Listener(){

                    public void handleEvent(Event event) {
                        Text text = (Text)event.widget;
                        String selection = text.getSelectionText();
                        if (selection.length() > 0 && !SuggestionErrors.contains(PartialTranslationDialog.this.textField.getText())) {
                            button.setEnabled(true);
                        } else {
                            button.setEnabled(false);
                        }
                    }
                });
                Listener scrollBarListener = new Listener(){

                    public void handleEvent(Event event) {
                        Text t = (Text)event.widget;
                        Rectangle r1 = t.getClientArea();
                        Rectangle r2 = t.computeTrim(r1.x, r1.y, r1.width, r1.height);
                        Point p = t.computeSize(((PartialTranslationDialog)(this).PartialTranslationDialog.this).composite.getSize().x, -1, true);
                        t.getVerticalBar().setVisible(r2.height <= p.y);
                    }
                };
                PartialTranslationDialog.this.textField.addListener(11, scrollBarListener);
                return PartialTranslationDialog.this.composite;
            }

            protected void adjustBounds() {
                super.adjustBounds();
                Point start = PartialTranslationDialog.this.parent.getCurrentLocation();
                Point size = PartialTranslationDialog.this.parent.getSize();
                int x = start.x + size.x;
                int y = start.y;
                int screenWidth = Display.getCurrent().getBounds().width;
                if (screenWidth - x <= 200) {
                    x = start.x - 450;
                }
                this.getShell().setLocation(x, y);
                if (screenWidth - x < 450) {
                    this.getShell().setSize(screenWidth - x, 200);
                } else {
                    this.getShell().setSize(450, 200);
                }
            }

            protected void configureShell(Shell shell) {
                super.configureShell(shell);
                if (PartialTranslationDialog.this.win) {
                    shell.addFocusListener(new FocusListener(){

                        public void focusGained(FocusEvent e) {
                            if (shellStyle == 16 || PartialTranslationDialog.this.dialog == null) {
                                return;
                            }
                            PartialTranslationDialog.this.dialog.close();
                            PartialTranslationDialog.this.infoText = "Mark the text, which will be used as translation, then click on 'Apply' button";
                            PartialTranslationDialog.this.createDialog(16);
                            PartialTranslationDialog.this.dialog.open();
                            PartialTranslationDialog.this.dialog.getShell().setFocus();
                        }

                        public void focusLost(FocusEvent e) {
                        }
                    });
                }
            }
        };
    }

    public Point getLocation() {
        return this.dialog.getShell().toDisplay(1, 1);
    }

    public Point getSize() {
        return this.dialog.getShell().getSize();
    }

    public void openDialog(String text, int orientation) {
        if (SuggestionErrors.contains(text)) {
            return;
        }
        this.text = text;
        this.orientation = orientation;
        if (this.dialog != null && this.dialog.getShell() != null) {
            this.textField.setText(text);
        } else {
            this.infoText = "Click for focus";
            this.createDialog(SHELL_STYLE);
            this.dialog.open();
        }
    }

    public void dispose() {
        if (this.dialog != null) {
            this.dialog.close();
        }
    }

    public boolean isCursorInsideDialog() {
        if (this.dialog == null || this.dialog.getShell() == null || this.dialog.getShell().isDisposed()) {
            return false;
        }
        Display d = Display.getCurrent();
        if (d == null) {
            d = Display.getDefault();
        }
        Point start = this.dialog.getShell().getLocation();
        Point size = this.dialog.getShell().getSize();
        Point end = new Point(size.x + start.x, size.y + start.y);
        return d.getCursorLocation().x <= end.x && d.getCursorLocation().x >= start.x && d.getCursorLocation().y <= end.y && d.getCursorLocation().y >= start.y;
    }

    public boolean isVisible() {
        return this.dialog != null && this.dialog.getShell() != null;
    }
}

