/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.widgets.suggestion;

import java.awt.Color;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.eclipse.babel.editor.widgets.NullableText;
import org.eclipse.babel.editor.widgets.suggestion.DoubleClickListener;
import org.eclipse.babel.editor.widgets.suggestion.PartialTranslationDialog;
import org.eclipse.babel.editor.widgets.suggestion.exception.SuggestionErrors;
import org.eclipse.babel.editor.widgets.suggestion.filter.SuggestionFilter;
import org.eclipse.babel.editor.widgets.suggestion.model.Suggestion;
import org.eclipse.babel.editor.widgets.suggestion.provider.ISuggestionProvider;
import org.eclipse.babel.editor.widgets.suggestion.provider.ISuggestionProviderListener;
import org.eclipse.babel.editor.widgets.suggestion.provider.SuggestionProviderUtils;
import org.eclipse.babel.swt.ResourceManager;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;

public class SuggestionBubble
implements ISuggestionProviderListener {
    private PopupDialog dialog;
    private TableViewer tableViewer;
    private Text text;
    private Shell shell;
    private Point caret;
    private SuggestionFilter suggestionFilter;
    private Composite composite;
    private ScrolledComposite scrollComposite;
    private Label noSug;
    private PartialTranslationDialog partialTranslationDialog;
    private ArrayList<Suggestion> suggestions;
    private String targetLanguage;
    private String oldDefaultText = "";
    private static String defaultText;
    private static boolean win;
    private String SRC_LANG = "EN";
    private static int SHELL_STYLE;
    private final String CONTENT_ASSIST;
    private final Level LOG_LEVEL = Level.INFO;
    private static final Logger LOGGER;

    static {
        LOGGER = Logger.getLogger(SuggestionBubble.class.getName());
    }

    public SuggestionBubble(Text parent, String targetLanguage) {
        this.shell = parent.getShell();
        this.text = parent;
        this.targetLanguage = targetLanguage;
        this.suggestionFilter = new SuggestionFilter();
        this.suggestions = new ArrayList();
        String srcLang = System.getProperty("tapiji.translator.default.language");
        if (srcLang != null) {
            this.SRC_LANG = srcLang.substring(0, 2).toUpperCase();
        }
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            SHELL_STYLE = 16;
            win = true;
        } else {
            SHELL_STYLE = 540676;
            win = false;
        }
        SuggestionProviderUtils.addSuggestionProviderUpdateListener(this);
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        this.CONTENT_ASSIST = bindingService.getBestActiveBindingFormattedFor("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.init();
    }

    public static String getDefaultText() {
        return defaultText;
    }

    public static void setDefaultText(String defaultText) {
        SuggestionBubble.defaultText = defaultText;
    }

    private void updateSuggestions() {
        if (!this.oldDefaultText.equals(defaultText)) {
            ArrayList<ISuggestionProvider> providers = SuggestionProviderUtils.getSuggetionProviders();
            LOGGER.log(this.LOG_LEVEL, "size of suggestions: " + this.suggestions.size() + ", size of providers: " + providers.size());
            this.suggestions.clear();
            final Display d = Display.getCurrent();
            for (final ISuggestionProvider provider : providers) {
                Thread fetch = new Thread(){
                    Composite loadingCircle;

                    @Override
                    public void run() {
                        if (!d.isDisposed()) {
                            d.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!SuggestionBubble.this.composite.isDisposed()) {
                                        loadingCircle = SuggestionBubble.this.createLoadingCircle();
                                    }
                                }
                            });
                        }
                        SuggestionBubble.this.suggestions.add(provider.getSuggestion(defaultText, SuggestionBubble.this.targetLanguage));
                        if (!d.isDisposed()) {
                            d.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!SuggestionBubble.this.composite.isDisposed()) {
                                        loadingCircle.dispose();
                                        SuggestionBubble.this.tableViewer.setInput((Object)SuggestionBubble.this.suggestions.toArray());
                                        SuggestionBubble.this.pack();
                                        SuggestionBubble.this.composite.layout();
                                    }
                                }
                            });
                        }
                    }
                };
                fetch.start();
            }
            this.oldDefaultText = defaultText;
        } else {
            this.tableViewer.setInput((Object)this.suggestions.toArray());
            this.pack();
            this.composite.layout();
        }
    }

    public boolean isCreated() {
        return this.dialog != null && this.dialog.getShell() != null;
    }

    public void dispose() {
        if (this.dialog != null) {
            this.dialog.close();
        }
    }

    private void init() {
        if (!win) {
            this.shell.getDisplay().addFilter(3, new Listener(){

                public void handleEvent(Event event) {
                    if (SuggestionBubble.this.isCursorInsideTextField() && SuggestionBubble.this.text.getText().length() == 0 && !SuggestionBubble.this.isCreated() && SuggestionBubble.this.text.isFocusControl()) {
                        SuggestionBubble.this.suggestionFilter.setSearchText("");
                        SuggestionBubble.this.createDialog();
                        SuggestionBubble.this.tableViewer.refresh();
                    } else if (SuggestionBubble.this.partialTranslationDialog != null) {
                        if (!SuggestionBubble.this.partialTranslationDialog.isCursorInsideDialog() && !SuggestionBubble.this.isCursorInsideDialog()) {
                            SuggestionBubble.this.dispose();
                        }
                    } else if (!SuggestionBubble.this.isCursorInsideDialog()) {
                        SuggestionBubble.this.dispose();
                    }
                }
            });
        }
        this.shell.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                if (SuggestionBubble.this.dialog != null && SuggestionBubble.this.dialog.getShell() != null) {
                    SuggestionBubble.this.dialog.close();
                }
            }
        });
        this.shell.addListener(10, new Listener(){

            public void handleEvent(Event e) {
                if (SuggestionBubble.this.dialog != null && SuggestionBubble.this.dialog.getShell() != null) {
                    SuggestionBubble.this.dialog.close();
                }
            }
        });
        ScrolledComposite scrolledComposite = (ScrolledComposite)this.text.getParent().getParent().getParent().getParent();
        scrolledComposite.getVerticalBar().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (SuggestionBubble.this.dialog != null && SuggestionBubble.this.dialog.getShell() != null) {
                    SuggestionBubble.this.dialog.close();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SuggestionBubble.this.recalculatePosition();
                if (SuggestionBubble.this.dialog != null && SuggestionBubble.this.dialog.getShell() != null && !SuggestionBubble.this.tableViewer.getControl().isDisposed()) {
                    SuggestionBubble.this.suggestionFilter.setSearchText(SuggestionBubble.this.text.getText().trim());
                    SuggestionBubble.this.tableViewer.refresh();
                    if (SuggestionBubble.this.tableViewer.getTable().getItemCount() == 0) {
                        if (SuggestionBubble.this.noSug == null || SuggestionBubble.this.noSug.isDisposed()) {
                            SuggestionBubble.this.noSug = new Label(SuggestionBubble.this.composite, 0);
                            SuggestionBubble.this.noSug.setText("No suggestions available");
                            SuggestionBubble.this.noSug.moveAbove(SuggestionBubble.this.tableViewer.getControl());
                            SuggestionBubble.this.noSug.setBackground(ResourceManager.getColor(255, 255, 225));
                            SuggestionBubble.this.composite.layout();
                        }
                    } else if (SuggestionBubble.this.noSug != null && !SuggestionBubble.this.noSug.isDisposed()) {
                        SuggestionBubble.this.tableViewer.getTable().setSelection(0);
                        SuggestionBubble.this.noSug.dispose();
                        SuggestionBubble.this.composite.layout();
                    }
                    SuggestionBubble.this.suggestionFilter.setSearchText("");
                }
            }
        });
        this.text.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                int accelerator;
                KeyStroke keyStroke;
                KeySequence sequence;
                if ((e.keyCode == 13 || e.keyCode == 10) && SuggestionBubble.this.dialog != null && SuggestionBubble.this.dialog.getShell() != null && SuggestionBubble.this.tableViewer.getTable().getSelectionIndex() != -1) {
                    e.doit = false;
                }
                if ((sequence = KeySequence.getInstance((KeyStroke)(keyStroke = SWTKeySupport.convertAcceleratorToKeyStroke((int)(accelerator = SWTKeySupport.convertEventToUnmodifiedAccelerator((KeyEvent)e)))))).format().equals(SuggestionBubble.this.CONTENT_ASSIST)) {
                    if (SuggestionBubble.this.isCreated()) {
                        if (SuggestionBubble.this.noSug != null && !SuggestionBubble.this.noSug.isDisposed()) {
                            SuggestionBubble.this.noSug.dispose();
                            SuggestionBubble.this.composite.layout();
                        }
                        SuggestionBubble.this.suggestionFilter.setSearchText("");
                        SuggestionBubble.this.tableViewer.refresh();
                        SuggestionBubble.this.tableViewer.getTable().setSelection(0);
                    } else {
                        SuggestionBubble.this.createDialog();
                        SuggestionBubble.this.suggestionFilter.setSearchText(SuggestionBubble.this.text.getText().trim());
                        SuggestionBubble.this.tableViewer.refresh();
                    }
                    e.doit = false;
                }
            }

            public void keyReleased(KeyEvent e) {
                if (SuggestionBubble.this.dialog == null || SuggestionBubble.this.dialog.getShell() == null) {
                    return;
                }
                if (e.keyCode == 27) {
                    SuggestionBubble.this.dialog.close();
                    return;
                }
                int currentSelectionIndex = SuggestionBubble.this.tableViewer.getTable().getSelectionIndex();
                if (e.keyCode == 0x1000002) {
                    if (currentSelectionIndex >= SuggestionBubble.this.tableViewer.getTable().getItemCount() - 1) {
                        SuggestionBubble.this.tableViewer.getTable().setSelection(0);
                    } else {
                        SuggestionBubble.this.tableViewer.getTable().setSelection(currentSelectionIndex + 1);
                    }
                }
                if (e.keyCode == 0x1000001) {
                    if (currentSelectionIndex <= 0) {
                        SuggestionBubble.this.tableViewer.getTable().setSelection(SuggestionBubble.this.tableViewer.getTable().getItemCount() - 1);
                    } else {
                        SuggestionBubble.this.tableViewer.getTable().setSelection(currentSelectionIndex - 1);
                    }
                }
                if (e.keyCode == 13 || e.keyCode == 10) {
                    SuggestionBubble.this.applySuggestion(SuggestionBubble.this.text);
                }
            }
        });
        this.text.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (win && !SuggestionBubble.this.isCreated() && SuggestionBubble.this.text.getText().length() == 0) {
                    SuggestionBubble.this.suggestionFilter.setSearchText("");
                    SuggestionBubble.this.createDialog();
                    SuggestionBubble.this.tableViewer.refresh();
                }
            }

            public void focusLost(FocusEvent e) {
                if (win && SuggestionBubble.this.dialog != null && !SuggestionBubble.this.isCursorInsideDialog()) {
                    SuggestionBubble.this.dialog.close();
                }
            }
        });
        if (win) {
            this.text.addMouseListener(new MouseListener(){

                public void mouseDoubleClick(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseUp(MouseEvent e) {
                    if (SuggestionBubble.this.caret != null) {
                        if (SuggestionBubble.this.dialog != null && !SuggestionBubble.this.caret.equals((Object)SuggestionBubble.this.text.getCaretLocation())) {
                            SuggestionBubble.this.dialog.close();
                            SuggestionBubble.this.caret = SuggestionBubble.this.text.getCaretLocation();
                        }
                    } else {
                        SuggestionBubble.this.caret = SuggestionBubble.this.text.getCaretLocation();
                    }
                    if (SuggestionBubble.this.partialTranslationDialog != null && !SuggestionBubble.this.partialTranslationDialog.isCursorInsideDialog()) {
                        SuggestionBubble.this.partialTranslationDialog.dispose();
                    }
                }
            });
        }
    }

    private void createDialog() {
        boolean takeFocusOnOpen = false;
        boolean persistSize = false;
        boolean persistLocation = false;
        boolean showDialogMenu = false;
        boolean showPersistActions = false;
        String titleText = "Suggestions (" + this.SRC_LANG + " > " + this.targetLanguage.toUpperCase() + ")";
        String infoText = "Ctrl+Space to display all suggestions";
        this.dialog = new PopupDialog(this.shell, SHELL_STYLE, takeFocusOnOpen, persistSize, persistLocation, showDialogMenu, showPersistActions, titleText, infoText){

            protected Control createDialogArea(Composite parent) {
                SuggestionBubble.this.scrollComposite = new ScrolledComposite((Composite)super.createDialogArea(parent), 768);
                SuggestionBubble.this.scrollComposite.setLayoutData((Object)new GridData(1808));
                SuggestionBubble.this.scrollComposite.setExpandVertical(true);
                SuggestionBubble.this.scrollComposite.setExpandHorizontal(true);
                GridLayout gl = new GridLayout(1, true);
                gl.verticalSpacing = 0;
                SuggestionBubble.this.composite = new Composite((Composite)SuggestionBubble.this.scrollComposite, 0);
                SuggestionBubble.this.composite.setLayout((Layout)gl);
                SuggestionBubble.this.scrollComposite.setContent((Control)SuggestionBubble.this.composite);
                SuggestionBubble.this.tableViewer = new TableViewer(SuggestionBubble.this.composite, 16);
                SuggestionBubble.this.tableViewer.getTable().setLayoutData((Object)new GridData(4, 128, true, false));
                SuggestionBubble.this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
                SuggestionBubble.this.tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

                    public Image getColumnImage(Object arg0, int arg1) {
                        Suggestion s = (Suggestion)arg0;
                        return s.getIcon();
                    }

                    public String getColumnText(Object element, int index) {
                        return ((Suggestion)element).getText();
                    }

                    public void addListener(ILabelProviderListener listener) {
                    }

                    public void dispose() {
                    }

                    public boolean isLabelProperty(Object arg0, String arg1) {
                        return true;
                    }

                    public void removeListener(ILabelProviderListener arg0) {
                    }
                });
                SuggestionBubble.this.tableViewer.addFilter((ViewerFilter)SuggestionBubble.this.suggestionFilter);
                SuggestionBubble.this.tableViewer.addDoubleClickListener((IDoubleClickListener)new DoubleClickListener(){

                    public void doubleClick(DoubleClickEvent event) {
                        SuggestionBubble.this.applySuggestion(SuggestionBubble.this.text);
                    }
                });
                SuggestionBubble.this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        if (SuggestionBubble.this.tableViewer.getTable().getSelection().length > 0) {
                            SuggestionBubble.this.partialTranslationDialog.openDialog(SuggestionBubble.this.tableViewer.getTable().getSelection()[0].getText(), SuggestionBubble.this.text.getOrientation());
                        }
                    }
                });
                SuggestionBubble.this.tableViewer.getTable().setSelection(0);
                return SuggestionBubble.this.scrollComposite;
            }

            protected void adjustBounds() {
                super.adjustBounds();
                Point point = SuggestionBubble.this.text.getCaretLocation();
                this.getShell().setLocation(((SuggestionBubble)SuggestionBubble.this).text.toDisplay((int)1, (int)1).x + point.x + 5, ((SuggestionBubble)SuggestionBubble.this).text.toDisplay((int)1, (int)1).y + point.y + 20);
                this.getShell().setSize(450, 200);
            }
        };
        this.dialog.open();
        this.partialTranslationDialog = new PartialTranslationDialog(this.dialog.getShell(), this);
        this.dialog.getShell().addListener(11, new Listener(){

            public void handleEvent(Event e) {
                SuggestionBubble.this.partialTranslationDialog.dispose();
            }
        });
        this.updateSuggestions();
    }

    private void pack() {
        Point temp = new Point(0, 0);
        Point max = new Point(0, 0);
        TableItem[] tableItemArray = this.tableViewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            temp.x = item.getBounds().width;
            temp.y = item.getBounds().height;
            if (temp.x > max.x) {
                max.x = temp.x;
            }
            max.y += temp.y;
            ++n2;
        }
        this.scrollComposite.setMinSize(max);
    }

    private boolean isCursorInsideTextField() {
        if (this.text.isDisposed()) {
            return false;
        }
        Display d = Display.getCurrent();
        if (d == null) {
            d = Display.getDefault();
        }
        Point start = this.text.getLocation();
        start = this.text.toDisplay(start.x, start.y);
        Point size = this.text.getSize();
        Point end = new Point(size.x + start.x, size.y + start.y);
        return d.getCursorLocation().x <= end.x && d.getCursorLocation().x >= start.x && d.getCursorLocation().y <= end.y && d.getCursorLocation().y >= start.y;
    }

    private Composite createLoadingCircle() {
        Composite loadingCircle = new Composite(this.composite, 0x1040000);
        Frame frame = SWT_AWT.new_Frame((Composite)loadingCircle);
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/icons/ajax-loader.gif"));
        JLabel label = new JLabel(imageIcon);
        frame.add(label);
        frame.setBackground(new Color(255, 255, 225));
        GridData gd = new GridData(1, 128, false, false);
        gd.heightHint = 16;
        gd.widthHint = 16;
        loadingCircle.setLayoutData((Object)gd);
        return loadingCircle;
    }

    public Text getTextField() {
        return this.text;
    }

    public String getTargetLanguage() {
        return this.targetLanguage;
    }

    private void recalculatePosition() {
        this.caret = this.text.getCaretLocation();
        if (this.dialog != null && this.dialog.getShell() != null) {
            int oldCaretX = this.getCurrentLocation().x - this.text.toDisplay((int)1, (int)1).x - 5;
            int oldCaretY = this.getCurrentLocation().y - this.text.toDisplay((int)1, (int)1).y - 20;
            int newCaretX = this.caret.x;
            int newCaretY = this.caret.y;
            this.setLocation(this.getCurrentLocation().x + (newCaretX - oldCaretX), this.getCurrentLocation().y + (newCaretY - oldCaretY));
        }
    }

    public Point getCurrentLocation() {
        if (this.dialog != null && this.dialog.getShell() != null) {
            return this.dialog.getShell().getLocation();
        }
        return new Point(0, 0);
    }

    public Point getSize() {
        return this.dialog.getShell().getSize();
    }

    private void setLocation(int x, int y) {
        if (this.dialog != null && this.dialog.getShell() != null) {
            this.dialog.getShell().setLocation(new Point(x, y));
        }
    }

    private void applySuggestion(Text text) {
        if (this.tableViewer.getTable().getSelectionIndex() == -1) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        Suggestion suggestion = (Suggestion)selection.getFirstElement();
        String s = suggestion.getText();
        if (s.lastIndexOf("(") != -1) {
            s = s.substring(0, s.lastIndexOf("(") - 1);
        }
        if (SuggestionErrors.contains(s)) {
            return;
        }
        ((NullableText)text.getParent()).setText(s, true);
        this.dialog.close();
    }

    private boolean isCursorInsideDialog() {
        if (this.dialog == null || this.dialog.getShell() == null) {
            return false;
        }
        Display d = Display.getCurrent();
        if (d == null) {
            d = Display.getDefault();
        }
        Point start = this.dialog.getShell().getLocation();
        Point size = this.dialog.getShell().getSize();
        Point end = new Point(size.x + start.x, size.y + start.y);
        return d.getCursorLocation().x <= end.x && d.getCursorLocation().x >= start.x && d.getCursorLocation().y <= end.y && d.getCursorLocation().y >= start.y;
    }

    @Override
    public void suggestionProviderUpdated(ISuggestionProvider provider) {
        LOGGER.log(this.LOG_LEVEL, "provider :" + provider.getClass().getSimpleName() + ", size of suggestions: " + this.suggestions.size());
        int i = 0;
        while (i < this.suggestions.size()) {
            Suggestion sug = this.suggestions.get(i);
            if (sug.getProvider().equals(provider)) {
                this.suggestions.set(i, provider.getSuggestion(defaultText, this.targetLanguage));
            }
            ++i;
        }
        if (this.tableViewer != null && !this.tableViewer.getTable().isDisposed()) {
            this.tableViewer.setInput(this.suggestions);
        }
    }
}

