/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.widgets.suggestion.provider;

import java.util.ArrayList;
import org.eclipse.babel.editor.widgets.suggestion.exception.InvalidConfigurationSetting;
import org.eclipse.babel.editor.widgets.suggestion.provider.ISuggestionProvider;
import org.eclipse.babel.editor.widgets.suggestion.provider.ISuggestionProviderConfigurationSetting;
import org.eclipse.babel.editor.widgets.suggestion.provider.ISuggestionProviderListener;

public class SuggestionProviderUtils {
    private static ArrayList<ISuggestionProvider> providers = new ArrayList();
    private static ArrayList<ISuggestionProviderListener> listeners = new ArrayList();

    public static void addSuggestionProvider(ISuggestionProvider provider) {
        if (!providers.contains(provider)) {
            providers.add(provider);
        }
    }

    public static void removeSuggestionProvider(ISuggestionProvider provider) {
        providers.remove(provider);
    }

    public static ArrayList<ISuggestionProvider> getSuggetionProviders() {
        return providers;
    }

    public static void addSuggestionProviderUpdateListener(ISuggestionProviderListener listener) {
        listeners.add(listener);
    }

    public static void fireSuggestionProviderUpdated(ISuggestionProvider provider) {
        for (ISuggestionProviderListener listener : listeners) {
            listener.suggestionProviderUpdated(provider);
        }
    }

    public static void updateConfigurationSetting(String configurationId, ISuggestionProviderConfigurationSetting setting) throws InvalidConfigurationSetting {
        for (ISuggestionProvider provider : providers) {
            if (!provider.getAllConfigurationSettings().containsKey(configurationId)) continue;
            provider.updateConfigurationSetting(configurationId, setting);
            SuggestionProviderUtils.fireSuggestionProviderUpdated(provider);
        }
    }
}

