/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.nls.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.Locale;
import org.eclipse.babel.core.message.internal.Message;
import org.eclipse.babel.core.message.internal.MessagesBundle;
import org.eclipse.babel.core.message.resource.internal.PropertiesIFileResource;
import org.eclipse.babel.core.message.resource.ser.PropertiesDeserializer;
import org.eclipse.babel.core.message.resource.ser.PropertiesSerializer;
import org.eclipse.babel.editor.plugin.MessagesEditorPlugin;
import org.eclipse.babel.editor.preferences.MsgEditorPreferences;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.pde.nls.internal.ui.dialogs.EditMultiLineEntryDialog;
import org.eclipse.pde.nls.internal.ui.model.ResourceBundle;
import org.eclipse.pde.nls.internal.ui.model.ResourceBundleKey;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditResourceBundleEntriesDialog
extends Dialog {
    private ResourceBundleKey resourceBundleKey;
    protected ArrayList<LocaleField> fields = new ArrayList();
    private final Locale[] locales;
    private Color errorColor;

    public EditResourceBundleEntriesDialog(Shell parentShell, Locale[] locales) {
        super(parentShell);
        this.locales = locales;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public void setResourceBundleKey(ResourceBundleKey resourceBundleKey) {
        this.resourceBundleKey = resourceBundleKey;
    }

    public int open() {
        if (this.resourceBundleKey == null) {
            throw new RuntimeException("Resource bundle key not set.");
        }
        return super.open();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Edit Resource Bundle Entries");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = (GridLayout)composite.getLayout();
        gridLayout.numColumns = 3;
        Label keyLabel = new Label(composite, 0);
        keyLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        keyLabel.setText("&Key:");
        int style = 18444;
        Text keyText = new Text(composite, style);
        keyText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        keyText.setText(this.resourceBundleKey.getName());
        new Label(composite, 0);
        Locale[] localeArray = this.locales;
        int n = this.locales.length;
        int n2 = 0;
        while (n2 < n) {
            Locale locale = localeArray[n2];
            if (locale.getLanguage().equals("")) {
                this.fields.add(this.createLocaleField(composite, locale, "&Default Bundle:"));
            } else {
                this.fields.add(this.createLocaleField(composite, locale, "&" + locale.getDisplayName() + ":"));
            }
            ++n2;
        }
        if (this.fields.size() > 0) {
            int i = 0;
            while (i < this.fields.size()) {
                if (this.fields.get((int)i).text.getEditable()) {
                    this.fields.get((int)i).text.setFocus();
                    break;
                }
                ++i;
            }
        }
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)GridDataFactory.fillDefaults().span(3, 1).create());
        label.setText("Note: The following escape sequences are allowed: \\r, \\n, \\t, \\\\");
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditResourceBundleEntriesDialog.this.validate();
            }
        };
        for (LocaleField field : this.fields) {
            field.text.addModifyListener(modifyListener);
        }
        this.errorColor = new Color((Device)Display.getCurrent(), 255, 127, 127);
        return composite;
    }

    private LocaleField createLocaleField(Composite parent, Locale locale, String localeLabel) {
        ResourceBundle bundle = this.resourceBundleKey.getFamily().getBundle(locale);
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        label.setText(localeLabel);
        boolean readOnly = bundle == null || bundle.isReadOnly();
        int style = 0x4804 | (readOnly ? 8 : 0);
        Text text = new Text(parent, style);
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        String value = null;
        if (bundle != null) {
            try {
                value = bundle.getString(this.resourceBundleKey.getName());
            }
            catch (CoreException e) {
                MessagesEditorPlugin.log(e);
            }
            if (value == null) {
                value = readOnly ? "(Key does not exist)" : "";
            }
            text.setText(EditResourceBundleEntriesDialog.escape(value));
        } else {
            text.setText("(Resource bundle not found)");
        }
        Button button = new Button(parent, 8);
        button.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        button.setText("...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (LocaleField field : EditResourceBundleEntriesDialog.this.fields) {
                    EditMultiLineEntryDialog dialog;
                    if (e.widget != field.button || (dialog = new EditMultiLineEntryDialog(EditResourceBundleEntriesDialog.this.getShell(), EditResourceBundleEntriesDialog.unescape(field.text.getText()), field.isReadOnly)).open() != 0) continue;
                    field.text.setText(EditResourceBundleEntriesDialog.escape(dialog.getValue()));
                }
            }
        });
        LocaleField field = new LocaleField();
        field.bundle = bundle;
        field.label = label;
        field.text = text;
        field.locale = locale;
        field.oldValue = value;
        field.isReadOnly = readOnly;
        field.button = button;
        return field;
    }

    protected void okPressed() {
        for (LocaleField field : this.fields) {
            boolean hasChanged;
            if (field.isReadOnly) continue;
            String key = this.resourceBundleKey.getName();
            String value = EditResourceBundleEntriesDialog.unescape(field.text.getText());
            boolean bl = hasChanged = field.oldValue == null && !value.equals("") || field.oldValue != null && !field.oldValue.equals(value);
            if (!hasChanged) continue;
            try {
                Object resource = field.bundle.getUnderlyingResource();
                if (!(resource instanceof IFile)) {
                    throw new RuntimeException("Not yet implemented.");
                }
                PropertiesIFileResource messagesResource = new PropertiesIFileResource(field.locale, new PropertiesSerializer(MsgEditorPreferences.getSerializerConfig()), new PropertiesDeserializer(MsgEditorPreferences.getDeserializerConfig()), (IFile)resource, MessagesEditorPlugin.getDefault());
                MessagesBundle bundle = new MessagesBundle(messagesResource);
                Message message = new Message(key, field.locale);
                message.setText(value);
                bundle.addMessage(message);
                field.bundle.put(key, value);
            }
            catch (Exception e) {
                this.openError("Value could not be saved: " + value, e);
                return;
            }
        }
        super.okPressed();
        this.errorColor.dispose();
    }

    protected int getDialogBoundsStrategy() {
        return 3;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        String sectionName;
        IDialogSettings settings = MessagesEditorPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(sectionName = "EditResourceBundleEntriesDialog");
        if (section == null) {
            section = settings.addNewSection(sectionName);
        }
        return section;
    }

    protected Point getInitialSize() {
        Point initialSize = super.getInitialSize();
        Point size = this.getShell().computeSize(-1, -1, true);
        if (initialSize.y < size.y) {
            initialSize.y = size.y;
        }
        return initialSize;
    }

    protected void validate() {
        boolean isValid = true;
        for (LocaleField field : this.fields) {
            try {
                EditResourceBundleEntriesDialog.unescape(field.text.getText());
                field.text.setBackground(null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                field.text.setBackground(this.errorColor);
                isValid = false;
            }
        }
        Button okButton = this.getButton(0);
        okButton.setEnabled(isValid);
    }

    private void openError(String message, Exception e) {
        IStatus status;
        if (e instanceof CoreException) {
            CoreException coreException = (CoreException)((Object)e);
            status = coreException.getStatus();
        } else {
            status = new Status(4, "<dummy>", e.getMessage(), (Throwable)e);
        }
        e.printStackTrace();
        ErrorDialog.openError((Shell)this.getParentShell(), (String)"Error", (String)message, (IStatus)status);
    }

    public static String escape(String str) {
        StringBuilder builder = new StringBuilder(str.length() + 10);
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            switch (c) {
                case '\r': {
                    builder.append("\\r");
                    break;
                }
                case '\n': {
                    builder.append("\\n");
                    break;
                }
                case '\t': {
                    builder.append("\\t");
                    break;
                }
                case '\\': {
                    builder.append("\\\\");
                    break;
                }
                default: {
                    builder.append(c);
                }
            }
            ++i;
        }
        return builder.toString();
    }

    public static String unescape(String str) {
        StringBuilder builder = new StringBuilder(str.length() + 10);
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c == '\\') {
                switch (str.charAt(i + 1)) {
                    case 'r': {
                        builder.append('\r');
                        break;
                    }
                    case 'n': {
                        builder.append('\n');
                        break;
                    }
                    case 't': {
                        builder.append('\t');
                        break;
                    }
                    case '\\': {
                        builder.append('\\');
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid escape sequence.");
                    }
                }
                ++i;
            } else {
                builder.append(c);
            }
            ++i;
        }
        return builder.toString();
    }

    private class LocaleField {
        ResourceBundle bundle;
        Label label;
        Text text;
        Locale locale;
        String oldValue;
        boolean isReadOnly;
        Button button;

        private LocaleField() {
        }
    }
}

