/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.nls.internal.ui.model;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import org.eclipse.babel.editor.plugin.MessagesEditorPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.nls.internal.ui.model.ResourceBundle;
import org.eclipse.pde.nls.internal.ui.model.ResourceBundleElement;
import org.eclipse.pde.nls.internal.ui.model.ResourceBundleFamily;
import org.eclipse.pde.nls.internal.ui.model.ResourceBundleKey;

public class ResourceBundleModel
extends ResourceBundleElement {
    private static final String PROPERTIES_SUFFIX = ".properties";
    private static final String JAVA_NATURE = "org.eclipse.jdt.core.javanature";
    private ArrayList<ResourceBundleFamily> bundleFamilies = new ArrayList();
    private HashSet<Locale> loadedLocales = new HashSet();

    public ResourceBundleModel(IProgressMonitor monitor) {
        super(null);
        try {
            this.populateFromWorkspace(monitor);
        }
        catch (CoreException e) {
            MessagesEditorPlugin.log(e);
        }
    }

    public ResourceBundleFamily[] getFamilies() {
        return this.bundleFamilies.toArray(new ResourceBundleFamily[this.bundleFamilies.size()]);
    }

    public ResourceBundleFamily[] getFamiliesForPluginId(String pluginId) {
        ArrayList<ResourceBundleFamily> found = new ArrayList<ResourceBundleFamily>();
        for (ResourceBundleFamily family : this.bundleFamilies) {
            if (!family.getPluginId().equals(pluginId)) continue;
            found.add(family);
        }
        return found.toArray(new ResourceBundleFamily[found.size()]);
    }

    public ResourceBundleFamily[] getFamiliesForProjectName(String projectName) {
        ArrayList<ResourceBundleFamily> found = new ArrayList<ResourceBundleFamily>();
        for (ResourceBundleFamily family : this.bundleFamilies) {
            if (!family.getProjectName().equals(projectName)) continue;
            found.add(family);
        }
        return found.toArray(new ResourceBundleFamily[found.size()]);
    }

    public ResourceBundleFamily[] getFamiliesForProject(IProject project) {
        return this.getFamiliesForProjectName(project.getName());
    }

    public ResourceBundleKey[] getAllKeys() throws CoreException {
        Locale root = new Locale("", "", "");
        int size = 0;
        for (ResourceBundleFamily family : this.bundleFamilies) {
            ResourceBundle bundle = family.getBundle(root);
            if (bundle != null) {
                bundle.load();
            }
            size += family.getKeyCount();
        }
        ArrayList<ResourceBundleKey> allKeys = new ArrayList<ResourceBundleKey>(size);
        for (ResourceBundleFamily family : this.bundleFamilies) {
            ResourceBundleKey[] keys;
            ResourceBundleKey[] resourceBundleKeyArray = keys = family.getKeys();
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                ResourceBundleKey key = resourceBundleKeyArray[n2];
                allKeys.add(key);
                ++n2;
            }
        }
        return allKeys.toArray(new ResourceBundleKey[allKeys.size()]);
    }

    public void loadBundles(Locale locale) throws CoreException {
        ResourceBundleFamily[] families;
        ResourceBundleFamily[] resourceBundleFamilyArray = families = this.getFamilies();
        int n = families.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceBundleFamily family = resourceBundleFamilyArray[n2];
            ResourceBundle bundle = family.getBundle(locale);
            if (bundle != null) {
                bundle.load();
            }
            ++n2;
        }
        this.loadedLocales.add(locale);
    }

    public void unloadBundles(Locale locale) {
        ResourceBundleFamily[] families;
        if ("".equals(locale.getLanguage())) {
            return;
        }
        ResourceBundleFamily[] resourceBundleFamilyArray = families = this.getFamilies();
        int n = families.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceBundleFamily family = resourceBundleFamilyArray[n2];
            ResourceBundle bundle = family.getBundle(locale);
            if (bundle != null) {
                bundle.unload();
            }
            ++n2;
        }
        this.loadedLocales.remove(locale);
    }

    private void populateFromWorkspace(IProgressMonitor monitor) throws CoreException {
        IProject[] projects;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject[] iProjectArray = projects = root.getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            block39: {
                IProject project = iProjectArray[n2];
                try {
                    IPackageFragmentRoot packageFragmentRoot;
                    int n3;
                    Object[] objectArray;
                    if (!project.isOpen()) break block39;
                    IJavaProject javaProject = (IJavaProject)project.getNature(JAVA_NATURE);
                    String pluginId = null;
                    try {
                        Class<?> IFragmentModel = Class.forName("org.eclipse.pde.core.plugin.IFragmentModel");
                        Class<?> IPluginModelBase = Class.forName("org.eclipse.pde.core.plugin.IPluginModelBase");
                        Class<?> PluginRegistry = Class.forName("org.eclipse.pde.core.plugin.PluginRegistry");
                        Class<?> IPluginBase = Class.forName("org.eclipse.pde.core.plugin.IPluginBase");
                        Class<?> PluginFragmentModel = Class.forName("org.eclipse.core.runtime.model.PluginFragmentModel");
                        Class pluginModel = (Class)PluginRegistry.getMethod("findModel", IProject.class).invoke(null, project);
                        if (pluginModel != null) {
                            int n4;
                            int n5;
                            IResource[] iResourceArray;
                            boolean isFragment;
                            BundleDescription bd = (BundleDescription)IPluginModelBase.getMethod("getBundleDescription", new Class[0]).invoke((Object)pluginModel, new Object[0]);
                            pluginId = bd.getName();
                            if (pluginId == null) {
                                Object pluginBase = IPluginModelBase.getMethod("getPluginBase", new Class[0]).invoke((Object)pluginModel, new Object[0]);
                                pluginId = (String)IPluginBase.getMethod("getId", new Class[0]).invoke(pluginBase, new Object[0]);
                            }
                            if (isFragment = IFragmentModel.isInstance(pluginModel)) {
                                Method pfm = IFragmentModel.getMethod("getFragment", new Class[0]);
                                pluginId = (String)PluginFragmentModel.getMethod("getPluginId", new Class[0]).invoke((Object)pfm, new Object[0]);
                            }
                            IFolder nl = project.getFolder("nl");
                            if (isFragment && nl.exists()) {
                                IResource[] members;
                                iResourceArray = members = nl.members();
                                n5 = members.length;
                                n4 = 0;
                                while (n4 < n5) {
                                    IResource member = iResourceArray[n4];
                                    if (member instanceof IFolder) {
                                        IFolder langFolder = (IFolder)member;
                                        String language = langFolder.getName();
                                        IFile[] propertyFiles = this.collectPropertyFiles((IContainer)langFolder);
                                        objectArray = propertyFiles;
                                        n3 = propertyFiles.length;
                                        int n6 = 0;
                                        while (n6 < n3) {
                                            Object file = objectArray[n6];
                                            IPath path = file.getProjectRelativePath();
                                            String country = "";
                                            String packageName = null;
                                            int segmentCount = path.segmentCount();
                                            if (segmentCount > 1) {
                                                StringBuilder builder = new StringBuilder();
                                                int begin = 2;
                                                if (segmentCount > 2 && this.isCountry(path.segment(2))) {
                                                    begin = 3;
                                                    country = path.segment(2);
                                                }
                                                int i = begin;
                                                while (i < segmentCount - 1) {
                                                    if (i > begin) {
                                                        builder.append('.');
                                                    }
                                                    builder.append(path.segment(i));
                                                    ++i;
                                                }
                                                packageName = builder.toString();
                                            }
                                            String baseName = this.getBaseName(file.getName());
                                            ResourceBundleFamily family = this.getOrCreateFamily(project.getName(), pluginId, packageName, baseName);
                                            this.addBundle(family, this.getLocale(language, country), file);
                                            ++n6;
                                        }
                                    }
                                    ++n4;
                                }
                            }
                            if (isFragment || javaProject == null) {
                                IFile[] propertyFiles2 = this.collectPropertyFiles((IContainer)project);
                                iResourceArray = propertyFiles2;
                                n5 = propertyFiles2.length;
                                n4 = 0;
                                while (n4 < n5) {
                                    IResource file = iResourceArray[n4];
                                    IPath path = file.getProjectRelativePath();
                                    int segmentCount = path.segmentCount();
                                    if (segmentCount <= 0 || !path.segment(0).equals("nl")) {
                                        String packageName = null;
                                        if (segmentCount > 1) {
                                            StringBuilder builder = new StringBuilder();
                                            int i = 0;
                                            while (i < segmentCount - 1) {
                                                if (i > 0) {
                                                    builder.append('.');
                                                }
                                                builder.append(path.segment(i));
                                                ++i;
                                            }
                                            packageName = builder.toString();
                                        }
                                        String baseName = this.getBaseName(file.getName());
                                        String language = this.getLanguage(file.getName());
                                        String country = this.getCountry(file.getName());
                                        ResourceBundleFamily family = this.getOrCreateFamily(project.getName(), pluginId, packageName, baseName);
                                        this.addBundle(family, this.getLocale(language, country), file);
                                    }
                                    ++n4;
                                }
                            }
                        }
                    }
                    catch (Throwable throwable) {}
                    if (javaProject == null) break block39;
                    IClasspathEntry[] classpathEntries = javaProject.getResolvedClasspath(true);
                    IClasspathEntry[] iClasspathEntryArray = classpathEntries;
                    int IPluginBase = classpathEntries.length;
                    int PluginRegistry = 0;
                    while (PluginRegistry < IPluginBase) {
                        IClasspathEntry entry = iClasspathEntryArray[PluginRegistry];
                        if (entry.getEntryKind() == 3) {
                            IFile[] propertyFiles;
                            IPath path = entry.getPath();
                            IFolder folder = workspace.getRoot().getFolder(path);
                            IFile[] iFileArray = propertyFiles = this.collectPropertyFiles((IContainer)folder);
                            int file = propertyFiles.length;
                            int propertyFiles2 = 0;
                            while (propertyFiles2 < file) {
                                IFile file2 = iFileArray[propertyFiles2];
                                String name = file2.getName();
                                String baseName = this.getBaseName(name);
                                String language = this.getLanguage(name);
                                String country = this.getCountry(name);
                                IPackageFragment pf = javaProject.findPackageFragment(file2.getParent().getFullPath());
                                String packageName = pf.getElementName();
                                ResourceBundleFamily family = this.getOrCreateFamily(project.getName(), pluginId, packageName, baseName);
                                this.addBundle(family, this.getLocale(language, country), file2);
                                ++propertyFiles2;
                            }
                        } else if (entry.getEntryKind() == 1) {
                            IPackageFragmentRoot[] findPackageFragmentRoots;
                            IPackageFragmentRoot[] propertyFiles2 = findPackageFragmentRoots = javaProject.findPackageFragmentRoots(entry);
                            int file2 = findPackageFragmentRoots.length;
                            int propertyFiles = 0;
                            while (propertyFiles < file2) {
                                IJavaElement[] children;
                                packageFragmentRoot = propertyFiles2[propertyFiles];
                                IJavaElement[] iJavaElementArray = children = packageFragmentRoot.getChildren();
                                int n7 = children.length;
                                int n8 = 0;
                                while (n8 < n7) {
                                    Object[] nonJavaResources;
                                    IJavaElement child = iJavaElementArray[n8];
                                    IPackageFragment pf = (IPackageFragment)child;
                                    objectArray = nonJavaResources = pf.getNonJavaResources();
                                    n3 = nonJavaResources.length;
                                    int n9 = 0;
                                    while (n9 < n3) {
                                        IJarEntryResource jarEntryResource;
                                        String name;
                                        Object resource = objectArray[n9];
                                        if (resource instanceof IJarEntryResource && (name = (jarEntryResource = (IJarEntryResource)resource).getName()).endsWith(PROPERTIES_SUFFIX)) {
                                            String baseName = this.getBaseName(name);
                                            String language = this.getLanguage(name);
                                            String country = this.getCountry(name);
                                            String packageName = pf.getElementName();
                                            ResourceBundleFamily family = this.getOrCreateFamily(project.getName(), pluginId, packageName, baseName);
                                            this.addBundle(family, this.getLocale(language, country), jarEntryResource);
                                        }
                                        ++n9;
                                    }
                                    ++n8;
                                }
                                ++propertyFiles;
                            }
                        }
                        ++PluginRegistry;
                    }
                    IPackageFragmentRoot nonJavaResources = javaProject.getNonJavaResources();
                    ArrayList<IFile> files = new ArrayList<IFile>();
                    packageFragmentRoot = nonJavaResources;
                    int findPackageFragmentRoots = ((Object[])packageFragmentRoot).length;
                    int n10 = 0;
                    while (n10 < findPackageFragmentRoots) {
                        IFile file;
                        String name;
                        Object resource = packageFragmentRoot[n10];
                        if (resource instanceof IContainer) {
                            IContainer container = (IContainer)resource;
                            this.collectPropertyFiles(container, files);
                        } else if (resource instanceof IFile && !this.isIgnoredFilename(name = (file = (IFile)resource).getName()) && name.endsWith(PROPERTIES_SUFFIX)) {
                            files.add(file);
                        }
                        ++n10;
                    }
                    for (IFile file : files) {
                        IPath path = file.getProjectRelativePath();
                        String packageName = null;
                        int segmentCount = path.segmentCount();
                        if (segmentCount > 1) {
                            StringBuilder builder = new StringBuilder();
                            int i = 0;
                            while (i < segmentCount - 1) {
                                if (i > 0) {
                                    builder.append('.');
                                }
                                builder.append(path.segment(i));
                                ++i;
                            }
                            packageName = builder.toString();
                        }
                        String baseName = this.getBaseName(file.getName());
                        String language = this.getLanguage(file.getName());
                        String country = this.getCountry(file.getName());
                        ResourceBundleFamily family = this.getOrCreateFamily(project.getName(), pluginId, packageName, baseName);
                        this.addBundle(family, this.getLocale(language, country), file);
                    }
                }
                catch (Exception e) {
                    MessagesEditorPlugin.log(e);
                }
            }
            ++n2;
        }
    }

    private IFile[] collectPropertyFiles(IContainer container) throws CoreException {
        ArrayList<IFile> files = new ArrayList<IFile>();
        this.collectPropertyFiles(container, files);
        return files.toArray(new IFile[files.size()]);
    }

    private void collectPropertyFiles(IContainer container, ArrayList<IFile> files) throws CoreException {
        IResource[] members;
        IResource[] iResourceArray = members = container.members();
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource.exists()) {
                if (resource instanceof IContainer) {
                    IContainer childContainer = (IContainer)resource;
                    this.collectPropertyFiles(childContainer, files);
                } else if (resource instanceof IFile) {
                    IFile file = (IFile)resource;
                    String name = file.getName();
                    if ((file.getProjectRelativePath().segmentCount() != 0 || !this.isIgnoredFilename(name)) && name.endsWith(PROPERTIES_SUFFIX)) {
                        files.add(file);
                    }
                }
            }
            ++n2;
        }
    }

    private boolean isCountry(String name) {
        if (name == null || name.length() != 2) {
            return false;
        }
        char c1 = name.charAt(0);
        char c2 = name.charAt(1);
        return 'A' <= c1 && c1 <= 'Z' && 'A' <= c2 && c2 <= 'Z';
    }

    private Locale getLocale(String language, String country) {
        if (language == null) {
            language = "";
        }
        if (country == null) {
            country = "";
        }
        return new Locale(language, country);
    }

    private void addBundle(ResourceBundleFamily family, Locale locale, Object resource) throws CoreException {
        ResourceBundle bundle = new ResourceBundle(family, resource, locale);
        if ("".equals(locale.getLanguage())) {
            bundle.load();
        }
        family.addBundle(bundle);
    }

    private String getBaseName(String filename) {
        if (!filename.endsWith(PROPERTIES_SUFFIX)) {
            throw new IllegalArgumentException();
        }
        String name = filename.substring(0, filename.length() - 11);
        int len = name.length();
        if (len > 3 && name.charAt(len - 3) == '_') {
            if (len > 6 && name.charAt(len - 6) == '_') {
                return name.substring(0, len - 6);
            }
            return name.substring(0, len - 3);
        }
        return name;
    }

    private String getLanguage(String filename) {
        if (!filename.endsWith(PROPERTIES_SUFFIX)) {
            throw new IllegalArgumentException();
        }
        String name = filename.substring(0, filename.length() - 11);
        int len = name.length();
        if (len > 3 && name.charAt(len - 3) == '_') {
            if (len > 6 && name.charAt(len - 6) == '_') {
                return name.substring(len - 5, len - 3);
            }
            return name.substring(len - 2);
        }
        return "";
    }

    private String getCountry(String filename) {
        if (!filename.endsWith(PROPERTIES_SUFFIX)) {
            throw new IllegalArgumentException();
        }
        String name = filename.substring(0, filename.length() - 11);
        int len = name.length();
        if (len > 3 && name.charAt(len - 3) == '_') {
            if (len > 6 && name.charAt(len - 6) == '_') {
                return name.substring(len - 2);
            }
            return "";
        }
        return "";
    }

    private ResourceBundleFamily getOrCreateFamily(String projectName, String pluginId, String packageName, String baseName) {
        ResourceBundleFamily family2;
        if (pluginId != null) {
            projectName = null;
        }
        for (ResourceBundleFamily family2 : this.bundleFamilies) {
            if (!this.areEqual(family2.getProjectName(), projectName) || !this.areEqual(family2.getPluginId(), pluginId) || !this.areEqual(family2.getPackageName(), packageName) || !this.areEqual(family2.getBaseName(), baseName)) continue;
            return family2;
        }
        family2 = new ResourceBundleFamily(this, projectName, pluginId, packageName, baseName);
        this.bundleFamilies.add(family2);
        return family2;
    }

    private boolean isIgnoredFilename(String filename) {
        return filename.equals("build.properties") || filename.equals("logging.properties");
    }

    private boolean areEqual(String str1, String str2) {
        return str1 == null && str2 == null || str1 != null && str1.equals(str2);
    }
}

