/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.editor.action;

import com.jaspersoft.studio.components.chart.editor.ChartThemeEditor;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import net.sf.jasperreports.chartthemes.simple.ChartThemeSettings;
import net.sf.jasperreports.chartthemes.simple.XmlChartThemeExtensionsRegistryFactory;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.wizard.project.ProjectUtil;
import net.sf.jasperreports.engine.JasperReportsContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SaveAsDialog;

public class ExportJar
extends Action {
    public static final String ID = "EXPORTCHARTHEMEJAR";
    private ChartThemeEditor editor;
    private boolean addtoclasspath = true;
    private String name;

    public ExportJar(ChartThemeEditor editor) {
        this.setId(ID);
        this.editor = editor;
    }

    public void run() {
        IFile file;
        SaveAsDialog saveAsDialog = new SaveAsDialog(Display.getDefault().getActiveShell()){

            protected Control createDialogArea(Composite parent) {
                Composite cmp = (Composite)super.createDialogArea(parent);
                Composite composite = new Composite(cmp, 0);
                GridLayout layout = new GridLayout(2, false);
                layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
                layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
                composite.setLayout((Layout)layout);
                composite.setLayoutData((Object)new GridData(768));
                new Label(composite, 0).setText("Theme Name");
                final Text txt = new Text(composite, 2048);
                txt.setLayoutData((Object)new GridData(768));
                txt.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        ExportJar.this.name = txt.getText();
                    }
                });
                txt.setText(ExportJar.this.getChartThemeName());
                final Button btn = new Button(composite, 32);
                btn.setText("Add the jar to the CLASSPATH to use the theme in the report designer.");
                btn.setSelection(true);
                btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ExportJar.this.addtoclasspath = btn.getSelection();
                    }
                });
                GridData gd = new GridData();
                gd.horizontalSpan = 2;
                btn.setLayoutData((Object)gd);
                return cmp;
            }
        };
        saveAsDialog.setOriginalName(this.editor.getEditorInput().getName().replaceFirst(".jrctx", ".jar"));
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
            IProgressMonitor monitor = this.editor.getEditorSite().getActionBars().getStatusLineManager().getProgressMonitor();
            monitor.beginTask("Exporting Chart Themes to a JAR", -1);
            try {
                ChartThemeSettings cts = this.editor.getChartThemeSettings();
                File f = new File(file.getRawLocationURI());
                f.createNewFile();
                file.refreshLocal(2, monitor);
                XmlChartThemeExtensionsRegistryFactory.saveToJar((JasperReportsContext)this.editor.getJrContext(), (ChartThemeSettings)cts, (String)this.name, (File)f);
                if (this.addtoclasspath) {
                    ProjectUtil.addFileToClasspath((IProgressMonitor)monitor, (IFile)file);
                }
                UIUtils.showInformation((String)"Chart Theme was generated");
            }
            catch (UnsupportedEncodingException e) {
                UIUtils.showError((Throwable)e);
            }
            catch (IOException e) {
                UIUtils.showError((Throwable)e);
            }
            catch (CoreException e) {
                UIUtils.showError((Throwable)e);
            }
            monitor.done();
        }
    }

    protected String getChartThemeName() {
        return this.editor.getEditorInput().getName().replaceAll(".jrctx", "");
    }
}

