/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.editor.wizard;

import com.jaspersoft.studio.components.chart.ContextHelpIDs;
import com.jaspersoft.studio.components.chart.editor.wizard.BaseSettingsFactory;
import com.jaspersoft.studio.components.chart.messages.Messages;
import com.jaspersoft.studio.utils.SelectionHelper;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.wizards.ContextData;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import net.sf.jasperreports.chartthemes.simple.ChartThemeSettings;
import net.sf.jasperreports.chartthemes.simple.XmlChartTheme;
import net.sf.jasperreports.eclipse.builder.jdt.JDTUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.wizard.project.ProjectUtil;
import net.sf.jasperreports.engine.JasperReportsContext;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.EditPart;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class ChartThemeNewWizard
extends Wizard
implements INewWizard {
    public static final String WIZARD_ID = "com.jaspersoft.studio.components.chart.editor.wizard.ChartThemeNewWizard";
    private static final String NEW_NAME = "chart_template";
    private static final String NEW_EXT = ".jrctx";
    private static final String NEW_FILENAME = "chart_template.jrctx";
    private WizardNewFileCreationPage step1;
    private ISelection selection;
    private IFile reportFile;

    public ChartThemeNewWizard() {
        this.setWindowTitle(Messages.ChartThemeNewWizard_WindowTitle);
        this.setNeedsProgressMonitor(true);
        JDTUtils.deactivateLinkedResourcesSupport();
    }

    public void addPages() {
        this.step1 = new WizardHelpNewFileCreationPage("newFilePage1", (IStructuredSelection)this.selection);
        this.step1.setTitle(Messages.ChartThemeNewWizard_PageTitle);
        this.step1.setDescription(Messages.ChartThemeNewWizard_PageDescription);
        this.step1.setFileExtension("jrctx");
        this.setupNewFileName();
        this.addPage((IWizardPage)this.step1);
    }

    public void setupNewFileName() {
        String filename = NEW_FILENAME;
        if (this.selection != null) {
            TreeSelection s;
            if (this.selection instanceof TreeSelection && (s = (TreeSelection)this.selection).getFirstElement() instanceof IFile) {
                IFile file = (IFile)s.getFirstElement();
                String f = String.valueOf(file.getProjectRelativePath().removeLastSegments(1).toOSString()) + "/" + filename;
                int i = 1;
                while (file.getProject().getFile(f).exists()) {
                    filename = NEW_NAME + i + NEW_EXT;
                    f = String.valueOf(file.getProjectRelativePath().removeLastSegments(1).toOSString()) + "/" + filename;
                    ++i;
                }
            }
            this.step1.setFileName(filename);
        }
    }

    public boolean performCancel() {
        JDTUtils.restoreLinkedResourcesSupport();
        return super.performCancel();
    }

    public boolean canFinish() {
        if (JDTUtils.isVirtualResource((IPath)this.step1.getContainerFullPath())) {
            this.step1.setErrorMessage(Messages.ChartThemeNewWizard_VirtualFolderError);
            return false;
        }
        return super.canFinish();
    }

    public boolean performFinish() {
        JDTUtils.restoreLinkedResourcesSupport();
        final String containerName = this.step1.getContainerFullPath().toPortableString();
        final String fileName = this.step1.getFileName();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        ChartThemeNewWizard.this.doFinish(containerName, fileName, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(String containerName, String fileName, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Creating " + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException("Container \"" + containerName + "\" does not exist.");
        }
        IContainer container = (IContainer)resource;
        final IFile file = container.getFile((IPath)new Path(fileName));
        InputStream in = null;
        try {
            in = this.openContentStream(file);
            if (file.exists()) {
                file.setContents(in, true, true, monitor);
            } else {
                file.create(in, true, monitor);
            }
            this.reportFile = file;
        }
        finally {
            FileUtils.closeStream((Closeable)in);
        }
        monitor.worked(1);
        monitor.setTaskName("Opening file for editing...");
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        });
        monitor.worked(1);
    }

    public IFile getReportFile() {
        return this.reportFile;
    }

    private InputStream openContentStream(IFile file) {
        String contents = XmlChartTheme.saveSettings((JasperReportsContext)JasperReportsConfiguration.getDefaultJRConfig((IFile)file), (ChartThemeSettings)BaseSettingsFactory.createChartThemeSettings());
        return new ByteArrayInputStream(contents.getBytes());
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "com.jaspersoft.studio", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        if (selection instanceof StructuredSelection) {
            IProject p;
            IProject[] prjs;
            if (selection.getFirstElement() instanceof IProject || selection.getFirstElement() instanceof IFile || selection.getFirstElement() instanceof IFolder || selection.getFirstElement() instanceof IPackageFragment) {
                this.selection = selection;
                return;
            }
            for (Object obj : selection.toList()) {
                IEditorInput ein;
                if (!(obj instanceof EditPart) || !((ein = SelectionHelper.getActiveJRXMLEditor().getEditorInput()) instanceof FileEditorInput)) continue;
                this.selection = new TreeSelection(new TreePath(new Object[]{((FileEditorInput)ein).getFile()}));
                return;
            }
            NullProgressMonitor progressMonitor = new NullProgressMonitor();
            IProject[] iProjectArray = prjs = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = prjs.length;
            int n2 = 0;
            while (n2 < n) {
                p = iProjectArray[n2];
                try {
                    if (ProjectUtil.isOpen((IProject)p) && p.getNature("org.eclipse.jdt.core.javanature") != null) {
                        p.open((IProgressMonitor)progressMonitor);
                        this.selection = new TreeSelection(new TreePath(new Object[]{p.getFile(NEW_FILENAME)}));
                        return;
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
            iProjectArray = prjs;
            n = prjs.length;
            n2 = 0;
            while (n2 < n) {
                p = iProjectArray[n2];
                try {
                    if (ProjectUtil.isOpen((IProject)p)) {
                        p.open((IProgressMonitor)progressMonitor);
                        this.selection = new TreeSelection(new TreePath(new Object[]{p.getFile(NEW_FILENAME)}));
                        return;
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
        }
        this.selection = selection;
    }

    private class WizardHelpNewFileCreationPage
    extends WizardNewFileCreationPage
    implements ContextData {
        public WizardHelpNewFileCreationPage(String pageName, IStructuredSelection selection) {
            super(pageName, selection);
        }

        public void performHelp() {
            PlatformUI.getWorkbench().getHelpSystem().displayHelp(ContextHelpIDs.WIZARD_CHART_THEME_PATH);
        }

        public void setHelpData() {
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), ContextHelpIDs.WIZARD_CHART_THEME_PATH);
        }

        protected void setControl(Control newControl) {
            super.setControl(newControl);
            newControl.addListener(28, new Listener(){

                public void handleEvent(Event event) {
                    WizardHelpNewFileCreationPage.this.performHelp();
                }
            });
            this.setHelpData();
        }

        public void setVisible(boolean visible) {
            JDTUtils.deactivateLinkedResourcesSupport((boolean)visible);
            super.setVisible(visible);
        }
    }
}

