/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.model.chartAxis.command;

import com.jaspersoft.studio.components.chart.messages.Messages;
import com.jaspersoft.studio.components.chart.wizard.ChartTypeWizardPage;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.jasperreports.charts.JRAreaPlot;
import net.sf.jasperreports.charts.JRBar3DPlot;
import net.sf.jasperreports.charts.JRBarPlot;
import net.sf.jasperreports.charts.JRBubblePlot;
import net.sf.jasperreports.charts.JRCandlestickPlot;
import net.sf.jasperreports.charts.JRHighLowPlot;
import net.sf.jasperreports.charts.JRLinePlot;
import net.sf.jasperreports.charts.JRScatterPlot;
import net.sf.jasperreports.charts.JRTimeSeriesPlot;
import net.sf.jasperreports.engine.JRChartPlot;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.nebula.widgets.gallery.AbstractGalleryGroupRenderer;
import org.eclipse.nebula.widgets.gallery.AbstractGalleryItemRenderer;
import org.eclipse.nebula.widgets.gallery.Gallery;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.nebula.widgets.gallery.NoGroupRenderer;
import org.eclipse.nebula.widgets.gallery.RoundedGalleryItemRenderer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;

public class ChartAxesWizardPage
extends WizardPage {
    private static final int GALLERY_HEIGHT = 100;
    private static final int GALLERY_WIDTH = 100;
    private byte chartAxes;
    private Scale zoomFactor;
    private Gallery chartsGallery;
    private GalleryItem itemGroup;
    private static Map<Byte, Class<? extends JRChartPlot>> plotmap = new LinkedHashMap<Byte, Class<? extends JRChartPlot>>();

    static {
        plotmap.put((byte)7, JRLinePlot.class);
        plotmap.put((byte)15, JRLinePlot.class);
        plotmap.put((byte)1, JRAreaPlot.class);
        plotmap.put((byte)13, JRAreaPlot.class);
        plotmap.put((byte)20, JRAreaPlot.class);
        plotmap.put((byte)3, JRBarPlot.class);
        plotmap.put((byte)12, JRBarPlot.class);
        plotmap.put((byte)14, JRBarPlot.class);
        plotmap.put((byte)2, JRBar3DPlot.class);
        plotmap.put((byte)11, JRBar3DPlot.class);
        plotmap.put((byte)4, JRBubblePlot.class);
        plotmap.put((byte)5, JRCandlestickPlot.class);
        plotmap.put((byte)6, JRHighLowPlot.class);
        plotmap.put((byte)10, JRScatterPlot.class);
        plotmap.put((byte)16, JRTimeSeriesPlot.class);
    }

    public byte getChartAxis() {
        return this.chartAxes;
    }

    public ChartAxesWizardPage() {
        super("chartaxiswizard");
        this.setTitle(Messages.common_chartaxis_wizard);
        this.setDescription(Messages.ChartAxesWizardPage_chartaxis_wizard_description);
        this.setPageComplete(false);
    }

    public void dispose() {
        GalleryItem[] tis;
        if (this.chartsGallery != null && (tis = this.chartsGallery.getSelection()).length > 0) {
            GalleryItem ti = tis[0];
            this.chartAxes = (Byte)ti.getData();
        }
        super.dispose();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        this.setControl((Control)composite);
        this.zoomFactor = new Scale(composite, 0);
        this.zoomFactor.setMinimum(1);
        this.zoomFactor.setMaximum(50);
        this.zoomFactor.setIncrement(1);
        this.zoomFactor.setPageIncrement(5);
        GridData gd = new GridData(128);
        gd.widthHint = 150;
        this.zoomFactor.setLayoutData((Object)gd);
        this.chartsGallery = new Gallery(composite, 0x10000A00);
        final NoGroupRenderer gr = new NoGroupRenderer();
        gr.setMinMargin(2);
        gr.setItemSize(100, 100);
        gr.setAutoMargin(true);
        gd = new GridData(1808);
        gd.widthHint = 500;
        this.chartsGallery.setLayoutData((Object)gd);
        this.chartsGallery.setGroupRenderer((AbstractGalleryGroupRenderer)gr);
        RoundedGalleryItemRenderer ir = new RoundedGalleryItemRenderer();
        ir.setShowLabels(true);
        ir.setShowRoundedSelectionCorners(false);
        ir.setSelectionForegroundColor(this.getShell().getDisplay().getSystemColor(9));
        this.chartsGallery.setItemRenderer((AbstractGalleryItemRenderer)ir);
        this.itemGroup = new GalleryItem(this.chartsGallery, 0);
        this.fillTableb4j(this.chartsGallery, this.itemGroup);
        this.chartsGallery.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item instanceof GalleryItem) {
                    ChartAxesWizardPage.this.chartAxes = (Byte)((GalleryItem)e.item).getData();
                    ChartAxesWizardPage.this.setPageComplete(true);
                } else {
                    ChartAxesWizardPage.this.setPageComplete(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.zoomFactor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                double c = 1.0 + 0.1 * (double)ChartAxesWizardPage.this.zoomFactor.getSelection();
                gr.setItemSize((int)(100.0 * c), (int)(100.0 * c));
            }
        });
    }

    private void fillTableb4j(Gallery table, GalleryItem rootItem) {
        table.setRedraw(false);
        boolean defaultSelected = false;
        for (byte ctype : plotmap.keySet()) {
            GalleryItem item = ChartTypeWizardPage.getTableItem(ctype, rootItem);
            if (defaultSelected) continue;
            table.setSelection(new GalleryItem[]{item});
            this.chartAxes = (Byte)item.getData();
            this.setPageComplete(true);
            defaultSelected = true;
        }
        table.setRedraw(true);
    }
}

