/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.model.command;

import com.jaspersoft.studio.components.chart.model.MChart;
import com.jaspersoft.studio.components.chart.model.chartAxis.command.CreateChartAxesCommand;
import com.jaspersoft.studio.components.chart.wizard.ChartWizard;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.IGroupElement;
import com.jaspersoft.studio.model.MElementGroup;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.band.MBand;
import com.jaspersoft.studio.model.frame.MFrame;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.design.JRDesignChart;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementDataset;
import net.sf.jasperreports.engine.design.JRDesignElementGroup;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;

public class EditChartCommand
extends Command {
    private JRElementGroup jrGroup;
    private JRDesignChart oldChart;
    private JRDesignChart newChart;
    protected JasperReportsConfiguration jConfig;
    private MChart originalNode;
    private Byte chosenAxis;

    public EditChartCommand(MFrame parent, MChart mchart) {
        this((ANode)parent, mchart, -1);
    }

    public EditChartCommand(MBand parent, MChart mchart) {
        this((ANode)parent, mchart, -1);
    }

    public EditChartCommand(MElementGroup parent, MChart mchart) {
        this((ANode)parent, mchart, -1);
    }

    private EditChartCommand(ANode parent, MChart mchart, int index) {
        this.originalNode = mchart;
        this.jConfig = parent.getJasperConfiguration();
        this.oldChart = mchart.getValue();
        this.jrGroup = parent instanceof IGroupElement ? ((IGroupElement)parent).getJRElementGroup() : (JRElementGroup)parent.getValue();
    }

    public void execute() {
        if (this.newChart == null) {
            JRDesignChart clone = (JRDesignChart)this.oldChart.clone();
            ChartWizard wizard = new ChartWizard((MGraphicElement)new MChart(null, (JRChart)clone, -1), (JRDesignElementDataset)clone.getDataset(), true);
            wizard.setConfig(this.jConfig, false);
            wizard.setExpressionContext(ModelUtils.getElementExpressionContext((JRDesignElement)this.oldChart, (ANode)this.originalNode));
            WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
            dialog.create();
            if (dialog.open() == 0) {
                this.newChart = (JRDesignChart)wizard.getChart().getValue();
                if (this.newChart.getChartType() == 19) {
                    this.chosenAxis = wizard.getChoseAxis();
                    if (this.chosenAxis != null) {
                        CreateChartAxesCommand cmd = new CreateChartAxesCommand(this.newChart, null, -1, this.jConfig.getJasperDesign());
                        cmd.setSelectedAxes(this.chosenAxis);
                        cmd.execute();
                    }
                }
            } else {
                return;
            }
        }
        this.switchCharts(this.oldChart, this.newChart);
    }

    public void undo() {
        if (this.newChart != null) {
            this.switchCharts(this.newChart, this.oldChart);
        }
    }

    private void switchCharts(JRDesignChart chart1, JRDesignChart chart2) {
        int index = this.jrGroup.getChildren().indexOf(chart1);
        if (this.jrGroup instanceof JRDesignElementGroup) {
            ((JRDesignElementGroup)this.jrGroup).removeElement((JRDesignElement)chart1);
            ((JRDesignElementGroup)this.jrGroup).addElement(index, (JRDesignElement)chart2);
        } else if (this.jrGroup instanceof JRDesignFrame) {
            ((JRDesignFrame)this.jrGroup).removeElement((JRElement)chart1);
            ((JRDesignFrame)this.jrGroup).addElement(index, (JRElement)chart2);
        }
    }
}

