/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.model.theme.paintprovider;

import com.jaspersoft.studio.components.chart.messages.Messages;
import com.jaspersoft.studio.property.color.chooser.ColorDialog;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptor.color.ColorLabelProvider;
import com.jaspersoft.studio.utils.AlfaRGB;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ColorWidget
extends Composite {
    public static ColorLabelProvider cprovider = new ColorLabelProvider(NullEnum.NULL);
    private Text tcolor;
    private Button b;
    private RGB color;
    private boolean isRefresh = false;
    private PropertyChangeSupport psuport = new PropertyChangeSupport((Object)this);

    public ColorWidget(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.tcolor = new Text((Composite)this, 0x1000808);
        this.tcolor.setLayoutData((Object)new GridData(768));
        this.tcolor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!ColorWidget.this.isRefresh) {
                    return;
                }
            }
        });
        this.b = new Button((Composite)this, 8);
        this.b.setImage(cprovider.getImage(null));
        this.b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorDialog cd = new ColorDialog(ColorWidget.this.b.getShell());
                cd.setText(Messages.common_color);
                cd.setRGB(ColorWidget.this.color);
                RGB newColor = cd.openRGB();
                if (newColor != null) {
                    RGB oldColor = ColorWidget.this.color;
                    ColorWidget.this.color = newColor;
                    ColorWidget.this.setupWidgets(newColor);
                    ColorWidget.this.psuport.firePropertyChange("color", oldColor, new AlfaRGB(newColor, 255));
                }
            }
        });
    }

    private void setupWidgets(RGB rgb) {
        if (!this.isRefresh) {
            this.isRefresh = true;
            this.tcolor.setText(rgb == null ? "" : cprovider.getText((Object)rgb));
            this.b.setImage(cprovider.getImage((Object)rgb));
            this.isRefresh = false;
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.tcolor.setEnabled(enabled);
        this.b.setEnabled(enabled);
        this.setupWidgets(enabled ? this.color : null);
    }

    public void setColor(RGB color) {
        this.color = color;
        this.setupWidgets(color);
    }

    public RGB getColor() {
        return this.color;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.psuport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.psuport.removePropertyChangeListener(l);
    }

    public void dispose() {
        PropertyChangeListener[] propertyChangeListenerArray = this.psuport.getPropertyChangeListeners();
        int n = propertyChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyChangeListener l = propertyChangeListenerArray[n2];
            this.psuport.removePropertyChangeListener(l);
            ++n2;
        }
        super.dispose();
    }
}

