/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.model.theme.stroke;

import com.jaspersoft.studio.editor.gef.figures.ComponentFigure;
import com.jaspersoft.studio.editor.java2d.J2DLightweightSystem;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class StrokeWidget
extends Composite {
    private Figure parentFigure;
    private Canvas square;
    private J2DLightweightSystem lws;
    private BasicStroke stroke;

    public StrokeWidget(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout());
        this.square = new Canvas((Composite)this, 0x140000);
        this.lws = new J2DLightweightSystem();
        this.lws.setControl(this.square);
        this.parentFigure = new RectangleFigure(){

            public void paint(Graphics graphics) {
                if (StrokeWidget.this.stroke != null) {
                    int offset = (int)StrokeWidget.this.stroke.getLineWidth();
                    int x = this.getBounds().x + offset;
                    int y = this.getBounds().y + offset;
                    int w = this.getBounds().width - 2 * offset - 10;
                    int h = this.getBounds().height - 2 * offset - 10;
                    graphics.setForegroundColor(ColorConstants.black);
                    graphics.setBackgroundColor(ColorConstants.lightGray);
                    Graphics2D g = ComponentFigure.getG2D((Graphics)graphics);
                    if (g != null) {
                        g.setStroke(StrokeWidget.this.stroke);
                        g.drawRect(x, y, w, h);
                    }
                }
            }
        };
        this.lws.setContents((IFigure)this.parentFigure);
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                StrokeWidget.this.setTBounds();
            }
        });
    }

    public Control getCanvas() {
        return this.square;
    }

    public void setStroke(BasicStroke stroke) {
        this.stroke = stroke;
    }

    public void setTBounds() {
        if (!this.isDisposed()) {
            Rectangle r = this.getBounds();
            this.parentFigure.setSize(r.width, r.height);
            this.parentFigure.invalidate();
            this.square.setSize(r.width, r.height);
            this.square.redraw();
            this.lws.getUpdateManager().performUpdate();
        }
    }
}

