/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.model.theme.strokes;

import com.jaspersoft.studio.components.chart.model.theme.stroke.StrokeDialog;
import com.jaspersoft.studio.components.chart.model.theme.stroke.StrokeLabelProvider;
import com.jaspersoft.studio.swt.widgets.table.DeleteButton;
import com.jaspersoft.studio.swt.widgets.table.EditButton;
import com.jaspersoft.studio.swt.widgets.table.IEditElement;
import com.jaspersoft.studio.swt.widgets.table.INewElement;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import com.jaspersoft.studio.swt.widgets.table.ListOrderButtons;
import com.jaspersoft.studio.swt.widgets.table.NewButton;
import java.awt.BasicStroke;
import java.awt.Stroke;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.PersistentLocationDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class StrokesDialog
extends PersistentLocationDialog {
    private Table table;
    private TableViewer tableViewer;
    private List<Stroke> value;
    private EditElement editElement;
    private EditButton<Object> editButton;

    protected StrokesDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Strokes");
    }

    public List<Stroke> getValue() {
        return this.value;
    }

    protected void setReturnCode(int code) {
        super.setReturnCode(code);
        if (code == 0) {
            this.value = (List)this.tableViewer.getInput();
        }
    }

    public void setValue(List<Stroke> value) {
        this.value = value;
    }

    protected Control createDialogArea(Composite parent) {
        final Composite cmp = (Composite)super.createDialogArea(parent);
        cmp.setLayout((Layout)new GridLayout(2, false));
        this.buildTable(cmp);
        Composite bGroup = new Composite(cmp, 0);
        bGroup.setLayout((Layout)new GridLayout(1, false));
        bGroup.setLayoutData((Object)new GridData(1040));
        new NewButton().createNewButtons(bGroup, this.tableViewer, new INewElement(){

            public Object newElement(List<?> input, int pos) {
                StrokeDialog d = new StrokeDialog(cmp.getShell());
                d.setValue(new BasicStroke());
                if (d.open() == 0) {
                    return d.getValue();
                }
                return null;
            }
        });
        this.editElement = new EditElement();
        this.editButton = new EditButton();
        this.editButton.createEditButtons(bGroup, this.tableViewer, (IEditElement)this.editElement);
        new DeleteButton().createDeleteButton(bGroup, this.tableViewer);
        new ListOrderButtons().createOrderButtons(bGroup, this.tableViewer);
        this.tableViewer.setInput(this.value);
        return cmp;
    }

    private void buildTable(Composite parent) {
        this.table = new Table(parent, 68100);
        this.table.setHeaderVisible(true);
        GridData gd = new GridData(1808);
        gd.heightHint = 400;
        gd.widthHint = 300;
        this.table.setLayoutData((Object)gd);
        this.table.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                StrokesDialog.this.editButton.push();
            }
        });
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new StrokeLabelProvider());
        TableColumn column = new TableColumn(this.table, 0);
        column.setText("Stroke");
        column.pack();
    }

    private final class EditElement
    implements IEditElement<Object> {
        private EditElement() {
        }

        public void editElement(List<Object> input, int pos) {
            Object v = input.get(pos);
            if (v == null) {
                return;
            }
            StrokeDialog dialog = new StrokeDialog(StrokesDialog.this.table.getShell());
            dialog.setValue((Stroke)v);
            if (dialog.open() == 0) {
                input.set(pos, dialog.getValue());
            }
        }
    }
}

