/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.model.theme.util;

import com.jaspersoft.studio.components.chart.model.theme.util.FrameCheckBoxPropertyDescriptor;
import com.jaspersoft.studio.components.chart.model.theme.util.FrameDoublePropertyDescriptor;
import com.jaspersoft.studio.components.chart.model.theme.util.FramePaintProviderPropertyDescriptor;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.DefaultValue;
import com.jaspersoft.studio.property.section.AbstractSection;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.chartthemes.simple.BlockBorderProvider;
import net.sf.jasperreports.chartthemes.simple.BlockFrameProvider;
import net.sf.jasperreports.chartthemes.simple.ColorProvider;
import net.sf.jasperreports.chartthemes.simple.LegendSettings;
import net.sf.jasperreports.chartthemes.simple.LineBorderProvider;
import net.sf.jasperreports.chartthemes.simple.PaintProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.jfree.chart.block.BlockFrame;
import org.jfree.ui.RectangleInsets;

public class PadUtil {
    public static final RectangleInsets RECTANGLE_INSETS = new RectangleInsets(0.0, 0.0, 0.0, 0.0);
    public static final String PADDING_RIGHT = "paddingRIGHT";
    public static final String PADDING_LEFT = "paddingLEFT";
    public static final String PADDING_BOTTOM = "paddingBOTTOM";
    public static final String PADDING_TOP = "paddingTOP";
    public static final String FRAME_STROKE = "RectangleFrameStroke";
    public static final String FRAME_FILL = "RectangleFrameFill";
    public static final String FRAME_COLOR = "RectangleFrameColor";
    public static final Map<String, DefaultValue> frameDefaultValues = new HashMap<String, DefaultValue>();

    static {
        String preID = "frame";
        frameDefaultValues.put(String.valueOf(preID) + FRAME_STROKE, new DefaultValue((Object)1.0, false));
        frameDefaultValues.put(String.valueOf(preID) + FRAME_FILL, new DefaultValue((Object)true, false));
        frameDefaultValues.put(String.valueOf(preID) + FRAME_COLOR, new DefaultValue((Object)new ColorProvider(new Color(0, 0, 0)), false));
        frameDefaultValues.put(String.valueOf(preID) + PADDING_TOP, new DefaultValue((Object)0.0, false));
        frameDefaultValues.put(String.valueOf(preID) + PADDING_BOTTOM, new DefaultValue((Object)0.0, false));
        frameDefaultValues.put(String.valueOf(preID) + PADDING_LEFT, new DefaultValue((Object)0.0, false));
        frameDefaultValues.put(String.valueOf(preID) + PADDING_RIGHT, new DefaultValue((Object)0.0, false));
    }

    public static void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        PadUtil.createPropertyDescriptors(desc, Messages.common_padding);
    }

    public static void createPropertyDescriptors(List<IPropertyDescriptor> desc, String prefix) {
        PadUtil.createPropertyDescriptors(desc, "", prefix);
    }

    public static void createPropertyDescriptors(List<IPropertyDescriptor> desc, String preID, String category) {
        FrameDoublePropertyDescriptor pd = new FrameDoublePropertyDescriptor(String.valueOf(preID) + PADDING_TOP, Messages.common_top);
        pd.setDescription(Messages.common_top);
        pd.setCategory(category);
        desc.add((IPropertyDescriptor)pd);
        pd = new FrameDoublePropertyDescriptor(String.valueOf(preID) + PADDING_BOTTOM, Messages.common_bottom);
        pd.setDescription(Messages.common_bottom);
        pd.setCategory(category);
        desc.add((IPropertyDescriptor)pd);
        pd = new FrameDoublePropertyDescriptor(String.valueOf(preID) + PADDING_LEFT, Messages.common_left);
        pd.setDescription(Messages.common_left);
        pd.setCategory(category);
        desc.add((IPropertyDescriptor)pd);
        pd = new FrameDoublePropertyDescriptor(String.valueOf(preID) + PADDING_RIGHT, Messages.common_right);
        pd.setDescription(Messages.common_right);
        pd.setCategory(category);
        desc.add((IPropertyDescriptor)pd);
    }

    public static void createDefaults(String preID, Map<String, DefaultValue> defaultsMap) {
        defaultsMap.put(String.valueOf(preID) + PADDING_TOP, new DefaultValue((Object)0.0, false));
        defaultsMap.put(String.valueOf(preID) + PADDING_BOTTOM, new DefaultValue((Object)0.0, false));
        defaultsMap.put(String.valueOf(preID) + PADDING_LEFT, new DefaultValue((Object)0.0, false));
        defaultsMap.put(String.valueOf(preID) + PADDING_RIGHT, new DefaultValue((Object)0.0, false));
        defaultsMap.putAll(frameDefaultValues);
    }

    public static void createBlockFramePropertyDescriptors(List<IPropertyDescriptor> desc, String category) {
        String preID = "frame";
        PadUtil.createPropertyDescriptors(desc, preID, category);
        Object pd = new FrameDoublePropertyDescriptor(String.valueOf(preID) + FRAME_STROKE, Messages.MLinePen_line_width);
        pd.setDescription(Messages.MLinePen_line_width);
        pd.setCategory(category);
        desc.add((IPropertyDescriptor)pd);
        pd = new FrameCheckBoxPropertyDescriptor(String.valueOf(preID) + FRAME_FILL, Messages.common_fill);
        pd.setDescription(Messages.common_fill);
        pd.setCategory(category);
        desc.add((IPropertyDescriptor)pd);
        pd = new FramePaintProviderPropertyDescriptor(String.valueOf(preID) + FRAME_COLOR, Messages.common_line_color);
        pd.setDescription(Messages.common_line_color);
        pd.setCategory(category);
        desc.add((IPropertyDescriptor)pd);
    }

    public static Object getBlockFrameValue(Object id, BlockFrameProvider provider) {
        if (provider == null) {
            return frameDefaultValues.get(id);
        }
        String preID = "frame";
        if (id.equals(String.valueOf(preID) + FRAME_FILL)) {
            return !(provider instanceof LineBorderProvider);
        }
        if (id.equals(String.valueOf(preID) + FRAME_STROKE)) {
            if (provider instanceof LineBorderProvider) {
                BasicStroke stroke = (BasicStroke)((LineBorderProvider)provider).getLineStroke();
                return stroke != null ? Float.valueOf(stroke.getLineWidth()) : null;
            }
            return null;
        }
        if (id.equals(String.valueOf(preID) + FRAME_COLOR)) {
            return PadUtil.getPaint(provider);
        }
        return PadUtil.getPropertyValue(id, provider.getBlockFrame().getInsets(), preID);
    }

    public static void setFramePropertyValue(Object id, Object value, LegendSettings settings) {
        if (settings == null) {
            return;
        }
        String preID = "frame";
        if (id.equals(String.valueOf(preID) + FRAME_FILL)) {
            BlockBorderProvider fillFrame;
            BlockFrameProvider currentFrame;
            PadUtil.checkValidFrame(settings);
            Boolean fill = (Boolean)value;
            if (fill.booleanValue() && !(settings.getBlockFrame() instanceof BlockBorderProvider)) {
                currentFrame = settings.getFrame();
                fillFrame = new BlockBorderProvider(PadUtil.getFrameInstets(currentFrame), PadUtil.getPaint(currentFrame));
                settings.setFrame((BlockFrameProvider)fillFrame);
            }
            if (!fill.booleanValue() && !(settings.getBlockFrame() instanceof LineBorderProvider)) {
                currentFrame = settings.getFrame();
                fillFrame = new LineBorderProvider(PadUtil.getFrameInstets(currentFrame), (Stroke)new BasicStroke(1.0f), PadUtil.getPaint(currentFrame));
                settings.setFrame((BlockFrameProvider)fillFrame);
            }
        } else if (id.equals(String.valueOf(preID) + FRAME_STROKE)) {
            PadUtil.checkValidFrame(settings);
            if (settings.getFrame() instanceof LineBorderProvider) {
                LineBorderProvider currentFrame = (LineBorderProvider)settings.getFrame();
                if (value == null) {
                    value = 0.0;
                }
                float strokeValue = ((Number)value).floatValue();
                currentFrame.setLineStroke((Stroke)new BasicStroke(strokeValue));
                settings.setFrame(null);
                settings.setFrame((BlockFrameProvider)currentFrame);
            }
        } else if (id.equals(String.valueOf(preID) + FRAME_COLOR)) {
            PadUtil.checkValidFrame(settings);
            PadUtil.setFrameColor(settings.getFrame(), (PaintProvider)value, settings);
        } else if (id.equals(String.valueOf(preID) + PADDING_TOP) || id.equals(String.valueOf(preID) + PADDING_BOTTOM) || id.equals(String.valueOf(preID) + PADDING_LEFT) || id.equals(String.valueOf(preID) + PADDING_RIGHT)) {
            PadUtil.checkValidFrame(settings);
            RectangleInsets newInsets = PadUtil.setPropertyValue(id, value, settings.getFrame().getBlockFrame().getInsets(), preID);
            if (newInsets != null) {
                PadUtil.setFrameInstets(newInsets, settings.getFrame(), settings);
            }
        }
    }

    private static void setFrameInstets(RectangleInsets newInsets, BlockFrameProvider provider, LegendSettings settings) {
        if (provider instanceof BlockBorderProvider) {
            BlockBorderProvider newProvider = new BlockBorderProvider(newInsets, ((BlockBorderProvider)provider).getPaint());
            settings.setFrame((BlockFrameProvider)newProvider);
        } else if (provider instanceof LineBorderProvider) {
            LineBorderProvider oldProvider = (LineBorderProvider)provider;
            LineBorderProvider newProvider = new LineBorderProvider(newInsets, oldProvider.getLineStroke(), oldProvider.getPaint());
            settings.setFrame((BlockFrameProvider)newProvider);
        }
    }

    private static void checkValidFrame(LegendSettings settigns) {
        if (settigns.getFrame() == null) {
            BlockBorderProvider fillFrame = new BlockBorderProvider(RECTANGLE_INSETS, (PaintProvider)new ColorProvider(new Color(0, 0, 0)));
            settigns.setFrame((BlockFrameProvider)fillFrame);
        }
    }

    private static void setFrameColor(BlockFrameProvider provider, PaintProvider color, LegendSettings settings) {
        if (provider instanceof LineBorderProvider) {
            ((LineBorderProvider)provider).setPaint(color);
        } else if (provider instanceof BlockBorderProvider) {
            ((BlockBorderProvider)provider).setPaint(color);
        }
        settings.setFrame(null);
        settings.setFrame(provider);
    }

    private static RectangleInsets getFrameInstets(BlockFrameProvider provider) {
        if (provider == null) {
            return null;
        }
        BlockFrame frame = provider.getBlockFrame();
        if (frame == null) {
            return null;
        }
        return frame.getInsets();
    }

    private static PaintProvider getPaint(BlockFrameProvider provider) {
        if (provider instanceof LineBorderProvider) {
            return ((LineBorderProvider)provider).getPaint();
        }
        if (provider instanceof BlockBorderProvider) {
            return ((BlockBorderProvider)provider).getPaint();
        }
        return null;
    }

    public static Object getPropertyValue(Object id, RectangleInsets ri) {
        return PadUtil.getPropertyValue(id, ri, "");
    }

    public static Object getPropertyValue(Object id, RectangleInsets ri, String preID) {
        if (ri == null) {
            ri = RECTANGLE_INSETS;
        }
        if (id.equals(String.valueOf(preID) + PADDING_TOP)) {
            return ri.getTop();
        }
        if (id.equals(String.valueOf(preID) + PADDING_BOTTOM)) {
            return ri.getBottom();
        }
        if (id.equals(String.valueOf(preID) + PADDING_LEFT)) {
            return ri.getLeft();
        }
        if (id.equals(String.valueOf(preID) + PADDING_RIGHT)) {
            return ri.getRight();
        }
        return null;
    }

    public static RectangleInsets setPropertyValue(Object id, Object value, RectangleInsets ri) {
        return PadUtil.setPropertyValue(id, value, ri, "");
    }

    public static RectangleInsets setPropertyValue(Object id, Object value, RectangleInsets ri, String preID) {
        if (ri == null) {
            ri = RECTANGLE_INSETS;
        }
        if (value == null) {
            value = 0.0;
        }
        if (id.equals(String.valueOf(preID) + PADDING_TOP)) {
            return new RectangleInsets(((Double)value).doubleValue(), ri.getLeft(), ri.getBottom(), ri.getRight());
        }
        if (id.equals(String.valueOf(preID) + PADDING_BOTTOM)) {
            return new RectangleInsets(ri.getTop(), ri.getLeft(), ((Double)value).doubleValue(), ri.getRight());
        }
        if (id.equals(String.valueOf(preID) + PADDING_LEFT)) {
            return new RectangleInsets(ri.getTop(), ((Double)value).doubleValue(), ri.getBottom(), ri.getRight());
        }
        if (id.equals(String.valueOf(preID) + PADDING_RIGHT)) {
            return new RectangleInsets(ri.getTop(), ri.getLeft(), ri.getBottom(), ((Double)value).doubleValue());
        }
        return null;
    }

    public static Composite createWidgets4Property(Composite parent, String preID, String prefix, AbstractSection section) {
        Composite group = section.getWidgetFactory().createSection(parent, prefix, true, 4);
        ((Section)group.getParent()).setExpanded(false);
        section.createWidget4Property(group, (Object)(String.valueOf(preID) + PADDING_TOP));
        section.createWidget4Property(group, (Object)(String.valueOf(preID) + PADDING_BOTTOM));
        section.createWidget4Property(group, (Object)(String.valueOf(preID) + PADDING_LEFT));
        section.createWidget4Property(group, (Object)(String.valueOf(preID) + PADDING_RIGHT));
        return group;
    }
}

