/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.preferences;

import com.jaspersoft.studio.components.chart.preferences.ChartCustomizerSelectionDialog;
import com.jaspersoft.studio.help.TableHelpListener;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.preferences.editor.table.TableFieldEditor;
import com.jaspersoft.studio.wizards.ContextHelpIDs;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class ChartCustomizerListFieldEditor
extends TableFieldEditor {
    private List<String> items = new ArrayList<String>();

    public ChartCustomizerListFieldEditor(String name, Composite parent) {
        super(name, "", new String[]{"Chart Customizer Class"}, new int[]{100}, parent);
    }

    protected String createList(String[][] items) {
        return "";
    }

    protected String[][] parseString(String string) {
        return new String[0][0];
    }

    protected String[] getNewInputObject() {
        ChartCustomizerSelectionDialog fd = new ChartCustomizerSelectionDialog(UIUtils.getShell(), "Select the definition file", "Select the Chart Customizer definition file");
        if (fd.open() == 0) {
            String selection = fd.getSelectedResource();
            this.items.add(selection);
            return new String[]{selection};
        }
        return null;
    }

    protected void doStore() {
        String v = "";
        for (String srv : this.items) {
            v = String.valueOf(v) + Base64.encodeBase64String((byte[])srv.getBytes()) + "\n";
        }
        this.getPreferenceStore().setValue("com.jaspersoft.studio.components.chart.customizers", v);
    }

    protected void doLoad() {
        if (this.getTable() != null) {
            this.items.clear();
            String v = null;
            v = this.getPreferenceStore().getString("com.jaspersoft.studio.components.chart.customizers");
            if (v != null) {
                String[] stringArray = v.split("\n");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    if (!line.isEmpty()) {
                        try {
                            String srv = new String(Base64.decodeBase64((String)line));
                            this.items.add(srv);
                            TableItem tableItem = new TableItem(this.getTable(), 0);
                            tableItem.setText(new String[]{srv});
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    ++n2;
                }
            }
            TableHelpListener.setTableHelp((Table)this.getTable());
        }
    }

    protected void doLoadDefault() {
    }

    protected void adjustForNumColumns(int numColumns) {
        super.adjustForNumColumns(numColumns);
        ((GridData)this.getLabelControl().getLayoutData()).exclude = true;
        this.getLabelControl().setVisible(false);
    }

    protected boolean isFieldEditable(int col, int row) {
        return false;
    }

    protected void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, ContextHelpIDs.PREFERENCES_PROPERTIES);
    }

    public void createSelectionListener() {
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Widget widget = event.widget;
                if (widget == ChartCustomizerListFieldEditor.this.addButton) {
                    ChartCustomizerListFieldEditor.this.addPressed();
                } else if (widget == ChartCustomizerListFieldEditor.this.removeButton) {
                    ChartCustomizerListFieldEditor.this.removePressed();
                } else if (widget == ChartCustomizerListFieldEditor.this.table) {
                    ChartCustomizerListFieldEditor.this.selectionChanged();
                }
            }
        };
    }

    protected void removePressed() {
        int selIdx = this.table.getSelectionIndex();
        if (selIdx >= 0) {
            this.items.remove(selIdx);
        }
        super.removePressed();
    }

    protected boolean isEditable(int row) {
        return false;
    }

    protected void createButtons(Composite box) {
        this.addButton = this.createPushButton(box, Messages.common_add);
        this.removeButton = this.createPushButton(box, Messages.common_delete);
    }
}

